/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.drill.common.exceptions.ChildErrorContext;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorEvents;
import org.apache.drill.exec.physical.impl.scan.file.ImplicitColumnManager;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiatorImpl;
import org.apache.drill.exec.physical.impl.scan.framework.ShimBatchReader;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanFramework
extends ManagedScanFramework {
    private static final Logger logger = LoggerFactory.getLogger(FileScanFramework.class);
    private ImplicitColumnManager metadataManager;
    private DrillFileSystem dfs;
    private final List<FileSplit> splits = new ArrayList<FileSplit>();
    private Iterator<FileSplit> splitIter;
    private FileSplit currentSplit;

    public FileScanFramework(FileScanBuilder builder) {
        super(builder);
        assert (builder.files != null);
        assert (builder.fsConf != null);
    }

    public FileScanBuilder options() {
        return (FileScanBuilder)this.builder;
    }

    @Override
    protected void configure() {
        super.configure();
        FileScanBuilder options = this.options();
        try {
            this.dfs = this.context.newFileSystem(options.fsConf);
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).addContext("Failed to create FileSystem").build(logger);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (FileWork work : options.files) {
            Path path = this.dfs.makeQualified(work.getPath());
            paths.add(path);
            FileSplit split = new FileSplit(path, work.getStart(), work.getLength(), new String[]{""});
            this.splits.add(split);
        }
        this.splitIter = this.splits.iterator();
        options.implicitColumnOptions().setFiles(paths);
        this.metadataManager = new ImplicitColumnManager(this.context.getFragmentContext().getOptions(), options.implicitColumnOptions(), this.dfs);
        this.builder.withImplicitColumns(this.metadataManager);
    }

    protected FileSplit nextSplit() {
        if (!this.splitIter.hasNext()) {
            this.currentSplit = null;
            return null;
        }
        this.currentSplit = this.splitIter.next();
        this.metadataManager.startFile(this.currentSplit.getPath());
        return this.currentSplit;
    }

    @Override
    protected SchemaNegotiatorImpl newNegotiator() {
        return new FileSchemaNegotiatorImpl(this);
    }

    @Override
    public boolean open(ShimBatchReader shimBatchReader) {
        try {
            return super.open(shimBatchReader);
        }
        catch (UserException e) {
            throw e;
        }
        catch (Exception e) {
            throw UserException.executionError(e).addContext("File", this.currentSplit.getPath().toString()).build(logger);
        }
    }

    public DrillFileSystem fileSystem() {
        return this.dfs;
    }

    public static class FileScanBuilder
    extends ManagedScanFramework.ScanFrameworkBuilder {
        private List<? extends FileWork> files;
        private Configuration fsConf;
        private final ImplicitColumnManager.ImplicitColumnOptions metadataOptions = new ImplicitColumnManager.ImplicitColumnOptions();

        public void setFileSystemConfig(Configuration fsConf) {
            this.fsConf = fsConf;
        }

        public void setFiles(List<? extends FileWork> files) {
            this.files = files;
        }

        public ImplicitColumnManager.ImplicitColumnOptions implicitColumnOptions() {
            return this.metadataOptions;
        }

        @Override
        public ScanOperatorEvents buildEvents() {
            return new FileScanFramework(this);
        }
    }

    public static class FileSchemaNegotiatorImpl
    extends SchemaNegotiatorImpl
    implements FileSchemaNegotiator {
        private final FileSplit split;

        public FileSchemaNegotiatorImpl(FileScanFramework framework) {
            super(framework);
            this.split = framework.currentSplit;
            this.context = new FileRowSetContext(this.parentErrorContext(), this.split);
        }

        @Override
        public DrillFileSystem fileSystem() {
            return ((FileScanFramework)this.framework).dfs;
        }

        @Override
        public FileSplit split() {
            return this.split;
        }
    }

    public static abstract class FileReaderFactory
    implements ManagedScanFramework.ReaderFactory {
        private FileScanFramework fileFramework;

        @Override
        public void bind(ManagedScanFramework baseFramework) {
            this.fileFramework = (FileScanFramework)baseFramework;
        }

        @Override
        public ManagedReader<? extends SchemaNegotiator> next() {
            if (this.fileFramework.nextSplit() == null) {
                return null;
            }
            return this.newReader();
        }

        public CustomErrorContext errorContext() {
            return this.fileFramework == null ? null : this.fileFramework.errorContext();
        }

        public abstract ManagedReader<? extends FileSchemaNegotiator> newReader();

        protected Optional<FileScanFramework> fileFramework() {
            return Optional.ofNullable(this.fileFramework);
        }
    }

    public static class FileRowSetContext
    extends ChildErrorContext {
        private final FileSplit split;

        public FileRowSetContext(CustomErrorContext parent, FileSplit split) {
            super(parent);
            this.split = split;
        }

        @Override
        public void addContext(UserException.Builder builder) {
            super.addContext(builder);
            builder.addContext("File:", Path.getPathWithoutSchemeAndAuthority((Path)this.split.getPath()).toString());
            if (this.split.getStart() != 0L) {
                builder.addContext("Offset:", this.split.getStart());
            }
        }
    }

    public static interface FileSchemaNegotiator
    extends SchemaNegotiator {
        public DrillFileSystem fileSystem();

        public FileSplit split();
    }
}

