/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.file;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadataColumn;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadataColumnDefn;
import org.apache.drill.exec.physical.impl.scan.file.ImplicitColumnManager;
import org.apache.drill.exec.physical.impl.scan.file.PartitionColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.resultSet.project.RequestedColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetadataColumnsParser
implements ScanLevelProjection.ScanProjectionParser {
    private static final Logger logger = LoggerFactory.getLogger(FileMetadataColumnsParser.class);
    private final ImplicitColumnManager metadataManager;
    private final Pattern partitionPattern;
    private ScanLevelProjection builder;
    private final Set<Integer> referencedPartitions = new HashSet<Integer>();
    private boolean hasImplicitCols;

    public FileMetadataColumnsParser(ImplicitColumnManager metadataManager) {
        this.metadataManager = metadataManager;
        this.partitionPattern = Pattern.compile(metadataManager.partitionDesignator + "(\\d+)", 2);
    }

    @Override
    public void bind(ScanLevelProjection builder) {
        this.builder = builder;
    }

    @Override
    public boolean parse(RequestedColumn inCol) {
        Matcher m = this.partitionPattern.matcher(inCol.name());
        if (m.matches()) {
            return this.buildPartitionColumn(m, inCol);
        }
        FileMetadataColumnDefn defn = this.metadataManager.fileMetadataColIndex.get(inCol.name());
        if (defn != null) {
            return this.buildMetadataColumn(defn, inCol);
        }
        return false;
    }

    private boolean buildPartitionColumn(Matcher m, RequestedColumn inCol) {
        if (!inCol.isSimple()) {
            logger.warn("Partition column {} is shadowed by a projected {}", (Object)inCol.name(), (Object)inCol.toString());
            return false;
        }
        int partitionIndex = Integer.parseInt(m.group(1));
        if (!this.referencedPartitions.contains(partitionIndex)) {
            this.builder.addMetadataColumn(new PartitionColumn(inCol.name(), partitionIndex));
            this.referencedPartitions.add(partitionIndex);
            this.hasImplicitCols = true;
        }
        return true;
    }

    private boolean buildMetadataColumn(FileMetadataColumnDefn defn, RequestedColumn inCol) {
        if (!inCol.isSimple()) {
            logger.warn("File metadata column {} is shadowed by a projected {}", (Object)inCol.name(), (Object)inCol.toString());
            return false;
        }
        this.builder.addMetadataColumn(new FileMetadataColumn(inCol.name(), defn));
        this.hasImplicitCols = true;
        return true;
    }

    @Override
    public void validate() {
        if (this.builder.projectAll() && this.metadataManager.options().useLegacyWildcardExpansion) {
            this.expandPartitions();
        }
    }

    private void expandPartitions() {
        for (int i = 0; i < this.metadataManager.partitionCount(); ++i) {
            if (this.referencedPartitions.contains(i)) continue;
            this.builder.addMetadataColumn(new PartitionColumn(this.metadataManager.partitionName(i), i));
            this.referencedPartitions.add(i);
        }
        this.hasImplicitCols = true;
    }

    @Override
    public void validateColumn(ColumnProjection outCol) {
    }

    @Override
    public void build() {
    }

    public boolean hasImplicitCols() {
        return this.hasImplicitCols;
    }
}

