/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.file;

import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileMetadata {
    private final Path filePath;
    private final String[] dirPath;
    private final FileSystem fs;

    public FileMetadata(Path filePath, Path selectionRoot) {
        this(filePath, selectionRoot, null);
    }

    public FileMetadata(Path filePath, Path selectionRoot, FileSystem fs) {
        Path bareFilePath;
        this.filePath = filePath;
        this.fs = fs;
        if (selectionRoot == null || filePath == null) {
            this.dirPath = null;
            return;
        }
        Path rootPath = Path.getPathWithoutSchemeAndAuthority((Path)selectionRoot);
        if (rootPath.equals((Object)(bareFilePath = Path.getPathWithoutSchemeAndAuthority((Path)filePath)))) {
            this.dirPath = null;
            return;
        }
        this.dirPath = ColumnExplorer.parsePartitions(filePath, rootPath, false);
        if (this.dirPath == null) {
            throw new IllegalArgumentException(String.format("Selection root of \"%s\" is not a leading path of \"%s\"", selectionRoot.toString(), filePath.toString()));
        }
    }

    public Path filePath() {
        return this.filePath;
    }

    public String partition(int index) {
        if (this.dirPath == null || this.dirPath.length <= index) {
            return null;
        }
        return this.dirPath[index];
    }

    public int dirPathLength() {
        return this.dirPath == null ? 0 : this.dirPath.length;
    }

    public boolean isSet() {
        return this.filePath != null;
    }

    public String getImplicitColumnValue(ColumnExplorer.ImplicitFileColumn column) {
        return ColumnExplorer.getImplicitColumnValue(column, this.filePath, this.fs);
    }
}

