/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.convert;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.drill.exec.physical.impl.scan.convert.DirectConverter;
import org.apache.drill.exec.vector.accessor.InvalidConversionError;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class ConvertTimeToString
extends DirectConverter {
    private final DateTimeFormatter dateTimeFormatter;

    public ConvertTimeToString(ScalarWriter baseWriter) {
        super(baseWriter);
        String formatValue = baseWriter.schema().format();
        this.dateTimeFormatter = formatValue == null ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ofPattern(formatValue);
    }

    @Override
    public void setTime(LocalTime value) {
        if (value == null) {
            this.baseWriter.setNull();
        } else {
            try {
                this.baseWriter.setString(this.dateTimeFormatter.format(value));
            }
            catch (Exception e) {
                throw InvalidConversionError.writeError(this.schema(), value, e);
            }
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setNull();
        } else {
            this.setTime((LocalTime)value);
        }
    }
}

