/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.convert;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.drill.exec.physical.impl.scan.convert.AbstractConvertFromString;
import org.apache.drill.exec.vector.accessor.InvalidConversionError;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class ConvertStringToTimeStamp
extends AbstractConvertFromString {
    private final DateTimeFormatter dateTimeFormatter;

    public ConvertStringToTimeStamp(ScalarWriter baseWriter, Map<String, String> properties) {
        super(baseWriter, properties);
        this.dateTimeFormatter = baseWriter.schema().dateTimeFormatter();
    }

    @Override
    public void setString(String value) {
        String prepared = (String)this.prepare.apply(value);
        if (prepared == null) {
            return;
        }
        try {
            this.baseWriter.setTimestamp(LocalDateTime.parse(value, this.dateTimeFormatter).toInstant(ZoneOffset.UTC));
        }
        catch (Exception e) {
            throw InvalidConversionError.writeError(this.schema(), value, e);
        }
    }
}

