/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.convert;

import java.util.Map;
import java.util.function.Function;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.convert.DirectConverter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConvertFromString
extends DirectConverter {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractConvertFromString.class);
    protected final Function<String, String> prepare;

    public AbstractConvertFromString(ScalarWriter baseWriter) {
        this(baseWriter, null);
    }

    public AbstractConvertFromString(ScalarWriter baseWriter, Map<String, String> properties) {
        super(baseWriter);
        this.prepare = this.buildPrepare(baseWriter.schema(), properties);
    }

    private Function<String, String> buildPrepare(ColumnMetadata schema, Map<String, String> properties) {
        String blankProp;
        String string = blankProp = properties == null ? null : properties.get("drill.blank-as");
        if (blankProp != null) {
            switch (blankProp.toLowerCase()) {
                case "0": {
                    if (!Types.isNumericType(schema.type())) {
                        return this.skipBlankFn(schema);
                    }
                    if (schema.isNullable()) {
                        return this.nullableBlankToZeroFn();
                    }
                    return this.blankToZeroFn();
                }
                case "null": {
                    if (schema.isNullable()) {
                        return this.blankToNullFn();
                    }
                    return this.skipBlankFn(schema);
                }
            }
            logger.warn("Invalid conversion option '{}', skipping", (Object)blankProp);
        }
        if (schema.isNullable()) {
            return this.nullableStrFn();
        }
        return AbstractConvertFromString.skipBlanksFn();
    }

    private Function<String, String> skipBlankFn(ColumnMetadata schema) {
        if (schema.isNullable()) {
            return this.blankToNullFn();
        }
        return this.skipBlankFn();
    }

    private static Function<String, String> skipBlanksFn() {
        return s -> {
            if (s == null) {
                return null;
            }
            return (s = s.trim()).isEmpty() ? null : s;
        };
    }

    private Function<String, String> nullableStrFn() {
        return s -> {
            if (s == null) {
                this.setNull();
                return null;
            }
            return s.trim();
        };
    }

    private Function<String, String> blankToNullFn() {
        return s -> {
            if (s == null) {
                this.setNull();
                return null;
            }
            if ((s = s.trim()).isEmpty()) {
                this.setNull();
                return null;
            }
            return s;
        };
    }

    private Function<String, String> skipBlankFn() {
        return s -> {
            if (s == null) {
                return null;
            }
            return (s = s.trim()).isEmpty() ? null : s;
        };
    }

    private Function<String, String> nullableBlankToZeroFn() {
        return s -> {
            if (s == null) {
                this.setNull();
                return null;
            }
            return (s = s.trim()).isEmpty() ? "0" : s;
        };
    }

    private Function<String, String> blankToZeroFn() {
        return s -> {
            if (s == null) {
                return null;
            }
            return (s = s.trim()).isEmpty() ? "0" : s;
        };
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setNull();
        } else {
            this.setString((String)value);
        }
    }

    @Override
    public void setBytes(byte[] bytes, int length) {
        this.setString(new String(bytes, 0, length, Charsets.UTF_8));
    }
}

