/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.columns;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.columns.ColumnsArrayParser;
import org.apache.drill.exec.physical.impl.scan.columns.ResolvedColumnsArrayColumn;
import org.apache.drill.exec.physical.impl.scan.columns.UnresolvedColumnsArrayColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class ColumnsArrayManager
implements ReaderLevelProjection.ReaderProjectionResolver {
    private final ColumnsArrayParser parser;

    public ColumnsArrayManager(boolean requireColumnsArray, boolean allowOtherCols) {
        this.parser = new ColumnsArrayParser(requireColumnsArray, allowOtherCols);
    }

    @VisibleForTesting
    public ColumnsArrayManager(boolean requireColumnsArray) {
        this(requireColumnsArray, false);
    }

    public ScanLevelProjection.ScanProjectionParser projectionParser() {
        return this.parser;
    }

    public ReaderLevelProjection.ReaderProjectionResolver resolver() {
        return this;
    }

    @Override
    public void startResolution() {
    }

    @Override
    public boolean resolveColumn(ColumnProjection col, ResolvedTuple outputTuple, TupleMetadata tableSchema) {
        if (!(col instanceof UnresolvedColumnsArrayColumn)) {
            return false;
        }
        if (this.hasColumnsArrayColumn() && tableSchema.size() != 1) {
            throw new IllegalStateException("Table schema must have exactly one column.");
        }
        int tabColIndex = tableSchema.index("columns");
        if (tabColIndex == -1) {
            throw new IllegalStateException("Table schema must include only one column named `columns`");
        }
        MaterializedField tableCol = tableSchema.column(tabColIndex);
        if (tableCol.getType().getMode() != TypeProtos.DataMode.REPEATED) {
            throw new IllegalStateException("Table schema column `columns` is of mode " + tableCol.getType().getMode() + " but expected " + TypeProtos.DataMode.REPEATED);
        }
        outputTuple.add(new ResolvedColumnsArrayColumn((UnresolvedColumnsArrayColumn)col, tableCol, (VectorSource)outputTuple, tabColIndex));
        return true;
    }

    public boolean[] elementProjection() {
        UnresolvedColumnsArrayColumn columnsArrayCol = this.parser.columnsArrayCol();
        return columnsArrayCol == null ? null : columnsArrayCol.selectedIndexes();
    }

    public boolean hasColumnsArrayColumn() {
        return this.parser.columnsArrayCol() != null;
    }
}

