/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.rangepartitioner;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.RangePartitionSender;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangePartitionRecordBatch
extends AbstractSingleRecordBatch<RangePartitionSender> {
    static final Logger logger = LoggerFactory.getLogger(RangePartitionRecordBatch.class);
    private final int numPartitions;
    private int recordCount;
    private final IntVector partitionIdVector;
    private final List<TransferPair> transfers;

    public RangePartitionRecordBatch(RangePartitionSender popConfig, RecordBatch incoming, FragmentContext context) throws OutOfMemoryException {
        super(popConfig, context, incoming);
        this.numPartitions = popConfig.getDestinations().size();
        FieldReference outputPath = popConfig.getPartitionFunction().getPartitionFieldRef();
        MaterializedField outputField = MaterializedField.create(outputPath.getAsNamePart().getName(), Types.required(TypeProtos.MinorType.INT));
        this.partitionIdVector = (IntVector)TypeHelper.getNewVector(outputField, this.oContext.getAllocator());
        this.transfers = Lists.newArrayList();
    }

    @Override
    public void close() {
        super.close();
        this.partitionIdVector.clear();
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        int num = this.incoming.getRecordCount();
        if (num > 0) {
            this.setupPartitionCols(this.incoming);
            this.partitionIdVector.allocateNew(num);
            this.recordCount = this.projectRecords(num, 0);
            this.container.setValueCount(this.recordCount);
        }
        return RecordBatch.IterOutcome.OK;
    }

    @Override
    protected boolean setupNewSchema() {
        this.container.clear();
        for (VectorWrapper vw : this.incoming) {
            TransferPair tp = vw.getValueVector().getTransferPair(this.oContext.getAllocator());
            this.transfers.add(tp);
            this.container.add(tp.getTo());
        }
        this.container.add(this.partitionIdVector);
        this.container.buildSchema(this.incoming.getSchema().getSelectionVectorMode());
        return true;
    }

    private void setupPartitionCols(VectorAccessible batch) {
        ArrayList<VectorWrapper<?>> partitionCols = Lists.newArrayList();
        for (VectorWrapper vw : batch) {
            if (!this.isPartitioningColumn(vw.getField().getName())) continue;
            partitionCols.add(vw);
        }
        ((RangePartitionSender)this.popConfig).getPartitionFunction().setup(partitionCols);
    }

    private boolean isPartitioningColumn(String name) {
        List<FieldReference> refList = ((RangePartitionSender)this.popConfig).getPartitionFunction().getPartitionRefList();
        for (FieldReference f : refList) {
            if (!f.getRootSegment().getPath().equals(name)) continue;
            return true;
        }
        return false;
    }

    private int getPartition(int index) {
        return ((RangePartitionSender)this.popConfig).getPartitionFunction().eval(index, this.numPartitions);
    }

    private final int projectRecords(int recordCount, int firstOutputIndex) {
        int countN = recordCount;
        int counter = 0;
        int i = 0;
        while (i < countN) {
            int partition = this.getPartition(i);
            this.partitionIdVector.getMutator().setSafe(i, partition);
            ++counter;
            ++i;
            ++firstOutputIndex;
        }
        for (TransferPair t : this.transfers) {
            t.transfer();
        }
        return counter;
    }

    @Override
    public void dump() {
        logger.error("RangePartitionRecordBatch[container={}, numPartitions={}, recordCount={}, partitionIdVector={}]", new Object[]{this.container, this.numPartitions, this.recordCount, this.partitionIdVector});
    }
}

