/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.protocol;

import java.util.Collections;
import java.util.Iterator;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.impl.protocol.SchemaTracker;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;

public class VectorContainerAccessor
implements BatchAccessor {
    protected VectorContainer container;
    private final SchemaTracker schemaTracker = new SchemaTracker();
    private int batchCount;

    public void setSchema(VectorContainer container) {
        this.container = container;
        if (container != null) {
            this.schemaTracker.trackSchema(container);
        }
    }

    public void addBatch(VectorContainer container) {
        this.setSchema(container);
        if (container != null) {
            ++this.batchCount;
        }
    }

    public int batchCount() {
        return this.batchCount;
    }

    @Override
    public BatchSchema schema() {
        return this.container == null ? null : this.container.getSchema();
    }

    @Override
    public int schemaVersion() {
        return this.schemaTracker.schemaVersion();
    }

    @Override
    public int rowCount() {
        return this.container == null ? 0 : this.container.getRecordCount();
    }

    @Override
    public VectorContainer container() {
        return this.container;
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    @Override
    public WritableBatch writableBatch() {
        return WritableBatch.get(this.container);
    }

    @Override
    public SelectionVector2 selectionVector2() {
        return this.container.getSelectionVector2();
    }

    @Override
    public SelectionVector4 selectionVector4() {
        return this.container.getSelectionVector4();
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        if (this.container == null) {
            return Collections.emptyIterator();
        }
        return this.container.iterator();
    }

    @Override
    public void release() {
        if (this.container != null) {
            this.container.zeroVectors();
        }
    }
}

