/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.protocol;

import java.util.Iterator;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.impl.protocol.OperatorDriver;
import org.apache.drill.exec.physical.impl.protocol.OperatorExec;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorRecordBatch
implements CloseableRecordBatch {
    static final Logger logger = LoggerFactory.getLogger(OperatorRecordBatch.class);
    private final OperatorDriver driver;
    private final BatchAccessor batchAccessor;
    private RecordBatch.IterOutcome lastOutcome;

    public OperatorRecordBatch(FragmentContext context, PhysicalOperator config, OperatorExec opExec, boolean enableSchemaBatch) {
        OperatorContext opContext = context.newOperatorContext(config);
        opContext.getStats().startProcessing();
        try {
            opExec.bind(opContext);
            this.driver = new OperatorDriver(opContext, opExec, enableSchemaBatch);
            this.batchAccessor = opExec.batchAccessor();
        }
        catch (UserException e) {
            opContext.close();
            throw e;
        }
        catch (Throwable t) {
            opContext.close();
            throw UserException.executionError(t).addContext("Exception thrown from", opExec.getClass().getSimpleName() + ".bind()").build(logger);
        }
        finally {
            opContext.getStats().stopProcessing();
        }
    }

    @Override
    public FragmentContext getContext() {
        return this.fragmentContext();
    }

    public FragmentContext fragmentContext() {
        return this.driver.operatorContext().getFragmentContext();
    }

    @Override
    public BatchSchema getSchema() {
        return this.batchAccessor.schema();
    }

    @Override
    public int getRecordCount() {
        return this.batchAccessor.rowCount();
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.batchAccessor.container();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.batchAccessor.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.batchAccessor.getValueAccessorById(clazz, ids);
    }

    @Override
    public WritableBatch getWritableBatch() {
        return this.batchAccessor.writableBatch();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        return this.batchAccessor.selectionVector2();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        return this.batchAccessor.selectionVector4();
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.batchAccessor.iterator();
    }

    @Override
    public void cancel() {
        this.driver.cancel();
    }

    @Override
    public RecordBatch.IterOutcome next() {
        try {
            this.driver.operatorContext().getStats().startProcessing();
            RecordBatch.IterOutcome iterOutcome = this.lastOutcome = this.driver.next();
            return iterOutcome;
        }
        finally {
            this.driver.operatorContext().getStats().stopProcessing();
        }
    }

    @Override
    public void close() {
        this.driver.close();
    }

    @Override
    public VectorContainer getContainer() {
        return this.batchAccessor.container();
    }

    @Override
    public void dump() {
        logger.error("OperatorRecordBatch[batchAccessor={}, lastOutcome={}]", (Object)this.batchAccessor, (Object)this.lastOutcome);
    }
}

