/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.protocol;

import org.apache.drill.exec.physical.impl.protocol.VectorContainerAccessor;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class IndirectContainerAccessor
extends VectorContainerAccessor {
    private SelectionVector2 sv2;
    private SelectionVector4 sv4;

    public void addBatch(RecordBatch batch) {
        this.addBatch(batch.getContainer());
        switch (this.container.getSchema().getSelectionVectorMode()) {
            case TWO_BYTE: {
                this.setSelectionVector(batch.getSelectionVector2());
                break;
            }
            case FOUR_BYTE: {
                this.setSelectionVector(batch.getSelectionVector4());
                break;
            }
        }
    }

    public void setSelectionVector(SelectionVector2 sv2) {
        Preconditions.checkState(this.sv4 == null);
        this.sv2 = sv2;
    }

    public void setSelectionVector(SelectionVector4 sv4) {
        Preconditions.checkState(this.sv2 == null);
        this.sv4 = sv4;
    }

    @Override
    public SelectionVector2 selectionVector2() {
        return this.sv2;
    }

    @Override
    public SelectionVector4 selectionVector4() {
        return this.sv4;
    }

    @Override
    public int rowCount() {
        if (this.sv2 != null) {
            return this.sv2.getCount();
        }
        if (this.sv4 != null) {
            return this.sv4.getCount();
        }
        return super.rowCount();
    }

    @Override
    public void release() {
        super.release();
        if (this.sv2 != null) {
            this.sv2.clear();
            this.sv2 = null;
        }
        if (this.sv4 != null) {
            this.sv4.clear();
            this.sv4 = null;
        }
    }
}

