/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import java.util.List;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.project.Projector;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public abstract class ProjectorTemplate
implements Projector {
    private ImmutableList<TransferPair> transfers;
    private SelectionVector2 vector2;
    private SelectionVector4 vector4;
    private BatchSchema.SelectionVectorMode svMode;

    @Override
    public final int projectRecords(RecordBatch incomingRecordBatch, int startIndex, int recordCount, int firstOutputIndex) {
        assert (incomingRecordBatch != this);
        switch (this.svMode) {
            case FOUR_BYTE: {
                throw new UnsupportedOperationException();
            }
            case TWO_BYTE: {
                int count = recordCount;
                int i = 0;
                while (i < count) {
                    try {
                        this.doEval(this.vector2.getIndex(i), firstOutputIndex);
                    }
                    catch (SchemaChangeException e) {
                        throw new UnsupportedOperationException(e);
                    }
                    ++i;
                    ++firstOutputIndex;
                }
                return recordCount;
            }
            case NONE: {
                int countN = recordCount;
                int i = startIndex;
                while (i < startIndex + countN) {
                    try {
                        this.doEval(i, firstOutputIndex);
                    }
                    catch (SchemaChangeException e) {
                        throw new UnsupportedOperationException(e);
                    }
                    ++i;
                    ++firstOutputIndex;
                }
                int totalBatchRecordCount = incomingRecordBatch.getRecordCount();
                if (startIndex + recordCount < totalBatchRecordCount || startIndex > 0) {
                    for (TransferPair t : this.transfers) {
                        t.splitAndTransfer(startIndex, i - startIndex);
                    }
                    return i - startIndex;
                }
                for (TransferPair t : this.transfers) {
                    t.transfer();
                }
                return recordCount;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setup(FragmentContext context, RecordBatch incoming, RecordBatch outgoing, List<TransferPair> transfers) throws SchemaChangeException {
        this.svMode = incoming.getSchema().getSelectionVectorMode();
        switch (this.svMode) {
            case FOUR_BYTE: {
                this.vector4 = incoming.getSelectionVector4();
                break;
            }
            case TWO_BYTE: {
                this.vector2 = incoming.getSelectionVector2();
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.transfers = ImmutableList.copyOf(transfers);
        this.doSetup(context, incoming, outgoing);
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") RecordBatch var2, @Named(value="outgoing") RecordBatch var3) throws SchemaChangeException;

    public abstract void doEval(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;

    public String toString() {
        return "Projector[vector2=" + this.vector2 + ", selectionVectorMode=" + (Object)((Object)this.svMode) + "]";
    }
}

