/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import com.carrotsearch.hppc.IntHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.fn.FunctionReplacementUtils;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.project.Projector;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectionMaterializer {
    private static final Logger logger = LoggerFactory.getLogger(ProjectionMaterializer.class);
    private static final String EMPTY_STRING = "";
    private final ClassGenerator<Projector> cg;
    private final VectorAccessible incomingBatch;
    private final BatchSchema incomingSchema;
    private final List<NamedExpression> exprSpec;
    private final FunctionLookupContext functionLookupContext;
    private final BatchBuilder batchBuilder;
    private final boolean unionTypeEnabled;
    private final ErrorCollector collector = new ErrorCollectorImpl();
    private final ColumnExplorer columnExplorer;
    private final IntHashSet transferFieldIds = new IntHashSet();
    private final ClassifierResult result = new ClassifierResult();
    private boolean isAnyWildcard;
    private boolean classify;

    public ProjectionMaterializer(OptionManager options, VectorAccessible incomingBatch, List<NamedExpression> exprSpec, FunctionLookupContext functionLookupContext, BatchBuilder batchBuilder, boolean unionTypeEnabled) {
        this.incomingBatch = incomingBatch;
        this.incomingSchema = incomingBatch.getSchema();
        this.exprSpec = exprSpec;
        this.functionLookupContext = functionLookupContext;
        this.batchBuilder = batchBuilder;
        this.unionTypeEnabled = unionTypeEnabled;
        this.columnExplorer = new ColumnExplorer(options);
        this.cg = CodeGenerator.getRoot(Projector.TEMPLATE_DEFINITION, options);
    }

    public Projector generateProjector(FragmentContext context, boolean saveCode) {
        long setupNewSchemaStartTime = System.currentTimeMillis();
        this.setup();
        CodeGenerator<Projector> codeGen = this.cg.getCodeGenerator();
        codeGen.plainJavaCapable(true);
        codeGen.saveCodeForDebugging(saveCode);
        Projector projector = context.getImplementationClass(codeGen);
        long setupNewSchemaEndTime = System.currentTimeMillis();
        logger.trace("generateProjector: time {}  ms, Project {}, incoming {}", new Object[]{setupNewSchemaEndTime - setupNewSchemaStartTime, this.exprSpec, this.incomingSchema});
        return projector;
    }

    private void setup() {
        List<NamedExpression> exprs = this.exprSpec != null ? this.exprSpec : this.inferExpressions();
        this.isAnyWildcard = this.isAnyWildcard(exprs);
        this.classify = this.isClassificationNeeded(exprs);
        for (NamedExpression namedExpression : exprs) {
            this.setupExpression(namedExpression);
        }
    }

    private List<NamedExpression> inferExpressions() {
        ArrayList<NamedExpression> exprs = new ArrayList<NamedExpression>();
        for (MaterializedField field : this.incomingSchema) {
            String fieldName = field.getName();
            if (Types.isComplex(field.getType()) || Types.isRepeated(field.getType())) {
                LogicalExpression convertToJson = FunctionCallFactory.createConvert("convert_to", "JSON", SchemaPath.getSimplePath(fieldName), ExpressionPosition.UNKNOWN);
                String castFuncName = FunctionReplacementUtils.getCastFunc(TypeProtos.MinorType.VARCHAR);
                ArrayList<LogicalExpression> castArgs = new ArrayList<LogicalExpression>();
                castArgs.add(convertToJson);
                castArgs.add(new ValueExpressions.LongExpression(65535L, null));
                FunctionCall castCall = new FunctionCall(castFuncName, castArgs, ExpressionPosition.UNKNOWN);
                exprs.add(new NamedExpression(castCall, new FieldReference(fieldName)));
                continue;
            }
            exprs.add(new NamedExpression(SchemaPath.getSimplePath(fieldName), new FieldReference(fieldName)));
        }
        return exprs;
    }

    private boolean isAnyWildcard(List<NamedExpression> exprs) {
        for (NamedExpression e : exprs) {
            if (!this.isWildcard(e)) continue;
            return true;
        }
        return false;
    }

    private boolean isWildcard(NamedExpression ex) {
        if (!(ex.getExpr() instanceof SchemaPath)) {
            return false;
        }
        PathSegment.NameSegment expr = ((SchemaPath)ex.getExpr()).getRootSegment();
        return expr.getPath().contains("**");
    }

    private boolean isClassificationNeeded(List<NamedExpression> exprs) {
        boolean needed = false;
        for (NamedExpression ex : exprs) {
            if (!(ex.getExpr() instanceof SchemaPath)) continue;
            PathSegment.NameSegment expr = ((SchemaPath)ex.getExpr()).getRootSegment();
            PathSegment.NameSegment ref = ex.getRef().getRootSegment();
            boolean refHasPrefix = ref.getPath().contains("\u00a6\u00a6");
            boolean exprContainsStar = expr.getPath().contains("**");
            if (!refHasPrefix && !exprContainsStar) continue;
            needed = true;
            break;
        }
        return needed;
    }

    private void setupExpression(NamedExpression namedExpression) {
        String outputName;
        this.result.clear();
        if (this.classify && namedExpression.getExpr() instanceof SchemaPath) {
            this.classifyExpr(namedExpression, this.result);
            if (this.result.isStar) {
                this.setupImplicitColumnRef(namedExpression);
                return;
            }
        } else {
            this.result.outputNames = new ArrayList();
            outputName = this.getRef(namedExpression).getRootSegment().getPath();
            this.addToResultMaps(outputName, this.result, true);
        }
        outputName = this.getRef(namedExpression).getRootSegment().getPath();
        if (this.result != null && this.result.outputNames != null && this.result.outputNames.size() > 0) {
            boolean isMatched = false;
            for (int j = 0; j < this.result.outputNames.size(); ++j) {
                if (((String)this.result.outputNames.get(j)).isEmpty()) continue;
                outputName = (String)this.result.outputNames.get(j);
                isMatched = true;
                break;
            }
            if (!isMatched) {
                return;
            }
        }
        LogicalExpression expr = ExpressionTreeMaterializer.materialize(namedExpression.getExpr(), this.incomingBatch, this.collector, this.functionLookupContext, true, this.unionTypeEnabled);
        this.collector.reportErrors(logger);
        if (expr instanceof ValueVectorReadExpression && this.incomingSchema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.NONE && !((ValueVectorReadExpression)expr).hasReadPath() && !this.isAnyWildcard && !this.transferFieldIds.contains(((ValueVectorReadExpression)expr).getFieldId().getFieldIds()[0])) {
            this.setupDirectTransfer(namedExpression, expr);
        } else if (expr instanceof DrillFuncHolderExpr && ((DrillFuncHolderExpr)expr).getHolder().isComplexWriterFuncHolder()) {
            this.setupFnCall(namedExpression, expr);
        } else {
            this.setupExprEval(namedExpression, expr, outputName);
        }
    }

    private void setupImplicitColumnRef(NamedExpression namedExpression) {
        block5: {
            Integer value;
            block4: {
                value = (Integer)this.result.prefixMap.get(this.result.prefix);
                if (value == null || value != 1) break block4;
                int k = 0;
                for (VectorWrapper wrapper : this.incomingBatch) {
                    Object vvIn = wrapper.getValueVector();
                    if (k > this.result.outputNames.size() - 1) assert (false);
                    String name = (String)this.result.outputNames.get(k++);
                    if (name.isEmpty() || this.isImplicitFileColumn(vvIn.getField())) continue;
                    this.batchBuilder.addTransferField(name, (ValueVector)vvIn);
                }
                break block5;
            }
            if (value == null || value <= 1) break block5;
            int k = 0;
            for (MaterializedField field : this.incomingSchema) {
                SchemaPath originalPath = SchemaPath.getSimplePath(field.getName());
                if (k > this.result.outputNames.size() - 1) assert (false);
                String name = (String)this.result.outputNames.get(k++);
                if (name.isEmpty() || this.isImplicitFileColumn(field)) continue;
                LogicalExpression expr = ExpressionTreeMaterializer.materialize(originalPath, this.incomingBatch, this.collector, this.functionLookupContext);
                this.collector.reportErrors(logger);
                ValueVectorWriteExpression write = this.batchBuilder.addOutputVector(name, expr);
                this.cg.addExpr(write, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND);
            }
        }
    }

    private void setupDirectTransfer(NamedExpression namedExpression, LogicalExpression expr) {
        FieldReference ref = this.getRef(namedExpression);
        int fid = this.batchBuilder.addDirectTransfer(ref, (ValueVectorReadExpression)expr);
        this.transferFieldIds.add(fid);
    }

    private void setupFnCall(NamedExpression namedExpression, LogicalExpression expr) {
        ((DrillFuncHolderExpr)expr).setFieldReference(namedExpression.getRef());
        this.cg.addExpr(expr, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND);
        this.batchBuilder.addComplexField(namedExpression.getRef());
    }

    private void setupExprEval(NamedExpression namedExpression, LogicalExpression expr, String outputName) {
        ValueVectorWriteExpression write = this.batchBuilder.addEvalVector(outputName, expr);
        this.cg.addExpr(write, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND);
    }

    private boolean isImplicitFileColumn(MaterializedField field) {
        return this.columnExplorer.isImplicitOrInternalFileColumn(field.getName());
    }

    private void classifyExpr(NamedExpression ex, ClassifierResult result) {
        PathSegment.NameSegment expr = ((SchemaPath)ex.getExpr()).getRootSegment();
        PathSegment.NameSegment ref = ex.getRef().getRootSegment();
        boolean exprHasPrefix = expr.getPath().contains("\u00a6\u00a6");
        boolean refHasPrefix = ref.getPath().contains("\u00a6\u00a6");
        boolean exprIsStar = expr.getPath().equals("**");
        boolean refContainsStar = ref.getPath().contains("**");
        boolean exprContainsStar = expr.getPath().contains("**");
        boolean refEndsWithStar = ref.getPath().endsWith("**");
        String exprPrefix = EMPTY_STRING;
        String exprSuffix = expr.getPath();
        if (exprHasPrefix) {
            String[] exprComponents = expr.getPath().split("\u00a6\u00a6", 2);
            assert (exprComponents.length == 2);
            exprPrefix = exprComponents[0];
            exprSuffix = exprComponents[1];
            result.prefix = exprPrefix;
        }
        boolean exprIsFirstWildcard = false;
        if (exprContainsStar) {
            result.isStar = true;
            Integer value = (Integer)result.prefixMap.get(exprPrefix);
            if (value == null) {
                result.prefixMap.put(exprPrefix, 1);
                exprIsFirstWildcard = true;
            } else {
                result.prefixMap.put(exprPrefix, value + 1);
            }
        }
        int incomingSchemaSize = this.incomingSchema.getFieldCount();
        if (exprIsStar && refHasPrefix && refEndsWithStar) {
            String[] components = ref.getPath().split("\u00a6\u00a6", 2);
            assert (components.length == 2);
            String prefix = components[0];
            result.outputNames = new ArrayList();
            for (MaterializedField field : this.incomingSchema) {
                String name = field.getName();
                String newName = prefix + "\u00a6\u00a6" + name;
                this.addToResultMaps(newName, result, false);
            }
        } else if (expr.getPath().equalsIgnoreCase(ref.getPath()) && (!exprContainsStar || exprIsFirstWildcard)) {
            if (exprContainsStar && exprHasPrefix) {
                assert (exprPrefix != null);
                int k = 0;
                result.outputNames = new ArrayList(incomingSchemaSize);
                for (int j = 0; j < incomingSchemaSize; ++j) {
                    result.outputNames.add(EMPTY_STRING);
                }
                for (MaterializedField field : this.incomingSchema) {
                    String incomingName = field.getName();
                    String[] nameComponents = incomingName.split("\u00a6\u00a6", 2);
                    if (nameComponents.length <= 1) {
                        ++k;
                        continue;
                    }
                    String namePrefix = nameComponents[0];
                    if (exprPrefix.equalsIgnoreCase(namePrefix) && !result.outputMap.containsKey((Object)incomingName)) {
                        result.outputNames.set(k, incomingName);
                        result.outputMap.put((Object)incomingName, (Object)incomingName);
                    }
                    ++k;
                }
            } else {
                result.outputNames = new ArrayList();
                if (exprContainsStar) {
                    for (MaterializedField field : this.incomingSchema) {
                        String incomingName = field.getName();
                        if (refContainsStar) {
                            this.addToResultMaps(incomingName, result, true);
                            continue;
                        }
                        this.addToResultMaps(incomingName, result, false);
                    }
                } else {
                    String newName = expr.getPath();
                    if (!refHasPrefix && !exprHasPrefix) {
                        this.addToResultMaps(newName, result, true);
                    } else {
                        this.addToResultMaps(newName, result, false);
                    }
                }
            }
        } else if (exprIsStar) {
            result.outputNames = new ArrayList();
            for (MaterializedField field : this.incomingSchema) {
                String incomingName = field.getName();
                this.addToResultMaps(incomingName, result, true);
            }
        } else if (!exprHasPrefix && refHasPrefix) {
            result.outputNames = new ArrayList();
            String newName = ref.getPath();
            this.addToResultMaps(newName, result, false);
        } else if (exprHasPrefix && !refHasPrefix) {
            int k = 0;
            result.outputNames = new ArrayList(incomingSchemaSize);
            for (int j = 0; j < incomingSchemaSize; ++j) {
                result.outputNames.add(EMPTY_STRING);
            }
            for (MaterializedField field : this.incomingSchema) {
                String name = field.getName();
                String[] components = name.split("\u00a6\u00a6", 2);
                if (components.length <= 1) {
                    ++k;
                    continue;
                }
                String namePrefix = components[0];
                String nameSuffix = components[1];
                if (exprPrefix.equalsIgnoreCase(namePrefix)) {
                    String newName;
                    if (refContainsStar) {
                        newName = this.getUniqueName(nameSuffix, result);
                        result.outputNames.set(k, newName);
                    } else if (exprSuffix.equalsIgnoreCase(nameSuffix)) {
                        newName = ref.getPath();
                        result.outputNames.set(k, newName);
                    }
                } else {
                    result.outputNames.add(EMPTY_STRING);
                }
                ++k;
            }
        } else if (exprHasPrefix && refHasPrefix) {
            String[] input = expr.getPath().split("\u00a6\u00a6", 2);
            assert (input.length == 2);
            assert (false) : "Unexpected project expression or reference";
        } else {
            result.outputNames = new ArrayList();
            for (MaterializedField field : this.incomingSchema) {
                String incomingName = field.getName();
                if (!expr.getPath().equalsIgnoreCase(incomingName)) continue;
                String newName = ref.getPath();
                this.addToResultMaps(newName, result, true);
            }
        }
    }

    private String getUniqueName(String name, ClassifierResult result) {
        Integer currentSeq = (Integer)result.sequenceMap.get((Object)name);
        if (currentSeq == null) {
            result.sequenceMap.put((Object)name, (Object)-1);
            return name;
        }
        int newSeq = currentSeq + 1;
        String newName = name + newSeq;
        result.sequenceMap.put((Object)name, (Object)newSeq);
        result.sequenceMap.put((Object)newName, (Object)-1);
        return newName;
    }

    private void addToResultMaps(String origName, ClassifierResult result, boolean allowDupsWithRename) {
        String name = origName;
        if (allowDupsWithRename) {
            name = this.getUniqueName(origName, result);
        }
        if (!result.outputMap.containsKey((Object)name)) {
            result.outputNames.add(name);
            result.outputMap.put((Object)name, (Object)name);
        } else {
            result.outputNames.add(EMPTY_STRING);
        }
    }

    private FieldReference getRef(NamedExpression e) {
        return e.getRef();
    }

    private static class ClassifierResult {
        private boolean isStar;
        private List<String> outputNames;
        private String prefix = "";
        private final HashMap<String, Integer> prefixMap = Maps.newHashMap();
        private final CaseInsensitiveMap outputMap = new CaseInsensitiveMap();
        private final CaseInsensitiveMap sequenceMap = new CaseInsensitiveMap();

        private ClassifierResult() {
        }

        private void clear() {
            this.isStar = false;
            this.prefix = ProjectionMaterializer.EMPTY_STRING;
            if (this.outputNames != null) {
                this.outputNames.clear();
            }
        }
    }

    public static interface BatchBuilder {
        public void addTransferField(String var1, ValueVector var2);

        public ValueVectorWriteExpression addOutputVector(String var1, LogicalExpression var2);

        public int addDirectTransfer(FieldReference var1, ValueVectorReadExpression var2);

        public void addComplexField(FieldReference var1);

        public ValueVectorWriteExpression addEvalVector(String var1, LogicalExpression var2);
    }
}

