/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.physical.impl.project.ProjectRecordBatch;
import org.apache.drill.exec.physical.impl.project.ProjectionMaterializer;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.apache.drill.exec.vector.UntypedNullHolder;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ProjectBatchBuilder
implements ProjectionMaterializer.BatchBuilder {
    private final ProjectRecordBatch projectBatch;
    private final VectorContainer container;
    private final SchemaChangeCallBack callBack;
    private final RecordBatch incomingBatch;
    private final List<TransferPair> transfers = new ArrayList<TransferPair>();

    public ProjectBatchBuilder(ProjectRecordBatch projectBatch, VectorContainer container, SchemaChangeCallBack callBack, RecordBatch incomingBatch) {
        this.projectBatch = projectBatch;
        this.container = container;
        this.callBack = callBack;
        this.incomingBatch = incomingBatch;
    }

    public List<TransferPair> transfers() {
        return this.transfers;
    }

    @Override
    public void addTransferField(String name, ValueVector vvIn) {
        FieldReference ref = new FieldReference(name);
        Object vvOut = this.container.addOrGet(MaterializedField.create(ref.getAsNamePart().getName(), vvIn.getField().getType()), this.callBack);
        this.projectBatch.memoryManager.addTransferField(vvIn, vvIn.getField().getName(), vvOut.getField().getName());
        this.transfers.add(vvIn.makeTransferPair((ValueVector)vvOut));
    }

    @Override
    public int addDirectTransfer(FieldReference ref, ValueVectorReadExpression vectorRead) {
        TypedFieldId id = vectorRead.getFieldId();
        Object vvIn = this.incomingBatch.getValueAccessorById(id.getIntermediateClass(), id.getFieldIds()).getValueVector();
        Preconditions.checkNotNull(this.incomingBatch);
        Object vvOut = this.container.addOrGet(MaterializedField.create(ref.getLastSegment().getNameSegment().getPath(), vectorRead.getMajorType()), this.callBack);
        TransferPair tp = vvIn.makeTransferPair((ValueVector)vvOut);
        this.projectBatch.memoryManager.addTransferField((ValueVector)vvIn, TypedFieldId.getPath(id, this.incomingBatch), vvOut.getField().getName());
        this.transfers.add(tp);
        return vectorRead.getFieldId().getFieldIds()[0];
    }

    @Override
    public ValueVectorWriteExpression addOutputVector(String name, LogicalExpression expr) {
        MaterializedField outputField = MaterializedField.create(name, expr.getMajorType());
        Object vv = this.container.addOrGet(outputField, this.callBack);
        this.projectBatch.allocationVectors.add((ValueVector)vv);
        TypedFieldId fid = this.container.getValueVectorId(SchemaPath.getSimplePath(outputField.getName()));
        ValueVectorWriteExpression write = new ValueVectorWriteExpression(fid, expr, true);
        this.projectBatch.memoryManager.addNewField((ValueVector)vv, write);
        return write;
    }

    @Override
    public void addComplexField(FieldReference ref) {
        if (this.projectBatch.rsLoader == null) {
            this.initComplexWriters();
        }
        if (this.projectBatch.complexFieldReferencesList == null) {
            this.projectBatch.complexFieldReferencesList = Lists.newArrayList();
        } else {
            this.projectBatch.complexFieldReferencesList.clear();
        }
        Object lateVv = this.container.addOrGet(MaterializedField.create(ref.getLastSegment().getNameSegment().getPath(), UntypedNullHolder.TYPE), this.callBack);
        this.projectBatch.allocationVectors.add((ValueVector)lateVv);
        this.projectBatch.complexFieldReferencesList.add(ref);
        this.projectBatch.memoryManager.addComplexField(null);
    }

    private void initComplexWriters() {
        if (this.projectBatch.complexWriters == null) {
            this.projectBatch.complexWriters = new ArrayList<BaseWriter.ComplexWriter>();
        } else {
            this.projectBatch.complexWriters.clear();
        }
    }

    @Override
    public ValueVectorWriteExpression addEvalVector(String outputName, LogicalExpression expr) {
        ValueVectorReadExpression vectorRead;
        MaterializedField outputField = MaterializedField.create(outputName, expr.getMajorType());
        Object ouputVector = this.container.addOrGet(outputField, this.callBack);
        this.projectBatch.allocationVectors.add((ValueVector)ouputVector);
        TypedFieldId fid = this.container.getValueVectorId(SchemaPath.getSimplePath(outputField.getName()));
        boolean useSetSafe = !(ouputVector instanceof FixedWidthVector);
        ValueVectorWriteExpression write = new ValueVectorWriteExpression(fid, expr, useSetSafe);
        this.projectBatch.memoryManager.addNewField((ValueVector)ouputVector, write);
        if (expr instanceof ValueVectorReadExpression && !(vectorRead = (ValueVectorReadExpression)expr).hasReadPath()) {
            TypedFieldId id = vectorRead.getFieldId();
            Object vvIn = this.incomingBatch.getValueAccessorById(id.getIntermediateClass(), id.getFieldIds()).getValueVector();
            vvIn.makeTransferPair((ValueVector)ouputVector);
        }
        return write;
    }
}

