/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.orderedpartitioner;

import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.orderedpartitioner.SampleSorter;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.QuickSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SampleSortTemplate
implements SampleSorter,
IndexedSortable {
    static final Logger logger = LoggerFactory.getLogger(SampleSortTemplate.class);
    SelectionVector2 vector2;

    public void setup(FragmentContext context, VectorContainer sampleBatch, SelectionVector2 vector2) throws SchemaChangeException {
        this.vector2 = vector2;
        this.doSetup(context, sampleBatch, null);
    }

    @Override
    public void sort(SelectionVector2 vector2, VectorContainer container) {
        QuickSort qs = new QuickSort();
        qs.sort((IndexedSortable)this, 0, vector2.getCount());
    }

    public void swap(int sv0, int sv1) {
        char tmp = this.vector2.getIndex(sv0);
        this.vector2.setIndex(sv0, this.vector2.getIndex(sv1));
        this.vector2.setIndex(sv1, tmp);
    }

    public int compare(int leftIndex, int rightIndex) {
        return this.doEval(leftIndex, rightIndex);
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") VectorContainer var2, @Named(value="outgoing") RecordBatch var3);

    public abstract int doEval(@Named(value="leftIndex") int var1, @Named(value="rightIndex") int var2);
}

