/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.orderedpartitioner;

import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.orderedpartitioner.SampleCopier;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SampleCopierTemplate
implements SampleCopier {
    static final Logger logger = LoggerFactory.getLogger(SampleCopierTemplate.class);
    private SelectionVector4 sv4;
    private int outputRecords;

    @Override
    public void setupCopier(FragmentContext context, SelectionVector4 sv4, VectorAccessible incoming, VectorAccessible outgoing) throws SchemaChangeException {
        this.sv4 = sv4;
        this.doSetup(context, incoming, outgoing);
    }

    @Override
    public int getOutputRecords() {
        return this.outputRecords;
    }

    @Override
    public boolean copyRecords(int skip, int start, int total) {
        int outgoingPosition = 0;
        int increment = skip > 0 ? skip : 1;
        int svIndex = start;
        while (svIndex < this.sv4.getCount() && this.outputRecords < total) {
            int deRefIndex = this.sv4.get(svIndex);
            if (!this.doEval(deRefIndex, outgoingPosition)) {
                return false;
            }
            ++this.outputRecords;
            svIndex += increment;
            ++outgoingPosition;
        }
        return true;
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") VectorAccessible var2, @Named(value="outgoing") VectorAccessible var3);

    public abstract boolean doEval(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2);
}

