/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.orderedpartitioner;

import java.util.List;
import javax.inject.Named;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.orderedpartitioner.OrderedPartitionProjector;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrderedPartitionProjectorTemplate
implements OrderedPartitionProjector {
    static final Logger logger = LoggerFactory.getLogger(OrderedPartitionProjectorTemplate.class);
    private ImmutableList<TransferPair> transfers;
    private int partitions;
    private BatchSchema.SelectionVectorMode svMode;
    private RecordBatch outBatch;
    private IntVector partitionValues;

    private int getPartition(int index) {
        int partitionIndex;
        try {
            for (partitionIndex = 0; partitionIndex < this.partitions - 1 && this.doEval(index, partitionIndex) >= 0; ++partitionIndex) {
            }
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
        return partitionIndex;
    }

    @Override
    public final int projectRecords(int recordCount, int firstOutputIndex) {
        int countN = recordCount;
        int counter = 0;
        int i = 0;
        while (i < countN) {
            int partition = this.getPartition(i);
            this.partitionValues.getMutator().setSafe(i, partition);
            ++counter;
            ++i;
            ++firstOutputIndex;
        }
        for (TransferPair t : this.transfers) {
            t.transfer();
        }
        return counter;
    }

    @Override
    public final void setup(FragmentContext context, VectorAccessible incoming, RecordBatch outgoing, List<TransferPair> transfers, VectorContainer partitionVectors, int partitions, SchemaPath outputField) throws SchemaChangeException {
        this.svMode = incoming.getSchema().getSelectionVectorMode();
        this.outBatch = outgoing;
        this.partitionValues = (IntVector)this.outBatch.getValueAccessorById(IntVector.class, this.outBatch.getValueVectorId(outputField).getFieldIds()).getValueVector();
        switch (this.svMode) {
            case FOUR_BYTE: 
            case TWO_BYTE: {
                throw new UnsupportedOperationException("Selection vector not supported");
            }
        }
        this.transfers = ImmutableList.copyOf(transfers);
        this.partitions = partitions;
        this.doSetup(context, incoming, outgoing, partitionVectors);
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") VectorAccessible var2, @Named(value="outgoing") RecordBatch var3, @Named(value="partitionVectors") VectorContainer var4) throws SchemaChangeException;

    public abstract int doEval(@Named(value="inIndex") int var1, @Named(value="partitionIndex") int var2) throws SchemaChangeException;
}

