/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.metadata;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.metastore.analyze.AnalyzeColumnUtils;
import org.apache.drill.exec.metastore.analyze.MetadataControllerContext;
import org.apache.drill.exec.metastore.analyze.MetadataIdentifierUtils;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.MetadataControllerPOP;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.record.AbstractBinaryRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.StatisticsRecordCollector;
import org.apache.drill.exec.store.StatisticsRecordWriterImpl;
import org.apache.drill.exec.store.easy.json.StatisticsCollectorImpl;
import org.apache.drill.exec.store.parquet.ParquetTableMetadataUtils;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.accessor.ArrayReader;
import org.apache.drill.exec.vector.accessor.ObjectReader;
import org.apache.drill.exec.vector.accessor.ObjectType;
import org.apache.drill.exec.vector.accessor.TupleReader;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.operate.Delete;
import org.apache.drill.metastore.operate.Modify;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.statistics.StatisticsKind;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataControllerBatch
extends AbstractBinaryRecordBatch<MetadataControllerPOP> {
    private static final Logger logger = LoggerFactory.getLogger(MetadataControllerBatch.class);
    private final Tables tables;
    private final TableInfo tableInfo;
    private final Map<String, MetadataInfo> metadataToHandle;
    private final StatisticsRecordCollector statisticsCollector = new StatisticsCollectorImpl();
    private final List<TableMetadataUnit> metadataUnits = new ArrayList<TableMetadataUnit>();
    private final ColumnNamesOptions columnNamesOptions;
    private State state = State.RIGHT;

    protected MetadataControllerBatch(MetadataControllerPOP popConfig, FragmentContext context, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, false, left, right);
        this.tables = context.getMetastoreRegistry().get().tables();
        this.tableInfo = popConfig.getContext().tableInfo();
        this.metadataToHandle = popConfig.getContext().metadataToHandle() == null ? null : popConfig.getContext().metadataToHandle().stream().collect(Collectors.toMap(MetadataInfo::identifier, Function.identity()));
        this.columnNamesOptions = new ColumnNamesOptions(context.getOptions());
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        block6: while (this.state != State.FINISHED) {
            switch (this.state) {
                case RIGHT: {
                    RecordBatch.IterOutcome outcome = this.handleRightIncoming();
                    if (outcome == null) continue block6;
                    return outcome;
                }
                case LEFT: {
                    RecordBatch.IterOutcome outcome = this.handleLeftIncoming();
                    if (outcome == null) continue block6;
                    return outcome;
                }
                case WRITE: {
                    this.writeToMetastore();
                    this.createSummary();
                    this.state = State.FINISHED;
                    return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                }
                case FINISHED: {
                    continue block6;
                }
            }
            throw new IllegalStateException(this.state.name());
        }
        return RecordBatch.IterOutcome.NONE;
    }

    private RecordBatch.IterOutcome handleRightIncoming() {
        block5: while (true) {
            RecordBatch.IterOutcome outcome = this.next(0, this.right);
            switch (outcome) {
                case NONE: {
                    this.state = State.LEFT;
                    break block5;
                }
                case NOT_YET: {
                    return outcome;
                }
                case OK_NEW_SCHEMA: 
                case OK: {
                    this.appendStatistics(this.statisticsCollector);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported upstream state " + (Object)((Object)outcome));
                }
            }
        }
        return null;
    }

    private RecordBatch.IterOutcome handleLeftIncoming() {
        RecordBatch.IterOutcome outcome;
        block5: while (true) {
            outcome = this.next(0, this.left);
            switch (outcome) {
                case NONE: {
                    this.state = State.WRITE;
                    return null;
                }
                case NOT_YET: {
                    return outcome;
                }
                case OK_NEW_SCHEMA: 
                case OK: {
                    this.metadataUnits.addAll(this.getMetadataUnits(this.left.getContainer()));
                    continue block5;
                }
            }
            break;
        }
        throw new UnsupportedOperationException("Unsupported upstream state " + (Object)((Object)outcome));
    }

    private void writeToMetastore() {
        MetadataControllerContext mdContext = ((MetadataControllerPOP)this.popConfig).getContext();
        FilterExpression deleteFilter = mdContext.tableInfo().toFilter();
        for (MetadataInfo metadataInfo : mdContext.metadataToRemove()) {
            deleteFilter = FilterExpression.and(deleteFilter, FilterExpression.equal(MetastoreColumn.METADATA_KEY, metadataInfo.key()));
        }
        Modify<TableMetadataUnit> modify = this.tables.modify();
        if (!((MetadataControllerPOP)this.popConfig).getContext().metadataToRemove().isEmpty()) {
            modify.delete(Delete.builder().metadataType(MetadataType.SEGMENT, MetadataType.FILE, MetadataType.ROW_GROUP, MetadataType.PARTITION).filter(deleteFilter).build());
        }
        MetastoreTableInfo metastoreTableInfo = mdContext.metastoreTableInfo();
        if (this.tables.basicRequests().hasMetastoreTableInfoChanged(metastoreTableInfo)) {
            throw UserException.executionError(null).message("Metadata for table [%s] was changed before analyze is finished", this.tableInfo.name()).build(logger);
        }
        modify.overwrite(this.metadataUnits).execute();
    }

    private void createSummary() {
        this.container.clear();
        BitVector bitVector = (BitVector)this.container.addOrGet("ok", Types.required(TypeProtos.MinorType.BIT), null);
        VarCharVector varCharVector = (VarCharVector)this.container.addOrGet("summary", Types.required(TypeProtos.MinorType.VARCHAR), null);
        bitVector.allocateNew();
        varCharVector.allocateNew();
        bitVector.getMutator().set(0, 1);
        varCharVector.getMutator().setSafe(0, String.format("Collected / refreshed metadata for table [%s.%s.%s]", ((MetadataControllerPOP)this.popConfig).getContext().tableInfo().storagePlugin(), ((MetadataControllerPOP)this.popConfig).getContext().tableInfo().workspace(), ((MetadataControllerPOP)this.popConfig).getContext().tableInfo().name()).getBytes(StandardCharsets.UTF_8));
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container.setValueCount(1);
    }

    private List<TableMetadataUnit> getMetadataUnits(VectorContainer container) {
        boolean insertDefaultSegment;
        ArrayList<TableMetadataUnit> metadataUnits = new ArrayList<TableMetadataUnit>();
        RowSetReader reader = DirectRowSet.fromContainer(container).reader();
        while (reader.next()) {
            metadataUnits.addAll(this.getMetadataUnits(reader, 0));
        }
        if (this.metadataToHandle != null) {
            metadataUnits = metadataUnits.stream().filter(tableMetadataUnit -> this.metadataToHandle.values().stream().map(MetadataInfo::key).anyMatch(s -> s.equals(tableMetadataUnit.metadataKey())) || MetadataType.TABLE.name().equals(tableMetadataUnit.metadataType())).collect(Collectors.toList());
            metadataUnits.stream().map(TableMetadataUnit::metadataIdentifier).forEach(this.metadataToHandle::remove);
            List metadata = this.metadataToHandle.isEmpty() ? Collections.emptyList() : this.tables.basicRequests().metadata(((MetadataControllerPOP)this.popConfig).getContext().tableInfo(), this.metadataToHandle.values());
            metadataUnits.addAll(metadata);
        }
        boolean bl = insertDefaultSegment = metadataUnits.size() > 1 && metadataUnits.stream().noneMatch(metadataUnit -> metadataUnit.metadataType().equals(MetadataType.SEGMENT.name()));
        if (insertDefaultSegment) {
            TableMetadataUnit defaultSegmentMetadata = this.getDefaultSegment(metadataUnits);
            metadataUnits.add(defaultSegmentMetadata);
        }
        return metadataUnits;
    }

    private TableMetadataUnit getDefaultSegment(List<TableMetadataUnit> metadataUnits) {
        TableMetadataUnit tableMetadataUnit = metadataUnits.stream().filter(metadataUnit -> metadataUnit.metadataType().equals(MetadataType.TABLE.name())).findAny().orElseThrow(() -> new IllegalStateException("Table metadata wasn't found among collected metadata."));
        List<String> paths = metadataUnits.stream().filter(metadataUnit -> metadataUnit.metadataType().equals(MetadataType.FILE.name())).map(TableMetadataUnit::path).collect(Collectors.toList());
        return tableMetadataUnit.toBuilder().metadataType(MetadataType.SEGMENT.name()).metadataKey("DEFAULT_SEGMENT").metadataIdentifier("DEFAULT_SEGMENT").owner(null).tableType(null).metadataStatistics(Collections.emptyList()).columnsStatistics(Collections.emptyMap()).path(tableMetadataUnit.location()).schema(null).locations(paths).build();
    }

    private List<TableMetadataUnit> getMetadataUnits(TupleReader reader, int nestingLevel) {
        BaseMetadata metadata;
        ArrayList<TableMetadataUnit> metadataUnits = new ArrayList<TableMetadataUnit>();
        TupleMetadata columnMetadata = reader.tupleSchema();
        ObjectReader metadataColumnReader = reader.column("metadataType");
        Preconditions.checkNotNull(metadataColumnReader, "metadataType column wasn't found");
        ObjectReader underlyingMetadataReader = reader.column("collectedMap");
        if (underlyingMetadataReader != null) {
            if (!underlyingMetadataReader.schema().isArray()) {
                throw new IllegalStateException("Incoming vector with name `collected_map` should be repeated map");
            }
            ArrayReader array = underlyingMetadataReader.array();
            while (array.next()) {
                metadataUnits.addAll(this.getMetadataUnits(array.tuple(), nestingLevel + 1));
            }
        }
        List<StatisticsHolder<?>> metadataStatistics = this.getMetadataStatistics(reader, columnMetadata);
        Long rowCount = metadataStatistics.stream().filter(statisticsHolder -> statisticsHolder.getStatisticsKind() == TableStatisticsKind.ROW_COUNT).findAny().map(StatisticsHolder::getStatisticsValue).orElse(null);
        Map<SchemaPath, ColumnStatistics<?>> columnStatistics = this.getColumnStatistics(reader, columnMetadata, rowCount);
        MetadataType metadataType = MetadataType.valueOf(metadataColumnReader.scalar().getString());
        switch (metadataType) {
            case TABLE: {
                metadata = this.getTableMetadata(reader, metadataStatistics, columnStatistics);
                break;
            }
            case SEGMENT: {
                metadata = this.getSegmentMetadata(reader, metadataStatistics, columnStatistics, nestingLevel);
                break;
            }
            case PARTITION: {
                metadata = this.getPartitionMetadata(reader, metadataStatistics, columnStatistics, nestingLevel);
                break;
            }
            case FILE: {
                metadata = this.getFileMetadata(reader, metadataStatistics, columnStatistics, nestingLevel);
                break;
            }
            case ROW_GROUP: {
                metadata = this.getRowGroupMetadata(reader, metadataStatistics, columnStatistics, nestingLevel);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported metadata type: " + (Object)((Object)metadataType));
            }
        }
        metadataUnits.add(metadata.toMetadataUnit());
        return metadataUnits;
    }

    private PartitionMetadata getPartitionMetadata(TupleReader reader, List<StatisticsHolder<?>> metadataStatistics, Map<SchemaPath, ColumnStatistics<?>> columnStatistics, int nestingLevel) {
        List<String> segmentColumns = ((MetadataControllerPOP)this.popConfig).getContext().segmentColumns();
        String segmentKey = segmentColumns.size() > 0 ? reader.column(segmentColumns.iterator().next()).scalar().getString() : "DEFAULT_SEGMENT";
        List<String> partitionValues = segmentColumns.stream().limit(nestingLevel).map(columnName -> reader.column((String)columnName).scalar().getString()).collect(Collectors.toList());
        String metadataIdentifier = MetadataIdentifierUtils.getMetadataIdentifierKey(partitionValues);
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.PARTITION).key(segmentKey).identifier((String)StringUtils.defaultIfEmpty((CharSequence)metadataIdentifier, null)).build();
        return ((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)PartitionMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(metadataInfo)).columnsStatistics(columnStatistics)).metadataStatistics(metadataStatistics)).locations(this.getIncomingLocations(reader)).lastModifiedTime(Long.parseLong(reader.column(this.columnNamesOptions.lastModifiedTime()).scalar().getString()))).schema(TupleMetadata.of(reader.column("schema").scalar().getString()))).build();
    }

    private BaseTableMetadata getTableMetadata(TupleReader reader, List<StatisticsHolder<?>> metadataStatistics, Map<SchemaPath, ColumnStatistics<?>> columnStatistics) {
        ArrayList updatedMetaStats = new ArrayList(metadataStatistics);
        updatedMetaStats.add(new StatisticsHolder<MetadataType>(((MetadataControllerPOP)this.popConfig).getContext().analyzeMetadataLevel(), (BaseStatisticsKind<?>)TableStatisticsKind.ANALYZE_METADATA_LEVEL));
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.TABLE).key("GENERAL_INFO").build();
        TableMetadata tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)BaseTableMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(metadataInfo)).columnsStatistics(columnStatistics)).metadataStatistics(updatedMetaStats)).partitionKeys(Collections.emptyMap()).interestingColumns(((MetadataControllerPOP)this.popConfig).getContext().interestingColumns()).location(((MetadataControllerPOP)this.popConfig).getContext().location()).lastModifiedTime(Long.parseLong(reader.column(this.columnNamesOptions.lastModifiedTime()).scalar().getString()))).schema(TupleMetadata.of(reader.column("schema").scalar().getString()))).build();
        if (this.context.getOptions().getOption(PlannerSettings.STATISTICS_USE)) {
            DrillStatsTable statistics = new DrillStatsTable(this.statisticsCollector.getStatistics());
            Map<SchemaPath, ColumnStatistics<?>> tableColumnStatistics = ParquetTableMetadataUtils.getColumnStatistics(tableMetadata.getSchema(), statistics);
            tableMetadata = tableMetadata.cloneWithStats((Map)tableColumnStatistics, (List)DrillStatsTable.getEstimatedTableStats(statistics));
        }
        return tableMetadata;
    }

    private SegmentMetadata getSegmentMetadata(TupleReader reader, List<StatisticsHolder<?>> metadataStatistics, Map<SchemaPath, ColumnStatistics<?>> columnStatistics, int nestingLevel) {
        String segmentKey;
        List<String> segmentColumns = ((MetadataControllerPOP)this.popConfig).getContext().segmentColumns();
        String string = segmentKey = segmentColumns.size() > 0 ? reader.column(segmentColumns.iterator().next()).scalar().getString() : "DEFAULT_SEGMENT";
        if (((MetadataControllerPOP)this.popConfig).getContext().multiValueSegments()) {
            nestingLevel = segmentColumns.size();
        }
        List<String> allPartitionValues = segmentColumns.stream().limit(nestingLevel).map(columnName -> reader.column((String)columnName).scalar().getString()).collect(Collectors.toList());
        String metadataIdentifier = MetadataIdentifierUtils.getMetadataIdentifierKey(allPartitionValues);
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.SEGMENT).key(segmentKey).identifier((String)StringUtils.defaultIfEmpty((CharSequence)metadataIdentifier, null)).build();
        int segmentLevel = nestingLevel - 1;
        List<String> partitionValues = ((MetadataControllerPOP)this.popConfig).getContext().multiValueSegments() ? allPartitionValues : Collections.singletonList(allPartitionValues.get(segmentLevel));
        return ((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)SegmentMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(metadataInfo)).columnsStatistics(columnStatistics)).metadataStatistics(metadataStatistics)).path(new Path(reader.column("location").scalar().getString())).locations(this.getIncomingLocations(reader)).column(segmentColumns.size() > 0 ? SchemaPath.getSimplePath(segmentColumns.get(segmentLevel)) : null).partitionValues(partitionValues).lastModifiedTime(Long.parseLong(reader.column(this.columnNamesOptions.lastModifiedTime()).scalar().getString()))).schema(TupleMetadata.of(reader.column("schema").scalar().getString()))).build();
    }

    private FileMetadata getFileMetadata(TupleReader reader, List<StatisticsHolder<?>> metadataStatistics, Map<SchemaPath, ColumnStatistics<?>> columnStatistics, int nestingLevel) {
        List<String> segmentColumns = ((MetadataControllerPOP)this.popConfig).getContext().segmentColumns();
        String segmentKey = segmentColumns.size() > 0 ? reader.column(segmentColumns.iterator().next()).scalar().getString() : "DEFAULT_SEGMENT";
        List<String> partitionValues = segmentColumns.stream().limit(nestingLevel - 1).map(columnName -> reader.column((String)columnName).scalar().getString()).collect(Collectors.toList());
        Path path = new Path(reader.column("location").scalar().getString());
        String metadataIdentifier = MetadataIdentifierUtils.getFileMetadataIdentifier(partitionValues, path);
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.FILE).key(segmentKey).identifier((String)StringUtils.defaultIfEmpty((CharSequence)metadataIdentifier, null)).build();
        return ((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)FileMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(metadataInfo)).columnsStatistics(columnStatistics)).metadataStatistics(metadataStatistics)).path(path).lastModifiedTime(Long.parseLong(reader.column(this.columnNamesOptions.lastModifiedTime()).scalar().getString()))).schema(TupleMetadata.of(reader.column("schema").scalar().getString()))).build();
    }

    private RowGroupMetadata getRowGroupMetadata(TupleReader reader, List<StatisticsHolder<?>> metadataStatistics, Map<SchemaPath, ColumnStatistics<?>> columnStatistics, int nestingLevel) {
        List<String> segmentColumns = ((MetadataControllerPOP)this.popConfig).getContext().segmentColumns();
        String segmentKey = segmentColumns.size() > 0 ? reader.column(segmentColumns.iterator().next()).scalar().getString() : "DEFAULT_SEGMENT";
        List<String> partitionValues = segmentColumns.stream().limit(nestingLevel - 2).map(columnName -> reader.column((String)columnName).scalar().getString()).collect(Collectors.toList());
        Path path = new Path(reader.column("location").scalar().getString());
        int rowGroupIndex = Integer.parseInt(reader.column(this.columnNamesOptions.rowGroupIndex()).scalar().getString());
        String metadataIdentifier = MetadataIdentifierUtils.getRowGroupMetadataIdentifier(partitionValues, path, rowGroupIndex);
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.ROW_GROUP).key(segmentKey).identifier((String)StringUtils.defaultIfEmpty((CharSequence)metadataIdentifier, null)).build();
        return ((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)RowGroupMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(metadataInfo)).columnsStatistics(columnStatistics)).metadataStatistics(metadataStatistics)).hostAffinity(Collections.emptyMap()).rowGroupIndex(rowGroupIndex).path(path).lastModifiedTime(Long.parseLong(reader.column(this.columnNamesOptions.lastModifiedTime()).scalar().getString()))).schema(TupleMetadata.of(reader.column("schema").scalar().getString()))).build();
    }

    private Map<SchemaPath, ColumnStatistics<?>> getColumnStatistics(TupleReader reader, TupleMetadata columnMetadata, Long rowCount) {
        ArrayListMultimap<String, StatisticsHolder<Object>> columnStatistics = ArrayListMultimap.create();
        HashMap<String, TypeProtos.MinorType> columnTypes = new HashMap<String, TypeProtos.MinorType>();
        for (ColumnMetadata column : columnMetadata) {
            if (!AnalyzeColumnUtils.isColumnStatisticsField(column.name())) continue;
            String fieldName2 = AnalyzeColumnUtils.getColumnName(column.name());
            StatisticsKind<?> statisticsKind = AnalyzeColumnUtils.getStatisticsKind(column.name());
            columnStatistics.put(fieldName2, new StatisticsHolder<Object>(this.getConvertedColumnValue(reader.column(column.name())), statisticsKind));
            if (!statisticsKind.getName().equalsIgnoreCase(ColumnStatisticsKind.MIN_VALUE.getName()) && !statisticsKind.getName().equalsIgnoreCase(ColumnStatisticsKind.MAX_VALUE.getName())) continue;
            columnTypes.putIfAbsent(fieldName2, column.type());
        }
        if (rowCount != null) {
            HashMap<String, StatisticsHolder> nullsCountColumnStatistics = new HashMap<String, StatisticsHolder>();
            columnStatistics.asMap().forEach((? super K key, ? super V value) -> value.stream().filter(statisticsHolder -> statisticsHolder.getStatisticsKind() == ColumnStatisticsKind.NON_NULL_VALUES_COUNT).findAny().map(statisticsHolder -> (Long)statisticsHolder.getStatisticsValue()).ifPresent(nonNullCount -> nullsCountColumnStatistics.put((String)key, new StatisticsHolder<Long>(Long.valueOf(rowCount - nonNullCount), (BaseStatisticsKind<?>)ColumnStatisticsKind.NULLS_COUNT))));
            nullsCountColumnStatistics.forEach(columnStatistics::put);
        }
        HashMap resultingStats = new HashMap();
        columnStatistics.asMap().forEach((? super K fieldName, ? super V statisticsHolders) -> resultingStats.put(SchemaPath.parseFromString(fieldName), new ColumnStatistics((Collection<StatisticsHolder<?>>)statisticsHolders, (TypeProtos.MinorType)columnTypes.get(fieldName))));
        return resultingStats;
    }

    private List<StatisticsHolder<?>> getMetadataStatistics(TupleReader reader, TupleMetadata columnMetadata) {
        ArrayList metadataStatistics = new ArrayList();
        String rgs = this.columnNamesOptions.rowGroupStart();
        String rgl = this.columnNamesOptions.rowGroupLength();
        for (ColumnMetadata column : columnMetadata) {
            String columnName = column.name();
            ObjectReader objectReader = reader.column(columnName);
            if (AnalyzeColumnUtils.isMetadataStatisticsField(columnName)) {
                metadataStatistics.add(new StatisticsHolder<Object>(objectReader.getObject(), AnalyzeColumnUtils.getStatisticsKind(columnName)));
                continue;
            }
            if (objectReader.isNull()) continue;
            if (columnName.equals(rgs)) {
                metadataStatistics.add(new StatisticsHolder<Long>(Long.valueOf(Long.parseLong(objectReader.scalar().getString())), new BaseStatisticsKind("start", true)));
                continue;
            }
            if (!columnName.equals(rgl)) continue;
            metadataStatistics.add(new StatisticsHolder<Long>(Long.valueOf(Long.parseLong(objectReader.scalar().getString())), new BaseStatisticsKind("length", true)));
        }
        return metadataStatistics;
    }

    private void appendStatistics(StatisticsRecordCollector statisticsCollector) {
        if (this.context.getOptions().getOption(PlannerSettings.STATISTICS_USE)) {
            ArrayList<EventBasedRecordWriter.FieldConverter> fieldConverters = new ArrayList<EventBasedRecordWriter.FieldConverter>();
            int fieldId = 0;
            for (VectorWrapper wrapper : this.right) {
                if (wrapper.getField().getName().equalsIgnoreCase("P_A_R_T_I_T_I_O_N_C_O_M_P_A_R_A_T_O_R")) continue;
                FieldReader reader = wrapper.getValueVector().getReader();
                EventBasedRecordWriter.FieldConverter converter = StatisticsRecordWriterImpl.getConverter(statisticsCollector, fieldId++, wrapper.getField().getName(), reader);
                fieldConverters.add(converter);
            }
            try {
                for (int counter = 0; counter < this.right.getRecordCount(); ++counter) {
                    statisticsCollector.startStatisticsRecord();
                    for (EventBasedRecordWriter.FieldConverter converter : fieldConverters) {
                        converter.setPosition(counter);
                        converter.startField();
                        converter.writeField();
                        converter.endField();
                    }
                    statisticsCollector.endStatisticsRecord();
                }
            }
            catch (IOException e) {
                throw UserException.dataWriteError(e).addContext("Failed to write metadata").build(logger);
            }
        }
    }

    private Object getConvertedColumnValue(ObjectReader objectReader) {
        switch (objectReader.schema().type()) {
            case VARBINARY: 
            case FIXEDBINARY: {
                return new String(objectReader.scalar().getBytes(), StandardCharsets.UTF_8);
            }
        }
        return objectReader.getObject();
    }

    private Set<Path> getIncomingLocations(TupleReader reader) {
        HashSet<Path> childLocations = new HashSet<Path>();
        ObjectReader metadataColumnReader = reader.column("metadataType");
        Preconditions.checkNotNull(metadataColumnReader, "metadataType column wasn't found");
        MetadataType metadataType = MetadataType.valueOf(metadataColumnReader.scalar().getString());
        switch (metadataType) {
            case SEGMENT: 
            case PARTITION: {
                ObjectReader locationsReader = reader.column("locations");
                if (locationsReader != null && locationsReader.type() == ObjectType.ARRAY) {
                    ArrayReader array = locationsReader.array();
                    while (array.next()) {
                        childLocations.add(new Path(array.scalar().getString()));
                    }
                } else {
                    ObjectReader underlyingMetadataReader = reader.column("collectedMap");
                    if (underlyingMetadataReader == null) break;
                    ArrayReader array = underlyingMetadataReader.array();
                    array.rewind();
                    while (array.next()) {
                        childLocations.addAll(this.getIncomingLocations(array.tuple()));
                    }
                }
                break;
            }
            case FILE: {
                childLocations.add(new Path(reader.column("location").scalar().getString()));
            }
        }
        return childLocations;
    }

    @Override
    public void dump() {
        logger.error("MetadataHandlerBatch[container={}, popConfig={}]", (Object)this.container, (Object)this.popConfig);
    }

    @Override
    public int getRecordCount() {
        return this.container.getRecordCount();
    }

    static enum State {
        RIGHT,
        LEFT,
        WRITE,
        FINISHED;

    }
}

