/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.limit;

import java.util.List;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.Limit;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitRecordBatch
extends AbstractSingleRecordBatch<Limit> {
    private static final Logger logger = LoggerFactory.getLogger(LimitRecordBatch.class);
    private final SelectionVector2 outgoingSv;
    private SelectionVector2 incomingSv;
    private int recordStartOffset;
    private int numberOfRecords;
    private boolean first = true;
    private final List<TransferPair> transfers = Lists.newArrayList();

    public LimitRecordBatch(Limit popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context, incoming);
        this.outgoingSv = new SelectionVector2(this.oContext.getAllocator());
        this.refreshLimitState();
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        RecordBatch.IterOutcome upStream;
        if (this.first || this.needMoreRecords(this.numberOfRecords)) {
            return super.innerNext();
        }
        this.outgoingSv.setRecordCount(0);
        this.incoming.cancel();
        do {
            upStream = this.next(this.incoming);
            VectorAccessibleUtilities.clear(this.incoming);
            if (this.incomingSv == null) continue;
            this.incomingSv.clear();
        } while (upStream == RecordBatch.IterOutcome.OK || upStream == RecordBatch.IterOutcome.OK_NEW_SCHEMA);
        if (upStream == RecordBatch.IterOutcome.EMIT) {
            this.refreshLimitState();
            return upStream;
        }
        return RecordBatch.IterOutcome.NONE;
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        return this.outgoingSv;
    }

    @Override
    public int getRecordCount() {
        return this.outgoingSv.getCount();
    }

    @Override
    public void close() {
        this.outgoingSv.clear();
        super.close();
    }

    @Override
    protected boolean setupNewSchema() {
        this.container.clear();
        this.transfers.clear();
        for (VectorWrapper v : this.incoming) {
            TransferPair pair = v.getValueVector().makeTransferPair((ValueVector)this.container.addOrGet(v.getField(), this.callBack));
            this.transfers.add(pair);
        }
        BatchSchema.SelectionVectorMode svMode = this.incoming.getSchema().getSelectionVectorMode();
        switch (svMode) {
            case NONE: {
                break;
            }
            case TWO_BYTE: {
                this.incomingSv = this.incoming.getSelectionVector2();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.container.isSchemaChanged()) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.TWO_BYTE);
            return true;
        }
        return false;
    }

    @Override
    protected RecordBatch.IterOutcome getFinalOutcome(boolean hasRemainder) {
        RecordBatch.IterOutcome outcomeToReturn = super.getFinalOutcome(hasRemainder);
        if (outcomeToReturn == RecordBatch.IterOutcome.EMIT) {
            this.refreshLimitState();
        }
        return outcomeToReturn;
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        int inputRecordCount;
        if (this.first) {
            this.first = false;
        }
        if ((inputRecordCount = this.incoming.getRecordCount()) == 0) {
            this.setOutgoingRecordCount(0);
            this.container.setEmpty();
            return this.getFinalOutcome(false);
        }
        for (TransferPair tp : this.transfers) {
            tp.transfer();
        }
        if (inputRecordCount <= this.recordStartOffset) {
            this.recordStartOffset -= inputRecordCount;
            this.setOutgoingRecordCount(0);
            this.container.setEmpty();
        } else {
            this.outgoingSv.allocateNew(inputRecordCount);
            this.limit(inputRecordCount);
        }
        if (this.incomingSv != null) {
            int incomingCount = this.incomingSv.getBatchActualRecordCount();
            this.outgoingSv.setBatchActualRecordCount(incomingCount);
            this.container.setRecordCount(incomingCount);
            this.incomingSv.clear();
        }
        return this.getFinalOutcome(false);
    }

    private void limit(int inputRecordCount) {
        int endRecordIndex;
        if (this.numberOfRecords == Integer.MIN_VALUE) {
            endRecordIndex = inputRecordCount;
        } else {
            endRecordIndex = Math.min(inputRecordCount, this.recordStartOffset + this.numberOfRecords);
            this.numberOfRecords -= Math.max(0, endRecordIndex - this.recordStartOffset);
        }
        int svIndex = 0;
        for (int i = this.recordStartOffset; i < endRecordIndex; ++i) {
            if (this.incomingSv != null) {
                this.outgoingSv.setIndex(svIndex, this.incomingSv.getIndex(i));
            } else {
                this.outgoingSv.setIndex(svIndex, (char)i);
            }
            ++svIndex;
        }
        this.outgoingSv.setRecordCount(svIndex);
        this.outgoingSv.setBatchActualRecordCount(inputRecordCount);
        this.container.setRecordCount(inputRecordCount);
        this.recordStartOffset = 0;
    }

    private void setOutgoingRecordCount(int outputCount) {
        this.outgoingSv.setRecordCount(outputCount);
        this.outgoingSv.setBatchActualRecordCount(outputCount);
    }

    private boolean needMoreRecords(int recordsToRead) {
        boolean readMore = true;
        Preconditions.checkState(recordsToRead == Integer.MIN_VALUE || recordsToRead >= 0, String.format("Invalid value of numberOfRecords %d inside LimitRecordBatch", recordsToRead));
        if (recordsToRead == 0) {
            readMore = false;
        }
        return readMore;
    }

    private void refreshLimitState() {
        this.recordStartOffset = Math.max(0, ((Limit)this.popConfig).getFirst());
        this.numberOfRecords = ((Limit)this.popConfig).getLast() == null ? Integer.MIN_VALUE : Math.max(0, ((Limit)this.popConfig).getLast()) - this.recordStartOffset;
        this.first = true;
    }

    @Override
    public void dump() {
        logger.error("LimitRecordBatch[container={}, offset={}, numberOfRecords={}, incomingSV={}, outgoingSV={}]", new Object[]{this.container, this.recordStartOffset, this.numberOfRecords, this.incomingSv, this.outgoingSv});
    }
}

