/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.DbSubScan;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.physical.config.RowKeyJoinPOP;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.join.RowKeyJoinBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class RowKeyJoinBatchCreator
implements BatchCreator<RowKeyJoinPOP> {
    public RowKeyJoinBatch getBatch(ExecutorFragmentContext context, RowKeyJoinPOP config, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument(children.size() == 2);
        RowKeyJoinBatch rjBatch = new RowKeyJoinBatch(config, (FragmentContext)context, children.get(0), children.get(1));
        SubScan subScan = config.getSubScanForRowKeyJoin();
        if (subScan != null && subScan instanceof DbSubScan && ((DbSubScan)subScan).isRestrictedSubScan()) {
            ((DbSubScan)subScan).addJoinForRestrictedSubScan(rjBatch);
        }
        return rjBatch;
    }
}

