/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Named;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.join.NestedLoopJoin;
import org.apache.drill.exec.physical.impl.join.NestedLoopJoinBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.ExpandableHyperContainer;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.util.record.RecordBatchStats;

public abstract class NestedLoopJoinTemplate
implements NestedLoopJoin {
    private RecordBatch left;
    private BatchSchema leftSchema;
    private RecordBatch.IterOutcome leftOutcome;
    private List<Integer> rightCounts;
    private NestedLoopJoinBatch outgoing;
    private final IterationStatusTracker tracker = new IterationStatusTracker();
    private int targetOutputRecords;

    @Override
    public void setupNestedLoopJoin(FragmentContext context, RecordBatch left, RecordBatch.IterOutcome leftOutcome, ExpandableHyperContainer rightContainer, LinkedList<Integer> rightCounts, NestedLoopJoinBatch outgoing) {
        this.left = left;
        this.leftSchema = left.getSchema();
        this.leftOutcome = leftOutcome;
        this.rightCounts = rightCounts;
        this.outgoing = outgoing;
        this.doSetup(context, rightContainer, left, outgoing);
    }

    @Override
    public void setTargetOutputCount(int targetOutputRecords) {
        this.targetOutputRecords = targetOutputRecords;
    }

    @Override
    public int outputRecords(JoinRelType joinType) throws SchemaChangeException {
        int outputIndex = 0;
        while (this.leftOutcome != RecordBatch.IterOutcome.NONE && this.leftOutcome != RecordBatch.IterOutcome.NOT_YET) {
            if (this.left.getRecordCount() != 0) {
                outputIndex = this.populateOutgoingBatch(joinType, outputIndex);
            }
            if (outputIndex >= this.targetOutputRecords) break;
            this.resetAndGetNextLeft(outputIndex);
        }
        return outputIndex;
    }

    private int populateOutgoingBatch(JoinRelType joinType, int outputIndex) {
        int nextLeftRecordToProcess;
        int nextRightBatchToProcess = this.tracker.getNextRightBatchToProcess();
        int nextRightRecordToProcess = this.tracker.getNextRightRecordToProcess();
        boolean rightRecordMatched = this.tracker.isRightRecordMatched();
        block0: for (nextLeftRecordToProcess = this.tracker.getNextLeftRecordToProcess(); nextLeftRecordToProcess < this.left.getRecordCount(); ++nextLeftRecordToProcess) {
            while (nextRightBatchToProcess < this.rightCounts.size()) {
                int rightRecordCount = this.rightCounts.get(nextRightBatchToProcess);
                int currentRightBatchIndex = nextRightBatchToProcess << 16;
                while (nextRightRecordToProcess < rightRecordCount) {
                    if (this.doEval(nextLeftRecordToProcess, currentRightBatchIndex, nextRightRecordToProcess)) {
                        this.emitLeft(nextLeftRecordToProcess, outputIndex);
                        this.emitRight(nextRightBatchToProcess, nextRightRecordToProcess, outputIndex);
                        rightRecordMatched = true;
                        if (++outputIndex >= this.targetOutputRecords) {
                            ++nextRightRecordToProcess;
                            break block0;
                        }
                    }
                    ++nextRightRecordToProcess;
                }
                nextRightRecordToProcess = 0;
                ++nextRightBatchToProcess;
            }
            nextRightBatchToProcess = 0;
            if (joinType == JoinRelType.LEFT && !rightRecordMatched) {
                this.emitLeft(nextLeftRecordToProcess, outputIndex);
                if (++outputIndex < this.targetOutputRecords) continue;
                ++nextLeftRecordToProcess;
                break;
            }
            rightRecordMatched = false;
        }
        this.tracker.update(nextRightBatchToProcess, nextRightRecordToProcess, nextLeftRecordToProcess, rightRecordMatched);
        return outputIndex;
    }

    private void resetAndGetNextLeft(int outputIndex) throws SchemaChangeException {
        for (VectorWrapper vw : this.left) {
            vw.getValueVector().clear();
        }
        this.tracker.reset();
        this.leftOutcome = this.outgoing.next(0, this.left);
        switch (this.leftOutcome) {
            case OK_NEW_SCHEMA: {
                if (!this.left.getSchema().equals(this.leftSchema)) {
                    throw SchemaChangeException.schemaChanged("Nested loop join does not handle schema change. Schema change found on the left side of NLJ.", this.leftSchema, this.left.getSchema());
                }
            }
            case OK: {
                this.outgoing.getBatchMemoryManager().update(this.left, 0, outputIndex);
                this.setTargetOutputCount(this.outgoing.getBatchMemoryManager().getCurrentOutgoingMaxRowCount());
                RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.INPUT_LEFT, this.outgoing.getBatchMemoryManager().getRecordBatchSizer(0), this.outgoing.getRecordBatchStatsContext());
                break;
            }
        }
    }

    @Override
    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="rightContainer") VectorContainer var2, @Named(value="leftBatch") RecordBatch var3, @Named(value="outgoing") RecordBatch var4);

    @Override
    public abstract void emitRight(@Named(value="batchIndex") int var1, @Named(value="recordIndexWithinBatch") int var2, @Named(value="outIndex") int var3);

    @Override
    public abstract void emitLeft(@Named(value="leftIndex") int var1, @Named(value="outIndex") int var2);

    protected abstract boolean doEval(@Named(value="leftIndex") int var1, @Named(value="rightBatchIndex") int var2, @Named(value="rightRecordIndexWithinBatch") int var3);

    private static class IterationStatusTracker {
        private int nextRightBatchToProcess;
        private int nextRightRecordToProcess;
        private int nextLeftRecordToProcess;
        private boolean rightRecordMatched;

        private IterationStatusTracker() {
        }

        int getNextRightBatchToProcess() {
            return this.nextRightBatchToProcess;
        }

        boolean isRightRecordMatched() {
            return this.rightRecordMatched;
        }

        int getNextLeftRecordToProcess() {
            return this.nextLeftRecordToProcess;
        }

        int getNextRightRecordToProcess() {
            return this.nextRightRecordToProcess;
        }

        void update(int nextRightBatchToProcess, int nextRightRecordToProcess, int nextLeftRecordToProcess, boolean rightRecordMatchFound) {
            this.nextRightBatchToProcess = nextRightBatchToProcess;
            this.nextRightRecordToProcess = nextRightRecordToProcess;
            this.nextLeftRecordToProcess = nextLeftRecordToProcess;
            this.rightRecordMatched = rightRecordMatchFound;
        }

        void reset() {
            this.nextLeftRecordToProcess = 0;
            this.nextRightRecordToProcess = 0;
            this.nextRightBatchToProcess = 0;
            this.rightRecordMatched = false;
        }
    }
}

