/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JVar;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.BatchReference;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.NestedLoopJoinPOP;
import org.apache.drill.exec.physical.impl.filter.ReturnValueExpression;
import org.apache.drill.exec.physical.impl.join.NestedLoopJoin;
import org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import org.apache.drill.exec.record.AbstractBinaryRecordBatch;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.ExpandableHyperContainer;
import org.apache.drill.exec.record.JoinBatchMemoryManager;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedLoopJoinBatch
extends AbstractBinaryRecordBatch<NestedLoopJoinPOP> {
    private static final Logger logger = LoggerFactory.getLogger(NestedLoopJoinBatch.class);
    protected static final int LEFT_INPUT = 0;
    protected static final int RIGHT_INPUT = 1;
    private BatchSchema leftSchema;
    private BatchSchema rightSchema;
    private NestedLoopJoin nljWorker;
    private int outputRecords;
    private final ExpandableHyperContainer rightContainer = new ExpandableHyperContainer();
    private final LinkedList<Integer> rightCounts = new LinkedList();
    private static final GeneratorMapping EMIT_RIGHT = GeneratorMapping.create("doSetup", "emitRight", null, null);
    private static final GeneratorMapping EMIT_RIGHT_CONSTANT = GeneratorMapping.create("doSetup", "doSetup", null, null);
    private static final GeneratorMapping EMIT_LEFT = GeneratorMapping.create("doSetup", "emitLeft", null, null);
    private static final GeneratorMapping EMIT_LEFT_CONSTANT = GeneratorMapping.create("doSetup", "doSetup", null, null);
    private final MappingSet emitRightMapping = new MappingSet("rightCompositeIndex", "outIndex", "rightContainer", "outgoing", EMIT_RIGHT_CONSTANT, EMIT_RIGHT);
    private final MappingSet emitLeftMapping = new MappingSet("leftIndex", "outIndex", "leftBatch", "outgoing", EMIT_LEFT_CONSTANT, EMIT_LEFT);
    private final MappingSet SETUP_LEFT_MAPPING = new MappingSet("leftIndex", "outIndex", "leftBatch", "outgoing", ClassGenerator.DEFAULT_CONSTANT_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);

    protected NestedLoopJoinBatch(NestedLoopJoinPOP popConfig, FragmentContext context, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, left, right);
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        int configuredBatchSize = (int)context.getOptions().getOption(ExecConstants.OUTPUT_BATCH_SIZE_VALIDATOR);
        this.batchMemoryManager = new JoinBatchMemoryManager(configuredBatchSize, left, right, new HashSet<String>());
        RecordBatchStats.printConfiguredBatchSize(this.getRecordBatchStatsContext(), configuredBatchSize);
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.state == AbstractRecordBatch.BatchState.FIRST) {
            boolean drainRight;
            if (this.leftUpstream == RecordBatch.IterOutcome.NONE) {
                this.killAndDrainRight();
                return RecordBatch.IterOutcome.NONE;
            }
            boolean bl = drainRight = this.rightUpstream != RecordBatch.IterOutcome.NONE;
            block7: while (drainRight) {
                this.rightUpstream = this.next(1, this.right);
                switch (this.rightUpstream) {
                    case OK_NEW_SCHEMA: {
                        if (!this.right.getSchema().equals(this.rightSchema)) {
                            throw new DrillRuntimeException("Nested loop join does not handle schema change. Schema change found on the right side of NLJ.");
                        }
                    }
                    case OK: {
                        this.batchMemoryManager.update(1, 0, true);
                        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.INPUT_RIGHT, this.batchMemoryManager.getRecordBatchSizer(1), this.getRecordBatchStatsContext());
                        this.addBatchToHyperContainer(this.right);
                        continue block7;
                    }
                    case NONE: 
                    case NOT_YET: {
                        drainRight = false;
                        continue block7;
                    }
                }
            }
            this.nljWorker.setupNestedLoopJoin(this.context, this.left, this.leftUpstream, this.rightContainer, this.rightCounts, this);
            this.state = AbstractRecordBatch.BatchState.NOT_FIRST;
        }
        this.batchMemoryManager.allocateVectors(this.container);
        this.nljWorker.setTargetOutputCount(this.batchMemoryManager.getOutputRowCount());
        try {
            this.outputRecords = this.nljWorker.outputRecords(((NestedLoopJoinPOP)this.popConfig).getJoinType());
        }
        catch (SchemaChangeException e) {
            throw UserException.schemaChangeError(e).build(logger);
        }
        this.container.setValueCount(this.outputRecords);
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this, this.getRecordBatchStatsContext());
        logger.debug("Number of records emitted: " + this.outputRecords);
        return this.outputRecords > 0 ? RecordBatch.IterOutcome.OK : RecordBatch.IterOutcome.NONE;
    }

    private void killAndDrainRight() {
        if (!this.hasMore(this.rightUpstream)) {
            return;
        }
        this.right.cancel();
        while (this.hasMore(this.rightUpstream)) {
            VectorAccessibleUtilities.clear(this.right);
            this.rightUpstream = this.next(1, this.right);
        }
    }

    private boolean hasMore(RecordBatch.IterOutcome outcome) {
        return outcome == RecordBatch.IterOutcome.OK || outcome == RecordBatch.IterOutcome.OK_NEW_SCHEMA;
    }

    private NestedLoopJoin setupWorker() {
        CodeGenerator<NestedLoopJoin> nLJCodeGenerator = CodeGenerator.get(this.SETUP_LEFT_MAPPING, NestedLoopJoin.TEMPLATE_DEFINITION, this.context.getOptions());
        nLJCodeGenerator.plainJavaCapable(true);
        ClassGenerator<NestedLoopJoin> nLJClassGenerator = nLJCodeGenerator.getRoot();
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        ImmutableMap<VectorAccessible, BatchReference> batches = ImmutableMap.builder().put(this.left, new BatchReference("leftBatch", "leftIndex")).put((RecordBatch)((Object)this.rightContainer), new BatchReference("rightContainer", "rightBatchIndex", "rightRecordIndexWithinBatch")).build();
        LogicalExpression materialize = ExpressionTreeMaterializer.materialize(((NestedLoopJoinPOP)this.popConfig).getCondition(), batches, (ErrorCollector)collector, this.context.getFunctionRegistry(), false, false);
        collector.reportErrors(logger);
        nLJClassGenerator.addExpr(new ReturnValueExpression(materialize), ClassGenerator.BlkCreateMode.FALSE);
        nLJClassGenerator.setMappingSet(this.emitLeftMapping);
        JExpression outIndex = JExpr.direct((String)"outIndex");
        JExpression leftIndex = JExpr.direct((String)"leftIndex");
        int fieldId = 0;
        int outputFieldId = 0;
        if (this.leftSchema != null) {
            for (MaterializedField field : this.leftSchema) {
                TypeProtos.MajorType fieldType = field.getType();
                this.container.addOrGet(field);
                TypedFieldId inFieldId = new TypedFieldId.Builder().finalType(fieldType).hyper(false).addId(fieldId).build();
                JVar inVV = nLJClassGenerator.declareVectorValueSetupAndMember("leftBatch", inFieldId);
                TypedFieldId outFieldId = new TypedFieldId.Builder().finalType(fieldType).hyper(false).addId(outputFieldId).build();
                JVar outVV = nLJClassGenerator.declareVectorValueSetupAndMember("outgoing", outFieldId);
                nLJClassGenerator.getEvalBlock().add((JStatement)outVV.invoke("copyFromSafe").arg(leftIndex).arg(outIndex).arg((JExpression)inVV));
                nLJClassGenerator.rotateBlock();
                ++fieldId;
                ++outputFieldId;
            }
        }
        fieldId = 0;
        nLJClassGenerator.setMappingSet(this.emitRightMapping);
        JExpression batchIndex = JExpr.direct((String)"batchIndex");
        JExpression recordIndexWithinBatch = JExpr.direct((String)"recordIndexWithinBatch");
        if (this.rightSchema != null) {
            for (MaterializedField field : this.rightSchema) {
                TypeProtos.MajorType inputType = field.getType();
                TypeProtos.MajorType outputType = ((NestedLoopJoinPOP)this.popConfig).getJoinType() == JoinRelType.LEFT && inputType.getMode() == TypeProtos.DataMode.REQUIRED ? Types.overrideMode(inputType, TypeProtos.DataMode.OPTIONAL) : inputType;
                MaterializedField newField = MaterializedField.create(field.getName(), outputType);
                this.container.addOrGet(newField);
                TypedFieldId inFieldId = new TypedFieldId.Builder().finalType(inputType).hyper(true).addId(fieldId).build();
                JVar inVV = nLJClassGenerator.declareVectorValueSetupAndMember("rightContainer", inFieldId);
                TypedFieldId outFieldId = new TypedFieldId.Builder().finalType(outputType).hyper(false).addId(outputFieldId).build();
                JVar outVV = nLJClassGenerator.declareVectorValueSetupAndMember("outgoing", outFieldId);
                nLJClassGenerator.getEvalBlock().add((JStatement)outVV.invoke("copyFromSafe").arg(recordIndexWithinBatch).arg(outIndex).arg((JExpression)inVV.component(batchIndex)));
                nLJClassGenerator.rotateBlock();
                ++fieldId;
                ++outputFieldId;
            }
        }
        return this.context.getImplementationClass(nLJCodeGenerator);
    }

    @Override
    protected void buildSchema() {
        if (!this.prefetchFirstBatchFromBothSides()) {
            return;
        }
        this.batchMemoryManager.update(1, 0, true);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.INPUT_RIGHT, this.batchMemoryManager.getRecordBatchSizer(1), this.getRecordBatchStatsContext());
        if (this.leftUpstream != RecordBatch.IterOutcome.NONE) {
            this.leftSchema = this.left.getSchema();
            this.container.copySchemaFrom(this.left);
        }
        if (this.rightUpstream != RecordBatch.IterOutcome.NONE) {
            for (VectorWrapper vectorWrapper : this.right) {
                TypeProtos.MajorType inputType = vectorWrapper.getField().getType();
                TypeProtos.MajorType outputType = ((NestedLoopJoinPOP)this.popConfig).getJoinType() == JoinRelType.LEFT && inputType.getMode() == TypeProtos.DataMode.REQUIRED ? Types.overrideMode(inputType, TypeProtos.DataMode.OPTIONAL) : inputType;
                MaterializedField newField = MaterializedField.create(vectorWrapper.getField().getName(), outputType);
                Object valueVector = this.container.addOrGet(newField);
                if (!(valueVector instanceof AbstractContainerVector)) continue;
                vectorWrapper.getValueVector().makeTransferPair((ValueVector)valueVector);
                valueVector.clear();
            }
            this.rightSchema = this.right.getSchema();
            this.addBatchToHyperContainer(this.right);
        }
        this.nljWorker = this.setupWorker();
        if (this.leftUpstream != RecordBatch.IterOutcome.NONE && this.left.getRecordCount() == 0) {
            this.leftUpstream = this.next(0, this.left);
        }
        this.batchMemoryManager.update(0, 0);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.INPUT_LEFT, this.batchMemoryManager.getRecordBatchSizer(0), this.getRecordBatchStatsContext());
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container.setEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBatchToHyperContainer(RecordBatch inputBatch) {
        RecordBatchData batchCopy = new RecordBatchData(inputBatch, this.oContext.getAllocator());
        boolean success = false;
        try {
            this.rightCounts.addLast(inputBatch.getRecordCount());
            this.rightContainer.addBatch(batchCopy.getContainer());
            success = true;
        }
        finally {
            if (!success) {
                batchCopy.clear();
            }
        }
    }

    @Override
    public void close() {
        this.updateBatchMemoryManagerStats();
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "incoming aggregate left: batch count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.batchMemoryManager.getNumIncomingBatches(0), this.batchMemoryManager.getAvgInputBatchSize(0), this.batchMemoryManager.getAvgInputRowWidth(0), this.batchMemoryManager.getTotalInputRecords(0));
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "incoming aggregate right: batch count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.batchMemoryManager.getNumIncomingBatches(1), this.batchMemoryManager.getAvgInputBatchSize(1), this.batchMemoryManager.getAvgInputRowWidth(1), this.batchMemoryManager.getTotalInputRecords(1));
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "outgoing aggregate: batch count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.batchMemoryManager.getNumOutgoingBatches(), this.batchMemoryManager.getAvgOutputBatchSize(), this.batchMemoryManager.getAvgOutputRowWidth(), this.batchMemoryManager.getTotalOutputRecords());
        this.rightContainer.clear();
        this.rightCounts.clear();
        super.close();
    }

    @Override
    protected void cancelIncoming() {
        this.left.cancel();
        this.right.cancel();
    }

    @Override
    public int getRecordCount() {
        return this.outputRecords;
    }

    @Override
    public void dump() {
        logger.error("NestedLoopJoinBatch[container={}, left={}, right={}, leftOutcome={}, rightOutcome={}, leftSchema={}, rightSchema={}, outputRecords={}, rightContainer={}, rightCounts={}]", new Object[]{this.container, this.left, this.right, this.leftUpstream, this.rightUpstream, this.leftSchema, this.rightSchema, this.outputRecords, this.rightContainer, this.rightCounts});
    }
}

