/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.Util;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.common.Comparator;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.DrillLimitRel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.exec.work.foreman.UnsupportedRelOperatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinUtils {
    private static final Logger logger = LoggerFactory.getLogger(JoinUtils.class);
    public static final String FAILED_TO_PLAN_CARTESIAN_JOIN = String.format("This query cannot be planned possibly due to either a cartesian join or an inequality join. %nIf a cartesian or inequality join is used intentionally, set the option '%s' to false and try again.", PlannerSettings.NLJOIN_FOR_SCALAR.getOptionName());

    public static Comparator checkAndReturnSupportedJoinComparator(JoinCondition condition) {
        switch (condition.getRelationship().toUpperCase()) {
            case "EQUALS": 
            case "==": {
                return Comparator.EQUALS;
            }
            case "IS_NOT_DISTINCT_FROM": {
                return Comparator.IS_NOT_DISTINCT_FROM;
            }
        }
        throw UserException.unsupportedError().message("Invalid comparator supplied to this join: " + condition.getRelationship(), new Object[0]).build(logger);
    }

    public static boolean checkCartesianJoin(RelNode relNode, List<Integer> leftKeys, List<Integer> rightKeys, List<Boolean> filterNulls) {
        if (relNode instanceof Join) {
            leftKeys.clear();
            rightKeys.clear();
            Join joinRel = (Join)relNode;
            RelNode left = joinRel.getLeft();
            RelNode right = joinRel.getRight();
            RexNode remaining = RelOptUtil.splitJoinCondition((RelNode)left, (RelNode)right, (RexNode)joinRel.getCondition(), leftKeys, rightKeys, filterNulls);
            if (joinRel.getJoinType() == JoinRelType.INNER ? leftKeys.isEmpty() || rightKeys.isEmpty() : !remaining.isAlwaysTrue() || leftKeys.isEmpty() || rightKeys.isEmpty()) {
                return true;
            }
        }
        for (RelNode child : relNode.getInputs()) {
            if (!JoinUtils.checkCartesianJoin(child, leftKeys, rightKeys, filterNulls)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCartesianJoin(RelNode relNode) {
        return JoinUtils.checkCartesianJoin(relNode, new LinkedList<Integer>(), new LinkedList<Integer>(), new LinkedList<Boolean>());
    }

    private static boolean allowImplicitCast(TypeProtos.MinorType input1, TypeProtos.MinorType input2) {
        if (TypeCastRules.isNumericType(input1) && TypeCastRules.isNumericType(input2) && (!Types.isDecimalType(input1) && !Types.isDecimalType(input2) || Types.areDecimalTypes(input1, input2))) {
            return true;
        }
        if (!(input1 != TypeProtos.MinorType.DATE && input1 != TypeProtos.MinorType.TIMESTAMP || input2 != TypeProtos.MinorType.DATE && input2 != TypeProtos.MinorType.TIMESTAMP)) {
            return true;
        }
        return !(input1 != TypeProtos.MinorType.VARCHAR && input1 != TypeProtos.MinorType.VARBINARY || input2 != TypeProtos.MinorType.VARCHAR && input2 != TypeProtos.MinorType.VARBINARY);
    }

    public static void addLeastRestrictiveCasts(LogicalExpression[] leftExpressions, VectorAccessible leftBatch, LogicalExpression[] rightExpressions, VectorAccessible rightBatch, FragmentContext context) {
        assert (rightExpressions.length == leftExpressions.length);
        for (int i = 0; i < rightExpressions.length; ++i) {
            LogicalExpression castExpr;
            LogicalExpression rightExpression = rightExpressions[i];
            LogicalExpression leftExpression = leftExpressions[i];
            TypeProtos.MinorType rightType = rightExpression.getMajorType().getMinorType();
            TypeProtos.MinorType leftType = leftExpression.getMajorType().getMinorType();
            if (rightType == TypeProtos.MinorType.UNION || leftType == TypeProtos.MinorType.UNION || rightType == leftType) continue;
            boolean implicitCasts = context.getOptions().getBoolean("drill.exec.implicit_casts.joins.enabled");
            if (!implicitCasts && !JoinUtils.allowImplicitCast(rightType, leftType)) {
                throw new DrillRuntimeException(String.format("Join only supports implicit casts between\n1. Numeric data (none of types is decimal or both of them are decimal)\n2. Varchar, Varbinary data\n3. Date, Timestamp data\nLeft type: %s, Right type: %s. Add explicit casts to avoid this error", leftType, rightType));
            }
            TypeProtos.MinorType result = TypeCastRules.getLeastRestrictiveType(leftType, rightType);
            ErrorCollectorImpl errorCollector = new ErrorCollectorImpl();
            if (result == null) {
                throw new DrillRuntimeException(String.format("Join conditions cannot be compared failing left expression: %s failing right expression: %s", leftExpression.getMajorType().toString(), rightExpression.getMajorType().toString()));
            }
            if (result != rightType) {
                castExpr = ExpressionTreeMaterializer.addCastExpression(rightExpression, leftExpression.getMajorType(), context.getFunctionRegistry(), errorCollector);
                rightExpressions[i] = ExpressionTreeMaterializer.materialize(castExpr, rightBatch, errorCollector, context.getFunctionRegistry());
                continue;
            }
            if (result == leftType) continue;
            castExpr = ExpressionTreeMaterializer.addCastExpression(leftExpression, rightExpression.getMajorType(), context.getFunctionRegistry(), errorCollector);
            leftExpressions[i] = ExpressionTreeMaterializer.materialize(castExpr, leftBatch, errorCollector, context.getFunctionRegistry());
        }
    }

    public static boolean isScalarSubquery(RelNode root) {
        DrillAggregateRel agg = null;
        RelNode currentrel = root;
        while (agg == null && currentrel != null) {
            if (currentrel instanceof DrillAggregateRel) {
                agg = (DrillAggregateRel)currentrel;
                continue;
            }
            if (currentrel instanceof RelSubset) {
                currentrel = ((RelSubset)currentrel).getBest();
                continue;
            }
            if (currentrel instanceof DrillLimitRel) {
                Integer fetchValue = (Integer)((RexLiteral)((DrillLimitRel)currentrel).getFetch()).getValueAs(Integer.class);
                return fetchValue != null && fetchValue <= 1;
            }
            if (currentrel.getInputs().size() != 1) break;
            currentrel = currentrel.getInput(0);
        }
        if (agg != null) {
            if (agg.getGroupSet().isEmpty()) {
                return true;
            }
            if (agg.getAggCallList().isEmpty() && agg.getGroupSet().cardinality() == 1) {
                ProjectExpressionsCollector expressionsCollector = new ProjectExpressionsCollector();
                agg.accept((RelShuttle)expressionsCollector);
                List<RexNode> projectedExpressions = expressionsCollector.getProjectedExpressions();
                return projectedExpressions.size() == 1 && RexUtil.isLiteral((RexNode)projectedExpressions.get(agg.getGroupSet().nth(0)), (boolean)true);
            }
        }
        return false;
    }

    public static JoinCategory getJoinCategory(RelNode left, RelNode right, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys, List<Boolean> filterNulls) {
        if (condition.isAlwaysTrue()) {
            return JoinCategory.CARTESIAN;
        }
        leftKeys.clear();
        rightKeys.clear();
        filterNulls.clear();
        RexNode remaining = RelOptUtil.splitJoinCondition((RelNode)left, (RelNode)right, (RexNode)condition, leftKeys, rightKeys, filterNulls);
        if (!remaining.isAlwaysTrue() || leftKeys.size() == 0 || rightKeys.size() == 0) {
            return JoinCategory.INEQUALITY;
        }
        return JoinCategory.EQUALITY;
    }

    public static boolean hasScalarSubqueryInput(RelNode left, RelNode right) {
        return JoinUtils.isScalarSubquery(left) || JoinUtils.isScalarSubquery(right);
    }

    public static UnsupportedRelOperatorException cartesianJoinPlanningException() {
        return new UnsupportedRelOperatorException(FAILED_TO_PLAN_CARTESIAN_JOIN);
    }

    private static class ProjectExpressionsCollector
    extends RelShuttleImpl {
        private final List<RexNode> expressions = new ArrayList<RexNode>();

        private ProjectExpressionsCollector() {
        }

        public RelNode visit(RelNode other) {
            if (other instanceof RelSubset) {
                return this.visit((RelSubset)other);
            }
            if (other instanceof Project) {
                return this.visit((Project)other);
            }
            return super.visit(other);
        }

        public RelNode visit(TableFunctionScan scan) {
            return scan;
        }

        public RelNode visit(LogicalJoin join) {
            return join;
        }

        public RelNode visit(LogicalCorrelate correlate) {
            return correlate;
        }

        public RelNode visit(LogicalUnion union) {
            return union;
        }

        public RelNode visit(LogicalIntersect intersect) {
            return intersect;
        }

        public RelNode visit(LogicalMinus minus) {
            return minus;
        }

        public RelNode visit(LogicalSort sort) {
            return sort;
        }

        public RelNode visit(LogicalExchange exchange) {
            return exchange;
        }

        private RelNode visit(Project project) {
            this.expressions.addAll(project.getProjects());
            return project;
        }

        private RelNode visit(RelSubset subset) {
            return ((RelNode)Util.first((Object)subset.getBest(), (Object)subset.getOriginal())).accept((RelShuttle)this);
        }

        public List<RexNode> getProjectedExpressions() {
            return this.expressions;
        }
    }

    public static enum JoinCategory {
        EQUALITY,
        INEQUALITY,
        CARTESIAN;

    }
}

