/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import javax.inject.Named;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.MergeJoinPOP;
import org.apache.drill.exec.physical.impl.join.JoinStatus;
import org.apache.drill.exec.physical.impl.join.JoinWorker;
import org.apache.drill.exec.record.VectorContainer;

public abstract class JoinTemplate
implements JoinWorker {
    @Override
    public void setupJoin(FragmentContext context, JoinStatus status, VectorContainer outgoing) throws SchemaChangeException {
        this.doSetup(context, status, outgoing);
    }

    @Override
    public final boolean doJoin(JoinStatus status) {
        boolean isLeftJoin = ((MergeJoinPOP)status.outputBatch.getPopConfig()).getJoinType() == JoinRelType.LEFT;
        status.setHasMoreData(false);
        block5: while (!status.isOutgoingBatchFull()) {
            if (status.right.finished()) {
                if (isLeftJoin) {
                    while (!status.left.finished()) {
                        if (status.isOutgoingBatchFull()) {
                            status.setHasMoreData(true);
                            return true;
                        }
                        this.doCopyLeft(status.left.getCurrentPosition(), status.getOutPosition());
                        status.incOutputPos();
                        status.left.next();
                    }
                }
                return true;
            }
            if (status.left.finished()) {
                return true;
            }
            int comparison = Integer.signum(this.doCompare(status.left.getCurrentPosition(), status.right.getCurrentPosition()));
            switch (comparison) {
                case -1: {
                    if (isLeftJoin) {
                        this.doCopyLeft(status.left.getCurrentPosition(), status.getOutPosition());
                        status.incOutputPos();
                    }
                    status.left.next();
                    continue block5;
                }
                case 0: {
                    if (status.shouldMark()) {
                        status.right.mark();
                        this.doCopyLeft(status.left.getCurrentPosition(), status.getOutPosition());
                        this.doCopyRight(status.right.getCurrentPosition(), status.getOutPosition());
                        status.incOutputPos();
                    }
                    if (status.isOutgoingBatchFull()) {
                        status.setHasMoreData(true);
                        status.disableMarking();
                        return true;
                    }
                    status.right.next();
                    while (!status.right.finished() && this.doCompare(status.left.getCurrentPosition(), status.right.getCurrentPosition()) == 0) {
                        this.doCopyLeft(status.left.getCurrentPosition(), status.getOutPosition());
                        this.doCopyRight(status.right.getCurrentPosition(), status.getOutPosition());
                        status.incOutputPos();
                        if (status.isOutgoingBatchFull()) {
                            status.setHasMoreData(true);
                            status.disableMarking();
                            return true;
                        }
                        status.right.next();
                    }
                    status.right.reset();
                    status.enableMarking();
                    status.left.next();
                    continue block5;
                }
                case 1: {
                    status.right.next();
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="status") JoinStatus var2, @Named(value="outgoing") VectorContainer var3) throws SchemaChangeException;

    public abstract void doCopyLeft(@Named(value="leftIndex") int var1, @Named(value="outIndex") int var2);

    public abstract void doCopyRight(@Named(value="rightIndex") int var1, @Named(value="outIndex") int var2);

    protected abstract int doCompare(@Named(value="leftIndex") int var1, @Named(value="rightIndex") int var2);
}

