/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.exec.physical.impl.join.JoinWorker;
import org.apache.drill.exec.physical.impl.join.MergeJoinBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordIterator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public final class JoinStatus {
    public final RecordIterator left;
    public final RecordIterator right;
    private boolean iteratorInitialized;
    private int outputPosition;
    public MergeJoinBatch outputBatch;
    private final JoinRelType joinType;
    private boolean allowMarking;
    public boolean ok = true;
    public boolean hasMoreData = false;
    private int targetOutputRowCount;

    public JoinStatus(RecordIterator left, RecordIterator right, MergeJoinBatch output) {
        this.left = left;
        this.right = right;
        this.outputBatch = output;
        this.joinType = output.getJoinType();
        this.iteratorInitialized = false;
        this.allowMarking = true;
    }

    public String toString() {
        return super.toString() + "[leftPosition = " + this.left.getCurrentPosition() + ", rightPosition = " + this.right.getCurrentPosition() + ", outputPosition = " + this.outputPosition + ", joinType = " + this.joinType + ", ok = " + this.ok + ", initialSet = " + this.iteratorInitialized + ", left = " + this.left + ", right = " + this.right + ", outputBatch = " + this.outputBatch + "]";
    }

    public void initialize() {
        if (!this.iteratorInitialized) {
            this.left.next();
            this.right.next();
            this.iteratorInitialized = true;
        }
    }

    public void prepare() {
        if (!this.iteratorInitialized) {
            this.initialize();
        }
        this.left.prepare();
        this.right.prepare();
    }

    public RecordBatch.IterOutcome getLeftStatus() {
        return this.left.getLastOutcome();
    }

    public RecordBatch.IterOutcome getRightStatus() {
        return this.right.getLastOutcome();
    }

    public final int getOutPosition() {
        return this.outputPosition;
    }

    public final void resetOutputPos() {
        this.outputPosition = 0;
    }

    public final boolean isOutgoingBatchFull() {
        Preconditions.checkArgument(this.outputPosition <= this.targetOutputRowCount);
        return this.outputPosition >= this.targetOutputRowCount;
    }

    public final void setTargetOutputRowCount(int outputRowCount) {
        this.targetOutputRowCount = outputRowCount;
    }

    public final void incOutputPos() {
        ++this.outputPosition;
    }

    public void disableMarking() {
        this.allowMarking = false;
    }

    public void enableMarking() {
        this.allowMarking = true;
    }

    public boolean shouldMark() {
        return this.allowMarking;
    }

    public boolean isHasMoreData() {
        return this.hasMoreData;
    }

    public void setHasMoreData(boolean hasMoreData) {
        this.hasMoreData = hasMoreData;
    }

    public JoinWorker.JoinOutcome getOutcome() {
        if (this.hasMoreData) {
            return JoinWorker.JoinOutcome.BATCH_RETURNED;
        }
        if (this.bothMatches(RecordBatch.IterOutcome.NONE) || this.joinType == JoinRelType.INNER && this.eitherMatches(RecordBatch.IterOutcome.NONE) || this.joinType == JoinRelType.LEFT && this.getLeftStatus() == RecordBatch.IterOutcome.NONE || this.joinType == JoinRelType.RIGHT && this.getRightStatus() == RecordBatch.IterOutcome.NONE) {
            return JoinWorker.JoinOutcome.NO_MORE_DATA;
        }
        if (this.bothMatches(RecordBatch.IterOutcome.OK) || this.eitherMatches(RecordBatch.IterOutcome.NONE) && this.eitherMatches(RecordBatch.IterOutcome.OK)) {
            return JoinWorker.JoinOutcome.BATCH_RETURNED;
        }
        if (this.eitherMatches(RecordBatch.IterOutcome.OK_NEW_SCHEMA)) {
            return JoinWorker.JoinOutcome.SCHEMA_CHANGED;
        }
        if (this.eitherMatches(RecordBatch.IterOutcome.NOT_YET)) {
            return JoinWorker.JoinOutcome.WAITING;
        }
        this.ok = false;
        return JoinWorker.JoinOutcome.FAILURE;
    }

    private boolean bothMatches(RecordBatch.IterOutcome outcome) {
        return this.getLeftStatus() == outcome && this.getRightStatus() == outcome;
    }

    private boolean eitherMatches(RecordBatch.IterOutcome outcome) {
        return this.getLeftStatus() == outcome || this.getRightStatus() == outcome;
    }
}

