/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.Map;
import java.util.Set;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.physical.impl.join.BatchSizePredictor;
import org.apache.drill.exec.physical.impl.join.BatchSizePredictorImpl;
import org.apache.drill.exec.physical.impl.join.HashJoinHelperSizeCalculator;
import org.apache.drill.exec.physical.impl.join.HashJoinHelperSizeCalculatorImpl;
import org.apache.drill.exec.physical.impl.join.HashJoinHelperUnusedSizeImpl;
import org.apache.drill.exec.physical.impl.join.HashJoinMemoryCalculator;
import org.apache.drill.exec.physical.impl.join.HashJoinState;
import org.apache.drill.exec.physical.impl.join.HashTableSizeCalculator;
import org.apache.drill.exec.physical.impl.join.HashTableSizeCalculatorConservativeImpl;
import org.apache.drill.exec.physical.impl.join.HashTableSizeCalculatorLeanImpl;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashJoinMemoryCalculatorImpl
implements HashJoinMemoryCalculator {
    private final double safetyFactor;
    private final double fragmentationFactor;
    private final double hashTableDoublingFactor;
    private final String hashTableCalculatorType;
    private final boolean semiJoin;
    private boolean initialized = false;
    private boolean doMemoryCalculation;

    public HashJoinMemoryCalculatorImpl(double safetyFactor, double fragmentationFactor, double hashTableDoublingFactor, String hashTableCalculatorType, boolean semiJoin) {
        this.safetyFactor = safetyFactor;
        this.fragmentationFactor = fragmentationFactor;
        this.hashTableDoublingFactor = hashTableDoublingFactor;
        this.hashTableCalculatorType = hashTableCalculatorType;
        this.semiJoin = semiJoin;
    }

    @Override
    public void initialize(boolean doMemoryCalculation) {
        Preconditions.checkState(!this.initialized);
        this.initialized = true;
        this.doMemoryCalculation = doMemoryCalculation;
    }

    @Override
    public HashJoinMemoryCalculator.BuildSidePartitioning next() {
        Preconditions.checkState(this.initialized);
        if (this.doMemoryCalculation) {
            HashTableSizeCalculator hashTableSizeCalculator;
            if (this.hashTableCalculatorType.equals("LEAN")) {
                hashTableSizeCalculator = new HashTableSizeCalculatorLeanImpl(65536, this.hashTableDoublingFactor);
            } else if (this.hashTableCalculatorType.equals("CONSERVATIVE")) {
                hashTableSizeCalculator = new HashTableSizeCalculatorConservativeImpl(65536, this.hashTableDoublingFactor);
            } else {
                throw new IllegalArgumentException("Invalid calc type: " + this.hashTableCalculatorType);
            }
            return new BuildSidePartitioningImpl(BatchSizePredictorImpl.Factory.INSTANCE, hashTableSizeCalculator, this.semiJoin ? HashJoinHelperUnusedSizeImpl.INSTANCE : HashJoinHelperSizeCalculatorImpl.INSTANCE, this.fragmentationFactor, this.safetyFactor, this.semiJoin);
        }
        return new NoopBuildSidePartitioningImpl();
    }

    @Override
    public HashJoinState getState() {
        return HashJoinState.INITIALIZING;
    }

    public static class BuildSidePartitioningImpl
    implements HashJoinMemoryCalculator.BuildSidePartitioning {
        private static final Logger logger = LoggerFactory.getLogger(BuildSidePartitioningImpl.class);
        private final BatchSizePredictor.Factory batchSizePredictorFactory;
        private final HashTableSizeCalculator hashTableSizeCalculator;
        private final HashJoinHelperSizeCalculator hashJoinHelperSizeCalculator;
        private final double fragmentationFactor;
        private final double safetyFactor;
        private final boolean semiJoin;
        private int maxBatchNumRecordsBuild;
        private int maxBatchNumRecordsProbe;
        private long memoryAvailable;
        private long maxBuildBatchSize;
        private long maxOutputBatchSize;
        private int initialPartitions;
        private int partitions;
        private int recordsPerPartitionBatchBuild;
        private int recordsPerPartitionBatchProbe;
        private int outputBatchSize;
        private Map<String, Long> keySizes;
        private boolean firstCycle;
        private boolean reserveHash;
        private double loadFactor;
        private HashJoinMemoryCalculator.PartitionStatSet partitionStatsSet;
        private long partitionBuildBatchSize;
        private long partitionProbeBatchSize;
        private long reservedMemory;
        private long maxReservedMemory;
        private BatchSizePredictor buildSizePredictor;
        private BatchSizePredictor probeSizePredictor;
        private boolean firstInitialized;
        private boolean initialized;

        public BuildSidePartitioningImpl(BatchSizePredictor.Factory batchSizePredictorFactory, HashTableSizeCalculator hashTableSizeCalculator, HashJoinHelperSizeCalculator hashJoinHelperSizeCalculator, double fragmentationFactor, double safetyFactor, boolean semiJoin) {
            this.batchSizePredictorFactory = Preconditions.checkNotNull(batchSizePredictorFactory);
            this.hashTableSizeCalculator = Preconditions.checkNotNull(hashTableSizeCalculator);
            this.hashJoinHelperSizeCalculator = Preconditions.checkNotNull(hashJoinHelperSizeCalculator);
            this.fragmentationFactor = fragmentationFactor;
            this.safetyFactor = safetyFactor;
            this.semiJoin = semiJoin;
        }

        @Override
        public void initialize(boolean firstCycle, boolean reserveHash, RecordBatch buildBatch, RecordBatch probeBatch, Set<String> joinColumns, boolean probeEmpty, long memoryAvailable, int initialPartitions, int recordsPerPartitionBatchBuild, int recordsPerPartitionBatchProbe, int maxBatchNumRecordsBuild, int maxBatchNumRecordsProbe, int outputBatchSize, double loadFactor) {
            Preconditions.checkNotNull(probeBatch);
            Preconditions.checkNotNull(buildBatch);
            Preconditions.checkNotNull(joinColumns);
            BatchSizePredictor buildSizePredictor = this.batchSizePredictorFactory.create(buildBatch, this.fragmentationFactor, this.safetyFactor);
            BatchSizePredictor probeSizePredictor = this.batchSizePredictorFactory.create(probeBatch, this.fragmentationFactor, this.safetyFactor);
            buildSizePredictor.updateStats();
            probeSizePredictor.updateStats();
            RecordBatchSizer buildSizer = new RecordBatchSizer(buildBatch);
            CaseInsensitiveMap<Long> keySizes = CaseInsensitiveMap.newHashMap();
            for (String joinColumn : joinColumns) {
                RecordBatchSizer.ColumnSize columnSize = buildSizer.columns().get(joinColumn);
                keySizes.put(joinColumn, Long.valueOf(columnSize.getStdNetOrNetSizePerEntry()));
            }
            this.initialize(firstCycle, reserveHash, keySizes, memoryAvailable, initialPartitions, probeEmpty, buildSizePredictor, probeSizePredictor, recordsPerPartitionBatchBuild, recordsPerPartitionBatchProbe, maxBatchNumRecordsBuild, maxBatchNumRecordsProbe, outputBatchSize, loadFactor);
        }

        @VisibleForTesting
        protected void initialize(boolean firstCycle, boolean reserveHash, CaseInsensitiveMap<Long> keySizes, long memoryAvailable, int initialPartitions, boolean probeEmpty, BatchSizePredictor buildSizePredictor, BatchSizePredictor probeSizePredictor, int recordsPerPartitionBatchBuild, int recordsPerPartitionBatchProbe, int maxBatchNumRecordsBuild, int maxBatchNumRecordsProbe, int outputBatchSize, double loadFactor) {
            Preconditions.checkState(!this.firstInitialized);
            Preconditions.checkArgument(initialPartitions >= 1);
            Preconditions.checkState(!probeEmpty || !probeSizePredictor.hadDataLastTime());
            this.firstInitialized = true;
            this.loadFactor = loadFactor;
            this.firstCycle = firstCycle;
            this.reserveHash = reserveHash;
            this.keySizes = Preconditions.checkNotNull(keySizes);
            this.memoryAvailable = memoryAvailable;
            this.buildSizePredictor = buildSizePredictor;
            this.probeSizePredictor = probeSizePredictor;
            this.initialPartitions = initialPartitions;
            this.recordsPerPartitionBatchBuild = recordsPerPartitionBatchBuild;
            this.recordsPerPartitionBatchProbe = recordsPerPartitionBatchProbe;
            this.maxBatchNumRecordsBuild = maxBatchNumRecordsBuild;
            this.maxBatchNumRecordsProbe = maxBatchNumRecordsProbe;
            this.outputBatchSize = outputBatchSize;
            this.calculateMemoryUsage();
            logger.debug("Creating {} partitions when {} initial partitions configured.", (Object)this.partitions, (Object)initialPartitions);
        }

        @Override
        public void setPartitionStatSet(HashJoinMemoryCalculator.PartitionStatSet partitionStatSet) {
            Preconditions.checkState(!this.initialized);
            this.initialized = true;
            this.partitionStatsSet = Preconditions.checkNotNull(partitionStatSet);
        }

        @Override
        public int getNumPartitions() {
            return this.partitions;
        }

        @Override
        public long getBuildReservedMemory() {
            Preconditions.checkState(this.firstInitialized);
            return this.reservedMemory;
        }

        @Override
        public long getMaxReservedMemory() {
            Preconditions.checkState(this.firstInitialized);
            return this.maxReservedMemory;
        }

        private void calculateMemoryUsage() {
            this.maxBuildBatchSize = this.buildSizePredictor.predictBatchSize(this.maxBatchNumRecordsBuild, false);
            this.partitionBuildBatchSize = this.buildSizePredictor.predictBatchSize(this.recordsPerPartitionBatchBuild, this.reserveHash);
            if (this.probeSizePredictor.hadDataLastTime()) {
                this.partitionProbeBatchSize = this.probeSizePredictor.predictBatchSize(this.recordsPerPartitionBatchProbe, this.reserveHash);
            }
            this.maxOutputBatchSize = (long)((double)this.outputBatchSize * this.fragmentationFactor * this.safetyFactor);
            long probeReservedMemory = 0L;
            this.partitions = this.initialPartitions;
            while (true) {
                long incompletePartitionsBatchSizes = (long)this.partitions * this.partitionBuildBatchSize;
                this.reservedMemory = incompletePartitionsBatchSizes + this.maxBuildBatchSize;
                if (!this.firstCycle) {
                    this.reservedMemory += this.probeSizePredictor.getBatchSize();
                }
                if (this.probeSizePredictor.hadDataLastTime()) {
                    probeReservedMemory = PostBuildCalculationsImpl.calculateReservedMemory(this.partitions, this.probeSizePredictor.getBatchSize(), this.maxOutputBatchSize, this.partitionProbeBatchSize);
                    this.maxReservedMemory = Math.max(this.reservedMemory, probeReservedMemory);
                } else {
                    this.maxReservedMemory = this.reservedMemory;
                }
                if (!this.firstCycle || this.maxReservedMemory <= this.memoryAvailable || this.partitions == 2) break;
                this.partitions /= 2;
            }
            if (this.maxReservedMemory > this.memoryAvailable) {
                String message = String.format("HashJoin needs to reserve %d bytes of memory but there are only %d bytes available. Using %d num partitions with %d initial partitions. Additional info:\nbuildBatchSize = %d\nbuildNumRecords = %d\npartitionBuildBatchSize = %d\nrecordsPerPartitionBatchBuild = %d\nprobeBatchSize = %d\nprobeNumRecords = %d\npartitionProbeBatchSize = %d\nrecordsPerPartitionBatchProbe = %d\n", this.reservedMemory, this.memoryAvailable, this.partitions, this.initialPartitions, this.buildSizePredictor.getBatchSize(), this.buildSizePredictor.getNumRecords(), this.partitionBuildBatchSize, this.recordsPerPartitionBatchBuild, this.probeSizePredictor.getBatchSize(), this.probeSizePredictor.getNumRecords(), this.partitionProbeBatchSize, this.recordsPerPartitionBatchProbe);
                String phase = "Probe phase: ";
                if (this.reservedMemory > this.memoryAvailable) {
                    phase = this.probeSizePredictor.hadDataLastTime() && probeReservedMemory > this.memoryAvailable ? "Build and Probe phases: " : "Build phase: ";
                }
                message = phase + message;
                logger.warn(message);
            }
        }

        @Override
        public boolean shouldSpill() {
            Preconditions.checkState(this.initialized);
            long consumedMemory = this.reservedMemory;
            if (this.reserveHash) {
                consumedMemory += 4L * this.partitionStatsSet.getNumInMemoryRecords();
            }
            return (consumedMemory += RecordBatchSizer.multiplyByFactor(this.partitionStatsSet.getConsumedMemory(), this.fragmentationFactor)) > this.memoryAvailable;
        }

        @Override
        public HashJoinMemoryCalculator.PostBuildCalculations next() {
            Preconditions.checkState(this.initialized);
            return new PostBuildCalculationsImpl(this.firstCycle, this.probeSizePredictor, this.memoryAvailable, this.maxOutputBatchSize, this.maxBatchNumRecordsProbe, this.recordsPerPartitionBatchProbe, this.partitionStatsSet, this.keySizes, this.hashTableSizeCalculator, this.hashJoinHelperSizeCalculator, this.fragmentationFactor, this.safetyFactor, this.loadFactor, this.reserveHash, this.semiJoin);
        }

        @Override
        public HashJoinState getState() {
            return HashJoinState.BUILD_SIDE_PARTITIONING;
        }

        @Override
        public String makeDebugString() {
            String calcVars = String.format("Build side calculator vars:\nmemoryAvailable = %s\nmaxBuildBatchSize = %s\nmaxOutputBatchSize = %s\n", HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.memoryAvailable), HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.maxBuildBatchSize), HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.maxOutputBatchSize));
            String partitionStatDebugString = "";
            if (this.partitionStatsSet != null) {
                partitionStatDebugString = this.partitionStatsSet.makeDebugString();
            }
            return calcVars + "\n" + partitionStatDebugString;
        }
    }

    public static class NoopBuildSidePartitioningImpl
    implements HashJoinMemoryCalculator.BuildSidePartitioning {
        private int initialPartitions;
        private int recordsPerPartitionBatchProbe;

        @Override
        public void initialize(boolean firstCycle, boolean reserveHash, RecordBatch buildSideBatch, RecordBatch probeSideBatch, Set<String> joinColumns, boolean probeEmpty, long memoryAvailable, int initialPartitions, int recordsPerPartitionBatchBuild, int recordsPerPartitionBatchProbe, int maxBatchNumRecordsBuild, int maxBatchNumRecordsProbe, int outputBatchSize, double loadFactor) {
            this.initialPartitions = initialPartitions;
            this.recordsPerPartitionBatchProbe = recordsPerPartitionBatchProbe;
        }

        @Override
        public void setPartitionStatSet(HashJoinMemoryCalculator.PartitionStatSet partitionStatSet) {
        }

        @Override
        public int getNumPartitions() {
            return this.initialPartitions;
        }

        @Override
        public long getBuildReservedMemory() {
            return 0L;
        }

        @Override
        public long getMaxReservedMemory() {
            return 0L;
        }

        @Override
        public boolean shouldSpill() {
            return false;
        }

        @Override
        public String makeDebugString() {
            return "No debugging for " + NoopBuildSidePartitioningImpl.class.getCanonicalName();
        }

        @Override
        public HashJoinMemoryCalculator.PostBuildCalculations next() {
            return new NoopPostBuildCalculationsImpl(this.recordsPerPartitionBatchProbe);
        }

        @Override
        public HashJoinState getState() {
            return HashJoinState.BUILD_SIDE_PARTITIONING;
        }
    }

    public static class PostBuildCalculationsImpl
    implements HashJoinMemoryCalculator.PostBuildCalculations {
        private static final Logger logger = LoggerFactory.getLogger(PostBuildCalculationsImpl.class);
        public static final int MIN_RECORDS_PER_PARTITION_BATCH_PROBE = 10;
        private final boolean firstCycle;
        private final BatchSizePredictor probeSizePredictor;
        private final long memoryAvailable;
        private final long maxOutputBatchSize;
        private final int recordsPerPartitionBatchProbe;
        private final HashJoinMemoryCalculator.PartitionStatSet buildPartitionStatSet;
        private final Map<String, Long> keySizes;
        private final HashTableSizeCalculator hashTableSizeCalculator;
        private final HashJoinHelperSizeCalculator hashJoinHelperSizeCalculator;
        private final double fragmentationFactor;
        private final double safetyFactor;
        private final double loadFactor;
        private final boolean reserveHash;
        private final boolean semiJoin;
        private boolean initialized;
        private long consumedMemory;
        private boolean probeEmpty;
        private long partitionProbeBatchSize;
        private int computedProbeRecordsPerBatch;

        @VisibleForTesting
        public PostBuildCalculationsImpl(boolean firstCycle, BatchSizePredictor probeSizePredictor, long memoryAvailable, long maxOutputBatchSize, int maxBatchNumRecordsProbe, int recordsPerPartitionBatchProbe, HashJoinMemoryCalculator.PartitionStatSet buildPartitionStatSet, Map<String, Long> keySizes, HashTableSizeCalculator hashTableSizeCalculator, HashJoinHelperSizeCalculator hashJoinHelperSizeCalculator, double fragmentationFactor, double safetyFactor, double loadFactor, boolean reserveHash, boolean semiJoin) {
            this.firstCycle = firstCycle;
            this.probeSizePredictor = Preconditions.checkNotNull(probeSizePredictor);
            this.memoryAvailable = memoryAvailable;
            this.maxOutputBatchSize = maxOutputBatchSize;
            this.buildPartitionStatSet = Preconditions.checkNotNull(buildPartitionStatSet);
            this.keySizes = Preconditions.checkNotNull(keySizes);
            this.hashTableSizeCalculator = Preconditions.checkNotNull(hashTableSizeCalculator);
            this.hashJoinHelperSizeCalculator = Preconditions.checkNotNull(hashJoinHelperSizeCalculator);
            this.fragmentationFactor = fragmentationFactor;
            this.safetyFactor = safetyFactor;
            this.loadFactor = loadFactor;
            this.reserveHash = reserveHash;
            this.semiJoin = semiJoin;
            this.recordsPerPartitionBatchProbe = recordsPerPartitionBatchProbe;
            this.computedProbeRecordsPerBatch = recordsPerPartitionBatchProbe;
        }

        @Override
        public void initialize(boolean probeEmpty) {
            Preconditions.checkState(!this.initialized);
            Preconditions.checkState(!probeEmpty || !this.probeSizePredictor.hadDataLastTime());
            this.initialized = true;
            this.probeEmpty = probeEmpty;
            if (probeEmpty) {
                return;
            }
            if (!this.probeSizePredictor.hadDataLastTime()) {
                this.probeSizePredictor.updateStats();
            }
            this.partitionProbeBatchSize = this.probeSizePredictor.predictBatchSize(this.recordsPerPartitionBatchProbe, this.reserveHash);
            long worstCaseProbeMemory = PostBuildCalculationsImpl.calculateReservedMemory(this.buildPartitionStatSet.getSize(), this.getIncomingProbeBatchReservedSpace(), this.maxOutputBatchSize, this.partitionProbeBatchSize);
            if (worstCaseProbeMemory > this.memoryAvailable) {
                this.computedProbeRecordsPerBatch = PostBuildCalculationsImpl.computeProbeRecordsPerBatch(this.memoryAvailable, this.buildPartitionStatSet.getSize(), this.recordsPerPartitionBatchProbe, 10, this.getIncomingProbeBatchReservedSpace(), this.maxOutputBatchSize, this.partitionProbeBatchSize);
                this.partitionProbeBatchSize = this.probeSizePredictor.predictBatchSize(this.computedProbeRecordsPerBatch, this.reserveHash);
            }
        }

        @Override
        public int getProbeRecordsPerBatch() {
            Preconditions.checkState(this.initialized);
            return this.computedProbeRecordsPerBatch;
        }

        public long getIncomingProbeBatchReservedSpace() {
            Preconditions.checkState(this.initialized);
            if (this.firstCycle) {
                return 0L;
            }
            return this.probeSizePredictor.getBatchSize();
        }

        @VisibleForTesting
        public long getPartitionProbeBatchSize() {
            return this.partitionProbeBatchSize;
        }

        public long getConsumedMemory() {
            Preconditions.checkState(this.initialized);
            return this.consumedMemory;
        }

        public static int computeProbeRecordsPerBatch(long memoryAvailable, int numPartitions, int defaultProbeRecordsPerBatch, int minProbeRecordsPerBatch, long maxProbeBatchSize, long maxOutputBatchSize, long defaultPartitionProbeBatchSize) {
            long memoryForPartitionBatches = memoryAvailable - maxProbeBatchSize - maxOutputBatchSize;
            if (memoryForPartitionBatches < 0L) {
                logger.warn("Not enough memory for probing:\nMemory available: {}\nMax probe batch size: {}\nMax output batch size: {}", new Object[]{memoryAvailable, maxProbeBatchSize, maxOutputBatchSize});
                return minProbeRecordsPerBatch;
            }
            long memoryForPartitionBatch = (memoryForPartitionBatches + (long)numPartitions - 1L) / (long)numPartitions;
            long scaleFactor = (defaultPartitionProbeBatchSize + memoryForPartitionBatch - 1L) / memoryForPartitionBatch;
            return Math.max((int)((long)defaultProbeRecordsPerBatch / scaleFactor), minProbeRecordsPerBatch);
        }

        public static long calculateReservedMemory(int numSpilledPartitions, long maxProbeBatchSize, long maxOutputBatchSize, long partitionProbeBatchSize) {
            return maxProbeBatchSize + maxOutputBatchSize + partitionProbeBatchSize * (long)numSpilledPartitions;
        }

        @Override
        public boolean shouldSpill() {
            Preconditions.checkState(this.initialized);
            if (this.probeEmpty) {
                return false;
            }
            long reservedMemory = PostBuildCalculationsImpl.calculateReservedMemory(this.buildPartitionStatSet.getNumSpilledPartitions(), this.getIncomingProbeBatchReservedSpace(), this.maxOutputBatchSize, this.partitionProbeBatchSize);
            this.consumedMemory = reservedMemory + RecordBatchSizer.multiplyByFactor(this.buildPartitionStatSet.getConsumedMemory(), this.fragmentationFactor);
            if (this.buildPartitionStatSet.allSpilled()) {
                return false;
            }
            for (int partitionIndex : this.buildPartitionStatSet.getInMemoryPartitions()) {
                HashJoinMemoryCalculator.PartitionStat partitionStat = this.buildPartitionStatSet.get(partitionIndex);
                if (partitionStat.getNumInMemoryRecords() == 0L) continue;
                long hashTableSize = this.hashTableSizeCalculator.calculateSize(partitionStat, this.keySizes, this.loadFactor, this.safetyFactor, this.fragmentationFactor);
                long hashJoinHelperSize = this.hashJoinHelperSizeCalculator.calculateSize(partitionStat, this.fragmentationFactor);
                this.consumedMemory += hashTableSize + hashJoinHelperSize;
            }
            return this.consumedMemory > this.memoryAvailable;
        }

        @Override
        public HashJoinMemoryCalculator next() {
            Preconditions.checkState(this.initialized);
            if (this.buildPartitionStatSet.noneSpilled()) {
                return null;
            }
            return new HashJoinMemoryCalculatorImpl(this.safetyFactor, this.fragmentationFactor, this.hashTableSizeCalculator.getDoublingFactor(), this.hashTableSizeCalculator.getType(), this.semiJoin);
        }

        @Override
        public HashJoinState getState() {
            return HashJoinState.POST_BUILD_CALCULATIONS;
        }

        @Override
        public String makeDebugString() {
            Preconditions.checkState(this.initialized);
            String calcVars = String.format("Mem calc stats:\nmemoryLimit = %s\nconsumedMemory = %s\nmaxIncomingProbeBatchReservedSpace = %s\nmaxOutputBatchSize = %s\n", HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.memoryAvailable), HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.consumedMemory), HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.getIncomingProbeBatchReservedSpace()), HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.maxOutputBatchSize));
            StringBuilder hashJoinHelperSb = new StringBuilder("Partition Hash Join Helpers\n");
            StringBuilder hashTableSb = new StringBuilder("Partition Hash Tables\n");
            for (int partitionIndex : this.buildPartitionStatSet.getInMemoryPartitions()) {
                HashJoinMemoryCalculator.PartitionStat partitionStat = this.buildPartitionStatSet.get(partitionIndex);
                String partitionPrefix = partitionIndex + ": ";
                hashJoinHelperSb.append(partitionPrefix);
                hashTableSb.append(partitionPrefix);
                if (partitionStat.getNumInMemoryBatches() == 0) {
                    hashJoinHelperSb.append("Empty");
                    hashTableSb.append("Empty");
                } else {
                    long hashJoinHelperSize = this.hashJoinHelperSizeCalculator.calculateSize(partitionStat, this.fragmentationFactor);
                    long hashTableSize = this.hashTableSizeCalculator.calculateSize(partitionStat, this.keySizes, this.loadFactor, this.safetyFactor, this.fragmentationFactor);
                    hashJoinHelperSb.append(HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(hashJoinHelperSize));
                    hashTableSb.append(HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(hashTableSize));
                }
                hashJoinHelperSb.append("\n");
                hashTableSb.append("\n");
            }
            return calcVars + "\n" + this.buildPartitionStatSet.makeDebugString() + "\n" + hashJoinHelperSb.toString() + "\n" + hashTableSb.toString();
        }
    }

    public static class NoopPostBuildCalculationsImpl
    implements HashJoinMemoryCalculator.PostBuildCalculations {
        private final int recordsPerPartitionBatchProbe;

        public NoopPostBuildCalculationsImpl(int recordsPerPartitionBatchProbe) {
            this.recordsPerPartitionBatchProbe = recordsPerPartitionBatchProbe;
        }

        @Override
        public void initialize(boolean hasProbeData) {
        }

        @Override
        public int getProbeRecordsPerBatch() {
            return this.recordsPerPartitionBatchProbe;
        }

        @Override
        public boolean shouldSpill() {
            return false;
        }

        @Override
        public HashJoinMemoryCalculator next() {
            return null;
        }

        @Override
        public HashJoinState getState() {
            return HashJoinState.POST_BUILD_CALCULATIONS;
        }

        @Override
        public String makeDebugString() {
            return "Noop " + NoopPostBuildCalculationsImpl.class.getCanonicalName() + " calculator.";
        }
    }
}

