/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import org.apache.drill.exec.physical.impl.join.HashJoinHelperSizeCalculator;
import org.apache.drill.exec.physical.impl.join.HashJoinMemoryCalculator;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class HashJoinHelperSizeCalculatorImpl
implements HashJoinHelperSizeCalculator {
    public static final HashJoinHelperSizeCalculatorImpl INSTANCE = new HashJoinHelperSizeCalculatorImpl();

    private HashJoinHelperSizeCalculatorImpl() {
    }

    @Override
    public long calculateSize(HashJoinMemoryCalculator.PartitionStat partitionStat, double fragmentationFactor) {
        Preconditions.checkArgument(!partitionStat.isSpilled());
        long joinHelperSize = 262144L;
        for (HashJoinMemoryCalculator.BatchStat batchStat : partitionStat.getInMemoryBatches()) {
            joinHelperSize += batchStat.getNumRecords() * 4L;
        }
        return RecordBatchSizer.multiplyByFactor(joinHelperSize, fragmentationFactor);
    }
}

