/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.HashJoinPOP;
import org.apache.drill.exec.physical.impl.common.Comparator;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.physical.impl.join.AbstractHashBinaryRecordBatch;
import org.apache.drill.exec.physical.impl.join.HashJoinProbeTemplate;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.physical.impl.join.Probe;
import org.apache.drill.exec.physical.impl.join.RowKeyJoin;
import org.apache.drill.exec.planner.common.JoinControl;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class HashJoinBatch
extends AbstractHashBinaryRecordBatch<HashJoinPOP>
implements RowKeyJoin {
    private final JoinRelType joinType;
    private final List<JoinCondition> conditions;
    private final JoinControl joinControl;

    public HashJoinBatch(HashJoinPOP popConfig, FragmentContext context, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, left, right);
        this.joinType = popConfig.getJoinType();
        this.conditions = popConfig.getConditions();
        this.joinControl = new JoinControl(popConfig.getJoinControl());
        this.semiJoin = popConfig.isSemiJoin();
        this.joinIsLeftOrFull = this.joinType == JoinRelType.LEFT || this.joinType == JoinRelType.FULL;
        this.joinIsRightOrFull = this.joinType == JoinRelType.RIGHT || this.joinType == JoinRelType.FULL;
        this.isRowKeyJoin = popConfig.isRowKeyJoin();
        for (int i = 0; i < this.conditions.size(); ++i) {
            SchemaPath rightPath = (SchemaPath)this.conditions.get(i).getRight();
            PathSegment.NameSegment nameSegment = (PathSegment.NameSegment)rightPath.getLastSegment();
            this.buildJoinColumns.add(nameSegment.getPath());
            String refName = "build_side_" + i;
            this.rightExpr.add(new NamedExpression(this.conditions.get(i).getRight(), new FieldReference(refName)));
        }
        this.runtimeFilterDef = popConfig.getRuntimeFilterDef();
        this.enableRuntimeFilter = context.getOptions().getOption(ExecConstants.HASHJOIN_ENABLE_RUNTIME_FILTER) && this.runtimeFilterDef != null;
    }

    @Override
    public Probe createProbe() {
        return new HashJoinProbeTemplate();
    }

    @Override
    public void setupProbe() throws SchemaChangeException {
        this.probe.setup(this.probeBatch, this, this.joinType, this.semiJoin, this.leftUpstream, this.partitions, this.spilledState.getCycle(), this.container, this.spilledInners, this.buildSideIsEmpty.booleanValue(), this.numPartitions, this.rightHVColPosition);
    }

    @Override
    protected HashTableConfig buildHashTableConfig() {
        ArrayList<Comparator> comparators = Lists.newArrayListWithExpectedSize(this.conditions.size());
        this.conditions.forEach(cond -> comparators.add(JoinUtils.checkAndReturnSupportedJoinComparator(cond)));
        ArrayList<NamedExpression> leftExpr = new ArrayList<NamedExpression>(this.conditions.size());
        for (int i = 0; i < this.conditions.size(); ++i) {
            leftExpr.add(new NamedExpression(this.conditions.get(i).getLeft(), new FieldReference("probe_side_" + i)));
        }
        if (this.leftUpstream != RecordBatch.IterOutcome.OK_NEW_SCHEMA && this.leftUpstream != RecordBatch.IterOutcome.OK) {
            leftExpr = null;
        } else if (this.probeBatch.getSchema().getSelectionVectorMode() != BatchSchema.SelectionVectorMode.NONE) {
            throw UserException.internalError(null).message("Hash join does not support probe batch with selection vectors.", new Object[0]).addContext("Probe batch has selection mode", this.probeBatch.getSchema().getSelectionVectorMode().toString()).build(this.logger);
        }
        return new HashTableConfig((int)this.context.getOptions().getOption(ExecConstants.MIN_HASH_TABLE_SIZE), true, 0.75f, this.rightExpr, leftExpr, comparators, this.joinControl.asInt(), false);
    }

    @Override
    public void dump() {
        this.logger.error("HashJoinBatch[container={}, left={}, right={}, leftOutcome={}, rightOutcome={}, joinType={}, hashJoinProbe={}, rightExpr={}, canSpill={}, buildSchema={}, probeSchema={}]", new Object[]{this.container, this.left, this.right, this.leftUpstream, this.rightUpstream, this.joinType, this.probe, this.rightExpr, this.canSpill, this.buildSchema, this.probeSchema});
    }

    @Override
    public boolean hasRowKeyBatch() {
        return this.buildComplete;
    }

    @Override
    public AbstractRecordBatch.BatchState getBatchState() {
        return this.state;
    }

    @Override
    public void setBatchState(AbstractRecordBatch.BatchState newState) {
        this.state = newState;
    }

    @Override
    public void setRowKeyJoinState(RowKeyJoin.RowKeyJoinState newState) {
        this.rkJoinState = newState;
    }

    @Override
    public RowKeyJoin.RowKeyJoinState getRowKeyJoinState() {
        return this.rkJoinState;
    }

    @Override
    public Pair<ValueVector, Integer> nextRowKeyBatch() {
        if (this.buildComplete) {
            Pair<VectorContainer, Integer> pp = this.partitions[0].nextBatch();
            if (pp != null) {
                VectorWrapper vw = (VectorWrapper)Iterables.get((Iterable)pp.getLeft(), 0);
                Object vv = vw.getValueVector();
                return Pair.of(vv, (Object)((Integer)pp.getRight()));
            }
        } else if (this.partitions == null && this.firstOutputBatch) {
            this.firstOutputBatch = false;
            if (this.right.getRecordCount() > 0) {
                VectorWrapper vw = (VectorWrapper)Iterables.get(this.right, 0);
                Object vv = vw.getValueVector();
                return Pair.of(vv, (Object)(this.right.getRecordCount() - 1));
            }
        }
        return null;
    }
}

