/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.flatten;

import com.carrotsearch.hppc.IntHashSet;
import com.sun.codemodel.JExpr;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.FlattenPOP;
import org.apache.drill.exec.physical.impl.flatten.Flattener;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchMemoryManager;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractRepeatedMapVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlattenRecordBatch
extends AbstractSingleRecordBatch<FlattenPOP> {
    private static final Logger logger = LoggerFactory.getLogger(FlattenRecordBatch.class);
    private Flattener flattener;
    private List<ValueVector> allocationVectors;
    private List<BaseWriter.ComplexWriter> complexWriters;
    private boolean hasRemainder;
    private int remainderIndex;
    private int recordCount;
    private final FlattenMemoryManager flattenMemoryManager;
    private final Flattener.Monitor monitor = new Flattener.Monitor(){

        @Override
        public int getBufferSizeFor(int recordCount) {
            int bufferSize = 0;
            for (ValueVector vv : FlattenRecordBatch.this.allocationVectors) {
                bufferSize += vv.getBufferSizeFor(recordCount);
            }
            return bufferSize;
        }
    };
    private static final String EMPTY_STRING = "";

    public FlattenRecordBatch(FlattenPOP pop, RecordBatch incoming, FragmentContext context) throws OutOfMemoryException {
        super(pop, context, incoming);
        int configuredBatchSize = (int)context.getOptions().getOption(ExecConstants.OUTPUT_BATCH_SIZE_VALIDATOR);
        this.flattenMemoryManager = new FlattenMemoryManager(configuredBatchSize);
        RecordBatchStats.printConfiguredBatchSize(this.getRecordBatchStatsContext(), configuredBatchSize);
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    protected void cancelIncoming() {
        super.cancelIncoming();
        this.hasRemainder = false;
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.hasRemainder) {
            this.handleRemainder();
            return this.getFinalOutcome(this.hasRemainder);
        }
        return super.innerNext();
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.container;
    }

    private void setFlattenVector() {
        RepeatedValueVector vector;
        TypedFieldId typedFieldId = this.incoming.getValueVectorId(((FlattenPOP)this.popConfig).getColumn());
        MaterializedField field = this.incoming.getSchema().getColumn(typedFieldId.getFieldIds()[0]);
        Object inVV = this.incoming.getValueAccessorById(field.getValueClass(), typedFieldId.getFieldIds()).getValueVector();
        if (!(inVV instanceof RepeatedValueVector)) {
            if (this.incoming.getRecordCount() != 0) {
                throw UserException.unsupportedError().message("Flatten does not support inputs of non-list values.", new Object[0]).build(logger);
            }
            logger.error("setFlattenVector cast failed and recordcount is 0, create empty vector anyway.");
            vector = new RepeatedMapVector(field, this.oContext.getAllocator(), null);
        } else {
            vector = (RepeatedValueVector)RepeatedValueVector.class.cast(inVV);
        }
        this.flattener.setFlattenField(vector);
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        this.flattenMemoryManager.update();
        this.flattener.setOutputCount(this.flattenMemoryManager.getOutputRowCount());
        int incomingRecordCount = this.incoming.getRecordCount();
        this.doAlloc(this.flattenMemoryManager.getOutputRowCount());
        this.setFlattenVector();
        int childCount = incomingRecordCount == 0 ? 0 : this.flattener.getFlattenField().getAccessor().getInnerValueCount();
        int outputRecords = childCount == 0 ? 0 : this.flattener.flattenRecords(incomingRecordCount, 0, this.monitor);
        this.setValueCount(outputRecords);
        if (outputRecords < childCount) {
            this.hasRemainder = true;
            this.remainderIndex = outputRecords;
        } else {
            this.flattener.resetGroupIndex();
            VectorAccessibleUtilities.clear(this.incoming.getContainer());
        }
        if (this.complexWriters != null) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
        this.flattenMemoryManager.updateOutgoingStats(outputRecords);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this, this.getRecordBatchStatsContext());
        return this.getFinalOutcome(this.hasRemainder);
    }

    private void handleRemainder() {
        int remainingRecordCount = this.flattener.getFlattenField().getAccessor().getInnerValueCount() - this.remainderIndex;
        this.doAlloc(Math.min(remainingRecordCount, this.flattenMemoryManager.getOutputRowCount()));
        int projRecords = this.flattener.flattenRecords(remainingRecordCount, 0, this.monitor);
        if (projRecords < remainingRecordCount) {
            this.setValueCount(projRecords);
            this.remainderIndex += projRecords;
        } else {
            this.setValueCount(remainingRecordCount);
            this.hasRemainder = false;
            this.remainderIndex = 0;
            VectorAccessibleUtilities.clear(this.incoming.getContainer());
            this.flattener.resetGroupIndex();
        }
        if (this.complexWriters != null) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
        this.flattenMemoryManager.updateOutgoingStats(projRecords);
    }

    public void addComplexWriter(BaseWriter.ComplexWriter writer) {
        this.complexWriters.add(writer);
    }

    private void doAlloc(int recordCount) {
        for (ValueVector v : this.allocationVectors) {
            RecordBatchSizer.ColumnSize colSize = this.flattenMemoryManager.getColumnSize(v.getField().getName());
            colSize.allocateVector(v, recordCount);
        }
        if (this.complexWriters != null) {
            for (BaseWriter.ComplexWriter writer : this.complexWriters) {
                writer.allocate();
            }
        }
    }

    private void setValueCount(int count) {
        this.recordCount = count;
        if (count == 0) {
            this.container.setEmpty();
        } else {
            this.container.setValueCount(count);
        }
        if (this.complexWriters != null) {
            for (BaseWriter.ComplexWriter writer : this.complexWriters) {
                writer.setValueCount(count);
            }
        }
    }

    private FieldReference getRef(NamedExpression e) {
        return e.getRef();
    }

    private TransferPair getFlattenFieldTransferPair(FieldReference reference) {
        TypedFieldId fieldId = this.incoming.getValueVectorId(((FlattenPOP)this.popConfig).getColumn());
        Class<?> vectorClass = this.incoming.getSchema().getColumn(fieldId.getFieldIds()[0]).getValueClass();
        Object flattenField = this.incoming.getValueAccessorById(vectorClass, fieldId.getFieldIds()).getValueVector();
        TransferPair tp = null;
        if (flattenField instanceof AbstractRepeatedMapVector) {
            tp = ((AbstractRepeatedMapVector)flattenField).getTransferPairToSingleMap(reference.getAsNamePart().getName(), this.oContext.getAllocator());
        } else if (!(flattenField instanceof RepeatedValueVector)) {
            if (this.incoming.getRecordCount() != 0) {
                throw UserException.unsupportedError().message("Flatten does not support inputs of non-list values.", new Object[0]).build(logger);
            }
            logger.error("Cannot cast {} to RepeatedValueVector", flattenField);
            RepeatedMapVector vv = new RepeatedMapVector(flattenField.getField(), this.oContext.getAllocator(), null);
            tp = ((RepeatedValueVector)RepeatedValueVector.class.cast(vv)).getTransferPair(reference.getAsNamePart().getName(), this.oContext.getAllocator());
        } else {
            ValueVector vvIn = ((RepeatedValueVector)RepeatedValueVector.class.cast(flattenField)).getDataVector();
            if (vvIn != null) {
                tp = vvIn.getTransferPair(reference.getAsNamePart().getName(), this.oContext.getAllocator());
            }
        }
        return tp;
    }

    @Override
    protected boolean setupNewSchema() {
        this.allocationVectors = new ArrayList<ValueVector>();
        this.container.clear();
        List<NamedExpression> exprs = this.getExpressionList();
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        ArrayList<TransferPair> transfers = new ArrayList<TransferPair>();
        ClassGenerator<Flattener> cg = CodeGenerator.getRoot(Flattener.TEMPLATE_DEFINITION, this.context.getOptions());
        cg.getCodeGenerator().plainJavaCapable(true);
        IntHashSet transferFieldIds = new IntHashSet();
        NamedExpression flattenExpr = new NamedExpression(((FlattenPOP)this.popConfig).getColumn(), new FieldReference(((FlattenPOP)this.popConfig).getColumn()));
        ValueVectorReadExpression vectorRead = (ValueVectorReadExpression)ExpressionTreeMaterializer.materialize(flattenExpr.getExpr(), this.incoming, collector, this.context.getFunctionRegistry(), true);
        FieldReference fieldReference = flattenExpr.getRef();
        TransferPair transferPair = this.getFlattenFieldTransferPair(fieldReference);
        if (transferPair != null) {
            ValueVector flattenVector = transferPair.getTo();
            if (exprs.size() == 0 && flattenVector.getField().getType().equals(Types.LATE_BIND_TYPE)) {
                MaterializedField outputField = MaterializedField.create(fieldReference.getAsNamePart().getName(), Types.OPTIONAL_INT);
                ValueVector vector = TypeHelper.getNewVector(outputField, this.oContext.getAllocator());
                this.container.add(vector);
            } else {
                transfers.add(transferPair);
                this.container.add(flattenVector);
                transferFieldIds.add(vectorRead.getFieldId().getFieldIds()[0]);
            }
        }
        logger.debug("Added transfer for project expression.");
        ClassifierResult result = new ClassifierResult();
        for (NamedExpression namedExpression : exprs) {
            TypedFieldId id;
            Object incomingVector;
            result.clear();
            String outputName = this.getRef(namedExpression).getRootSegment().getPath();
            if (result != null && result.outputNames != null && result.outputNames.size() > 0) {
                for (int j = 0; j < result.outputNames.size(); ++j) {
                    if (result.outputNames.get(j).equals(EMPTY_STRING)) continue;
                    outputName = result.outputNames.get(j);
                    break;
                }
            }
            LogicalExpression expr = ExpressionTreeMaterializer.materialize(namedExpression.getExpr(), this.incoming, collector, this.context.getFunctionRegistry(), true);
            collector.reportErrors(logger);
            if (expr instanceof DrillFuncHolderExpr && ((DrillFuncHolderExpr)expr).getHolder().isComplexWriterFuncHolder()) {
                if (this.complexWriters == null) {
                    this.complexWriters = new ArrayList<BaseWriter.ComplexWriter>();
                }
                ((DrillFuncHolderExpr)expr).setFieldReference(namedExpression.getRef());
                cg.addExpr(expr);
                continue;
            }
            MaterializedField outputField = expr instanceof ValueVectorReadExpression ? ((incomingVector = this.incoming.getValueAccessorById((id = ((ValueVectorReadExpression)ValueVectorReadExpression.class.cast(expr)).getFieldId()).getIntermediateClass(), id.getFieldIds()).getValueVector()) != null ? incomingVector.getField().clone() : MaterializedField.create(outputName, expr.getMajorType())) : MaterializedField.create(outputName, expr.getMajorType());
            ValueVector vector = TypeHelper.getNewVector(outputField, this.oContext.getAllocator());
            this.allocationVectors.add(vector);
            TypedFieldId fid = this.container.add(vector);
            ValueVectorWriteExpression write = new ValueVectorWriteExpression(fid, expr, true);
            cg.addExpr(write);
            logger.debug("Added eval for project expression.");
        }
        cg.rotateBlock();
        cg.getEvalBlock()._return(JExpr.TRUE);
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        try {
            this.flattener = this.context.getImplementationClass(cg.getCodeGenerator());
            this.flattener.setup(this.context, this.incoming, this, transfers);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        return true;
    }

    private List<NamedExpression> getExpressionList() {
        ArrayList<NamedExpression> exprs = new ArrayList<NamedExpression>();
        for (MaterializedField field : this.incoming.getSchema()) {
            String fieldName = field.getName();
            if (fieldName.equals(((FlattenPOP)this.popConfig).getColumn().getRootSegmentPath())) continue;
            exprs.add(new NamedExpression(SchemaPath.getSimplePath(fieldName), new FieldReference(fieldName)));
        }
        return exprs;
    }

    private void updateStats() {
        this.stats.setLongStat(Metric.INPUT_BATCH_COUNT, this.flattenMemoryManager.getNumIncomingBatches());
        this.stats.setLongStat(Metric.AVG_INPUT_BATCH_BYTES, this.flattenMemoryManager.getAvgInputBatchSize());
        this.stats.setLongStat(Metric.AVG_INPUT_ROW_BYTES, this.flattenMemoryManager.getAvgInputRowWidth());
        this.stats.setLongStat(Metric.INPUT_RECORD_COUNT, this.flattenMemoryManager.getTotalInputRecords());
        this.stats.setLongStat(Metric.OUTPUT_BATCH_COUNT, this.flattenMemoryManager.getNumOutgoingBatches());
        this.stats.setLongStat(Metric.AVG_OUTPUT_BATCH_BYTES, this.flattenMemoryManager.getAvgOutputBatchSize());
        this.stats.setLongStat(Metric.AVG_OUTPUT_ROW_BYTES, this.flattenMemoryManager.getAvgOutputRowWidth());
        this.stats.setLongStat(Metric.OUTPUT_RECORD_COUNT, this.flattenMemoryManager.getTotalOutputRecords());
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "incoming aggregate: count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.flattenMemoryManager.getNumIncomingBatches(), this.flattenMemoryManager.getAvgInputBatchSize(), this.flattenMemoryManager.getAvgInputRowWidth(), this.flattenMemoryManager.getTotalInputRecords());
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "outgoing aggregate: count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.flattenMemoryManager.getNumOutgoingBatches(), this.flattenMemoryManager.getAvgOutputBatchSize(), this.flattenMemoryManager.getAvgOutputRowWidth(), this.flattenMemoryManager.getTotalOutputRecords());
    }

    @Override
    public void close() {
        this.updateStats();
        super.close();
    }

    @Override
    public void dump() {
        logger.error("FlattenRecordbatch[hasRemainder={}, remainderIndex={}, recordCount={}, flattener={}, container={}]", new Object[]{this.hasRemainder, this.remainderIndex, this.recordCount, this.flattener, this.container});
    }

    private class FlattenMemoryManager
    extends RecordBatchMemoryManager {
        FlattenMemoryManager(int outputBatchSize) {
            super(outputBatchSize);
        }

        @Override
        public void update() {
            this.setRecordBatchSizer(new RecordBatchSizer(FlattenRecordBatch.this.incoming));
            TypedFieldId typedFieldId = FlattenRecordBatch.this.incoming.getValueVectorId(((FlattenPOP)FlattenRecordBatch.this.popConfig).getColumn());
            MaterializedField field = FlattenRecordBatch.this.incoming.getSchema().getColumn(typedFieldId.getFieldIds()[0]);
            RecordBatchSizer.ColumnSize columnSize = this.getRecordBatchSizer().getColumn(field.getName());
            int avgRowWidthFlattenColumn = columnSize.getNetSizePerEntry();
            int avgRowWidthWithOutFlattenColumn = this.getRecordBatchSizer().getNetRowWidth() - avgRowWidthFlattenColumn;
            int avgRowWidthSingleFlattenEntry = RecordBatchSizer.safeDivide(columnSize.getTotalNetSize() - this.getOffsetVectorWidth() * columnSize.getValueCount(), columnSize.getElementCount());
            int avgOutgoingRowWidth = avgRowWidthWithOutFlattenColumn + avgRowWidthSingleFlattenEntry;
            int outputBatchSize = this.getOutputBatchSize();
            this.setOutputRowCount(outputBatchSize, avgOutgoingRowWidth);
            this.setOutgoingRowWidth(avgOutgoingRowWidth);
            this.setOutputRowCount(Math.min(columnSize.getElementCount(), this.getOutputRowCount()));
            RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.INPUT, this.getRecordBatchSizer(), FlattenRecordBatch.this.getRecordBatchStatsContext());
            this.updateIncomingStats();
        }
    }

    private class ClassifierResult {
        public List<String> outputNames;

        private ClassifierResult() {
        }

        private void clear() {
            if (this.outputNames != null) {
                this.outputNames.clear();
            }
        }
    }

    public static enum Metric implements MetricDef
    {
        INPUT_BATCH_COUNT,
        AVG_INPUT_BATCH_BYTES,
        AVG_INPUT_ROW_BYTES,
        INPUT_RECORD_COUNT,
        OUTPUT_BATCH_COUNT,
        AVG_OUTPUT_BATCH_BYTES,
        AVG_OUTPUT_ROW_BYTES,
        OUTPUT_RECORD_COUNT;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

