/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.filter;

import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.filter.Filterer;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.selection.SelectionVector4;

public abstract class FilterTemplate4
implements Filterer {
    private SelectionVector4 outgoingSelectionVector;
    private SelectionVector4 incomingSelectionVector;
    private TransferPair[] transfers;

    @Override
    public void setup(FragmentContext context, RecordBatch incoming, RecordBatch outgoing, TransferPair[] transfers) throws SchemaChangeException {
        this.transfers = transfers;
        this.outgoingSelectionVector = outgoing.getSelectionVector4();
        this.incomingSelectionVector = incoming.getSelectionVector4();
        this.doSetup(context, incoming, outgoing);
    }

    @Override
    public void filterBatch(int recordCount) {
        if (recordCount == 0) {
            return;
        }
        int outPos = 0;
        for (int i = 0; i < this.incomingSelectionVector.getCount(); ++i) {
            int index = this.incomingSelectionVector.get(i);
            if (!this.doEval(index, 0)) continue;
            this.outgoingSelectionVector.set(outPos++, index);
        }
        this.outgoingSelectionVector.setCount(outPos);
        this.doTransfers();
    }

    private void doTransfers() {
        for (TransferPair t : this.transfers) {
            t.transfer();
        }
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") RecordBatch var2, @Named(value="outgoing") RecordBatch var3);

    public abstract boolean doEval(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2);

    public String toString() {
        return "FilterTemplate4[outgoingSelectionVector=" + this.outgoingSelectionVector + ", incomingSelectionVector=" + this.incomingSelectionVector + "]";
    }
}

