/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.filter;

import javax.inject.Named;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.filter.Filterer;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.selection.SelectionVector2;

public abstract class FilterTemplate2
implements Filterer {
    private SelectionVector2 outgoingSelectionVector;
    private SelectionVector2 incomingSelectionVector;
    private BatchSchema.SelectionVectorMode svMode;
    private TransferPair[] transfers;
    private RecordBatch outgoing;

    @Override
    public void setup(FragmentContext context, RecordBatch incoming, RecordBatch outgoing, TransferPair[] transfers) throws SchemaChangeException {
        this.transfers = transfers;
        this.outgoingSelectionVector = outgoing.getSelectionVector2();
        this.svMode = incoming.getSchema().getSelectionVectorMode();
        this.outgoing = outgoing;
        switch (this.svMode) {
            case NONE: {
                break;
            }
            case TWO_BYTE: {
                this.incomingSelectionVector = incoming.getSelectionVector2();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.doSetup(context, incoming, outgoing);
    }

    private void doTransfers() {
        for (TransferPair t : this.transfers) {
            t.transfer();
        }
    }

    @Override
    public void filterBatch(int recordCount) throws SchemaChangeException {
        if (recordCount == 0) {
            this.outgoingSelectionVector.setRecordCount(0);
            this.outgoingSelectionVector.setBatchActualRecordCount(0);
            this.outgoing.getContainer().setEmpty();
            return;
        }
        if (!this.outgoingSelectionVector.allocateNewSafe(recordCount)) {
            throw new OutOfMemoryException("Unable to allocate filter batch");
        }
        switch (this.svMode) {
            case NONE: {
                this.outgoingSelectionVector.setBatchActualRecordCount(recordCount);
                this.filterBatchNoSV(recordCount);
                this.doTransfers();
                this.outgoing.getContainer().setRecordCount(recordCount);
                break;
            }
            case TWO_BYTE: {
                int actualRowCount = this.incomingSelectionVector.getBatchActualRecordCount();
                this.outgoingSelectionVector.setBatchActualRecordCount(actualRowCount);
                this.filterBatchSV2(recordCount);
                this.doTransfers();
                this.outgoing.getContainer().setRecordCount(actualRowCount);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void filterBatchSV2(int recordCount) throws SchemaChangeException {
        int svIndex = 0;
        for (int i = 0; i < recordCount; ++i) {
            char index = this.incomingSelectionVector.getIndex(i);
            if (!this.doEval(index, 0)) continue;
            this.outgoingSelectionVector.setIndex(svIndex, (int)index);
            ++svIndex;
        }
        this.outgoingSelectionVector.setRecordCount(svIndex);
    }

    private void filterBatchNoSV(int recordCount) throws SchemaChangeException {
        int svIndex = 0;
        for (int i = 0; i < recordCount; ++i) {
            if (!this.doEval(i, 0)) continue;
            this.outgoingSelectionVector.setIndex(svIndex, (char)i);
            ++svIndex;
        }
        this.outgoingSelectionVector.setRecordCount(svIndex);
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") RecordBatch var2, @Named(value="outgoing") RecordBatch var3) throws SchemaChangeException;

    public abstract boolean doEval(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;

    public String toString() {
        return "FilterTemplate2[outgoingSelectionVector=" + this.outgoingSelectionVector + ", incomingSelectionVector=" + this.incomingSelectionVector + ", svMode=" + (Object)((Object)this.svMode) + "]";
    }
}

