/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.impl.common.SpilledPartitionMetadata;
import org.apache.drill.exec.physical.impl.join.AbstractHashBinaryRecordBatch;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpilledState<T extends SpilledPartitionMetadata> {
    public static final Logger logger = LoggerFactory.getLogger(SpilledState.class);
    private int numPartitions;
    private int partitionMask;
    private int bitsInMask;
    private int cycle = 0;
    private Queue<T> queue = new LinkedList<T>();
    private boolean initialized = false;

    public void initialize(int numPartitions) {
        Preconditions.checkState(!this.initialized);
        Preconditions.checkArgument(numPartitions >= 1);
        Preconditions.checkArgument((numPartitions & numPartitions - 1) == 0);
        this.numPartitions = numPartitions;
        this.initialized = true;
        this.partitionMask = numPartitions - 1;
        this.bitsInMask = Integer.bitCount(this.partitionMask);
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public boolean isFirstCycle() {
        return this.cycle == 0;
    }

    public int getPartitionMask() {
        return this.partitionMask;
    }

    public int getBitsInMask() {
        return this.bitsInMask;
    }

    public boolean addPartition(T spilledPartition) {
        Preconditions.checkState(this.initialized);
        return this.queue.offer(spilledPartition);
    }

    public T getNextSpilledPartition() {
        Preconditions.checkState(this.initialized);
        return (T)((SpilledPartitionMetadata)this.queue.poll());
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void updateCycle(OperatorStats operatorStats, T spilledPartition, Updater updater) {
        Preconditions.checkState(this.initialized);
        Preconditions.checkNotNull(operatorStats);
        Preconditions.checkNotNull(spilledPartition);
        Preconditions.checkNotNull(updater);
        if (logger.isDebugEnabled()) {
            logger.debug(spilledPartition.makeDebugString());
        }
        if (this.cycle == spilledPartition.getCycle()) {
            this.cycle = 1 + spilledPartition.getCycle();
            operatorStats.setLongStat(AbstractHashBinaryRecordBatch.Metric.SPILL_CYCLE, this.cycle);
            if (logger.isDebugEnabled()) {
                if (this.cycle == 1) {
                    logger.debug("Started reading spilled records ");
                } else if (this.cycle == 2) {
                    logger.debug("SECONDARY SPILLING ");
                } else if (this.cycle == 3) {
                    logger.debug("TERTIARY SPILLING ");
                } else if (this.cycle == 4) {
                    logger.debug("QUATERNARY SPILLING ");
                } else if (this.cycle == 5) {
                    logger.debug("QUINARY SPILLING ");
                }
            }
            if (updater.hasPartitionLimit() && this.cycle * this.bitsInMask > 20) {
                this.queue.offer(spilledPartition);
                updater.cleanup();
                throw UserException.unsupportedError().message("%s.\n On cycle num %d mem available %d num partitions %d.", updater.getFailureMessage(), this.cycle, updater.getMemLimit(), this.numPartitions).build(logger);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(spilledPartition.makeDebugString());
        }
    }

    public int getCycle() {
        return this.cycle;
    }

    public static interface Updater {
        public void cleanup();

        public String getFailureMessage();

        public long getMemLimit();

        public boolean hasPartitionLimit();
    }
}

