/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.exceptions.RetryAfterSpillException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.sig.RuntimeOverridden;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.AllocationManager;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.common.CodeGenMemberInjector;
import org.apache.drill.exec.physical.impl.common.HashTable;
import org.apache.drill.exec.physical.impl.common.HashTableAllocationTracker;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.physical.impl.common.HashTableStats;
import org.apache.drill.exec.physical.impl.common.IndexPointer;
import org.apache.drill.exec.physical.impl.join.HashJoinMemoryCalculator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HashTableTemplate
implements HashTable {
    public static final int MAX_VARCHAR_SIZE = 8;
    private static final Logger logger = LoggerFactory.getLogger(HashTableTemplate.class);
    private static final boolean EXTRA_DEBUG = false;
    private static final int EMPTY_SLOT = -1;
    private IntVector startIndices;
    private ArrayList<BatchHolder> batchHolders;
    private int totalIndexSize;
    private int prevIndexSize;
    private int currentIndexSize;
    private int tableSize = 0;
    private int originalTableSize;
    private int threshold;
    private int numEntries = 0;
    private int freeIndex = 0;
    private BufferAllocator allocator;
    private VectorContainer incomingBuild;
    private RecordBatch incomingProbe;
    private RecordBatch outgoing;
    private HashTableConfig htConfig;
    private HashTableAllocationTracker allocationTracker;
    private VectorContainer htContainerOrig;
    private MaterializedField dummyIntField;
    protected FragmentContext context;
    protected ClassGenerator<?> cg;
    private int numResizing = 0;
    private int resizingTime = 0;
    private Iterator<BatchHolder> htIter = null;

    @Override
    public void setup(HashTableConfig htConfig, BufferAllocator allocator, VectorContainer incomingBuild, RecordBatch incomingProbe, RecordBatch outgoing, VectorContainer htContainerOrig, FragmentContext context, ClassGenerator<?> cg) {
        float loadf = htConfig.getLoadFactor();
        int initialCap = htConfig.getInitialCapacity();
        if (loadf <= 0.0f || Float.isNaN(loadf)) {
            throw new IllegalArgumentException("Load factor must be a valid number greater than 0");
        }
        if (initialCap <= 0) {
            throw new IllegalArgumentException("The initial capacity must be greater than 0");
        }
        if (initialCap > 0x40000000) {
            throw new IllegalArgumentException("The initial capacity must be less than maximum capacity allowed");
        }
        if (htConfig.getKeyExprsBuild() == null || htConfig.getKeyExprsBuild().size() == 0) {
            throw new IllegalArgumentException("Hash table must have at least 1 key expression");
        }
        this.htConfig = htConfig;
        this.allocator = allocator;
        this.incomingBuild = incomingBuild;
        this.incomingProbe = incomingProbe;
        this.outgoing = outgoing;
        this.htContainerOrig = htContainerOrig;
        this.context = context;
        this.cg = cg;
        this.allocationTracker = new HashTableAllocationTracker(htConfig);
        this.tableSize = HashTableTemplate.roundUpToPowerOf2(initialCap);
        if (this.tableSize > 0x40000000) {
            this.tableSize = 0x40000000;
        }
        this.originalTableSize = this.tableSize;
        this.threshold = (int)Math.ceil((float)this.tableSize * loadf);
        this.dummyIntField = MaterializedField.create("dummy", Types.required(TypeProtos.MinorType.INT));
        this.startIndices = this.allocMetadataVector(this.tableSize, -1);
        this.batchHolders = new ArrayList();
        this.prevIndexSize = 0;
        this.currentIndexSize = 0;
        this.totalIndexSize = 0;
        try {
            this.doSetup(incomingBuild, incomingProbe);
        }
        catch (SchemaChangeException e) {
            throw new IllegalStateException("Unexpected schema change", e);
        }
    }

    @Override
    public void updateInitialCapacity(int initialCapacity) {
        this.htConfig = this.htConfig.withInitialCapacity(initialCapacity);
        this.allocationTracker = new HashTableAllocationTracker(this.htConfig);
        this.enlargeEmptyHashTableIfNeeded(initialCapacity);
    }

    @Override
    public void updateBatches() throws SchemaChangeException {
        this.doSetup(this.incomingBuild, this.incomingProbe);
        for (BatchHolder batchHolder : this.batchHolders) {
            batchHolder.setup();
        }
    }

    public int numBuckets() {
        return this.startIndices.getAccessor().getValueCount();
    }

    public int numResizing() {
        return this.numResizing;
    }

    @Override
    public int size() {
        return this.numEntries;
    }

    @Override
    public void getStats(HashTableStats stats) {
        assert (stats != null);
        stats.numBuckets = this.numBuckets();
        stats.numEntries = this.numEntries;
        stats.numResizing = this.numResizing;
        stats.resizingTime = this.resizingTime;
    }

    @Override
    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    private void clear(boolean close) {
        if (close) {
            this.htContainerOrig.clear();
        }
        if (this.batchHolders != null) {
            for (BatchHolder bh : this.batchHolders) {
                bh.clear();
            }
            this.batchHolders.clear();
            this.batchHolders = null;
            this.prevIndexSize = 0;
            this.currentIndexSize = 0;
            this.totalIndexSize = 0;
        }
        this.startIndices.clear();
        this.numEntries = 0;
    }

    private int getBucketIndex(int hash, int numBuckets) {
        return hash & numBuckets - 1;
    }

    private static int roundUpToPowerOf2(int number) {
        int rounded;
        rounded = number >= 0x40000000 ? 0x40000000 : ((rounded = Integer.highestOneBit(number)) != 0 ? (Integer.bitCount(number) > 1 ? rounded << 1 : rounded) : 1);
        return rounded;
    }

    private void retryAfterOOM(boolean batchAdded) throws RetryAfterSpillException {
        if (batchAdded) {
            logger.trace("OOM - Removing index {} from the batch holders list", (Object)(this.batchHolders.size() - 1));
            BatchHolder bh = this.batchHolders.remove(this.batchHolders.size() - 1);
            this.prevIndexSize = this.batchHolders.size() > 1 ? (this.batchHolders.size() - 1) * 65536 : 0;
            this.currentIndexSize = this.prevIndexSize + (this.batchHolders.size() > 0 ? this.batchHolders.get(this.batchHolders.size() - 1).getTargetBatchRowCount() : 0);
            this.totalIndexSize = this.batchHolders.size() * 65536;
            this.freeIndex = this.totalIndexSize + 1;
            bh.clear();
        } else {
            --this.freeIndex;
        }
        throw new RetryAfterSpillException();
    }

    @Override
    public int getBuildHashCode(int incomingRowIdx) throws SchemaChangeException {
        return this.getHashBuild(incomingRowIdx, 0);
    }

    @Override
    public int getProbeHashCode(int incomingRowIdx) throws SchemaChangeException {
        return this.getHashProbe(incomingRowIdx, 0);
    }

    @Override
    public HashTable.PutStatus put(int incomingRowIdx, IndexPointer htIdxHolder, int hashCode, int targetBatchRowCount) throws SchemaChangeException, RetryAfterSpillException {
        int bucketIndex = this.getBucketIndex(hashCode, this.numBuckets());
        int startIdx = this.startIndices.getAccessor().get(bucketIndex);
        BatchHolder lastEntryBatch = null;
        int lastEntryIdxWithinBatch = -1;
        int currentIndex = startIdx;
        while (currentIndex != -1) {
            lastEntryBatch = this.batchHolders.get(currentIndex >>> 16 & 0xFFFF);
            lastEntryIdxWithinBatch = currentIndex & 0xFFFF;
            if (lastEntryBatch.isKeyMatch(incomingRowIdx, currentIndex, false)) {
                htIdxHolder.value = currentIndex;
                lastEntryBatch.increaseRecordNumForKey(lastEntryIdxWithinBatch);
                return HashTable.PutStatus.KEY_PRESENT;
            }
            currentIndex = lastEntryBatch.nextLinkInHashChain(currentIndex);
        }
        int currentIdx = this.freeIndex++;
        boolean addedBatch = false;
        try {
            addedBatch = this.addBatchIfNeeded(currentIdx, targetBatchRowCount);
            if (addedBatch) {
                currentIdx = (this.batchHolders.size() - 1) * 65536;
                this.freeIndex = currentIdx + 1;
            }
        }
        catch (OutOfMemoryException OOME) {
            this.retryAfterOOM(currentIdx < this.totalIndexSize);
        }
        try {
            BatchHolder bh = this.batchHolders.get(currentIdx >>> 16 & 0xFFFF);
            bh.insertEntry(incomingRowIdx, currentIdx, hashCode, lastEntryBatch, lastEntryIdxWithinBatch);
            ++this.numEntries;
        }
        catch (OutOfMemoryException OOME) {
            this.retryAfterOOM(addedBatch);
        }
        try {
            this.resizeAndRehashIfNeeded();
        }
        catch (OutOfMemoryException OOME) {
            --this.numEntries;
            if (lastEntryBatch != null) {
                lastEntryBatch.updateLinks(lastEntryIdxWithinBatch, -1);
            }
            this.retryAfterOOM(addedBatch);
        }
        if (startIdx == -1) {
            this.startIndices.getMutator().set(this.getBucketIndex(hashCode, this.numBuckets()), currentIdx);
        }
        htIdxHolder.value = currentIdx;
        return addedBatch ? HashTable.PutStatus.NEW_BATCH_ADDED : (this.freeIndex + 1 > this.currentIndexSize ? HashTable.PutStatus.KEY_ADDED_LAST : HashTable.PutStatus.KEY_ADDED);
    }

    @Override
    public int probeForKey(int incomingRowIdx, int hashCode) throws SchemaChangeException {
        int bucketIndex = this.getBucketIndex(hashCode, this.numBuckets());
        int startIdx = this.startIndices.getAccessor().get(bucketIndex);
        BatchHolder lastEntryBatch = null;
        int currentIndex = startIdx;
        while (currentIndex != -1) {
            lastEntryBatch = this.batchHolders.get(currentIndex >>> 16 & 0xFFFF);
            if (lastEntryBatch.isKeyMatch(incomingRowIdx, currentIndex, true)) {
                return currentIndex;
            }
            currentIndex = lastEntryBatch.nextLinkInHashChain(currentIndex);
        }
        return -1;
    }

    @Override
    public int getRecordNumForKey(int currentIndex) {
        BatchHolder bh = this.batchHolders.get(currentIndex >>> 16 & 0xFFFF);
        return bh.getRecordNumForKey(currentIndex & 0xFFFF);
    }

    @Override
    public void setRecordNumForKey(int currentIndex, int num) {
        BatchHolder bh = this.batchHolders.get(currentIndex >>> 16 & 0xFFFF);
        bh.setNum(currentIndex & 0xFFFF, num);
    }

    @Override
    public void decreaseRecordNumForKey(int currentIndex) {
        BatchHolder bh = this.batchHolders.get(currentIndex >>> 16 & 0xFFFF);
        bh.decreaseRecordNumForKey(currentIndex & 0xFFFF);
    }

    private boolean addBatchIfNeeded(int currentIdx, int batchRowCount) throws SchemaChangeException {
        if (this.batchHolders.size() == 0 || currentIdx >= this.currentIndexSize) {
            int allocationSize = this.allocationTracker.getNextBatchHolderSize(batchRowCount);
            BatchHolder bh = this.newBatchHolder(this.batchHolders.size(), allocationSize);
            this.batchHolders.add(bh);
            this.prevIndexSize = this.batchHolders.size() > 1 ? (this.batchHolders.size() - 1) * 65536 : 0;
            this.currentIndexSize = this.prevIndexSize + this.batchHolders.get(this.batchHolders.size() - 1).getTargetBatchRowCount();
            this.totalIndexSize = this.batchHolders.size() * 65536;
            bh.setup();
            this.allocationTracker.commit(allocationSize);
            return true;
        }
        return false;
    }

    protected BatchHolder newBatchHolder(int index, int newBatchHolderSize) {
        return this.injectMembers(new BatchHolder(index, newBatchHolderSize));
    }

    protected BatchHolder injectMembers(BatchHolder batchHolder) {
        CodeGenMemberInjector.injectMembers(this.cg, batchHolder, this.context);
        return batchHolder;
    }

    private void resizeAndRehashIfNeeded() {
        if (this.numEntries < this.threshold) {
            return;
        }
        if (this.tableSize == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int newTableSize = 2 * this.tableSize;
        if ((long)(4 * ((newTableSize = HashTableTemplate.roundUpToPowerOf2(newTableSize)) + 131072)) >= this.allocator.getLimit() - this.allocator.getAllocatedMemory()) {
            throw new OutOfMemoryException("Resize Hash Table");
        }
        this.tableSize = newTableSize;
        if (this.tableSize > 0x40000000) {
            this.tableSize = 0x40000000;
        }
        long t0 = System.currentTimeMillis();
        this.threshold = (int)Math.ceil((float)this.tableSize * this.htConfig.getLoadFactor());
        IntVector newStartIndices = this.allocMetadataVector(this.tableSize, -1);
        for (int i = 0; i < this.batchHolders.size(); ++i) {
            BatchHolder bh = this.batchHolders.get(i);
            int batchStartIdx = i * 65536;
            bh.rehash(this.tableSize, newStartIndices, batchStartIdx);
        }
        this.startIndices.clear();
        this.startIndices = newStartIndices;
        this.resizingTime += Math.toIntExact(System.currentTimeMillis() - t0);
        ++this.numResizing;
    }

    public void enlargeEmptyHashTableIfNeeded(int newNum) {
        assert (this.numEntries == 0);
        if (newNum < this.threshold) {
            return;
        }
        while (this.tableSize * 2 < 0x40000000 && newNum > this.threshold) {
            this.tableSize *= 2;
            this.threshold = (int)Math.ceil((float)this.tableSize * this.htConfig.getLoadFactor());
        }
        this.startIndices.clear();
        this.startIndices = this.allocMetadataVector(this.tableSize, -1);
    }

    @Override
    public void reset() {
        this.clear(false);
        this.freeIndex = 0;
        this.batchHolders = new ArrayList();
        this.prevIndexSize = 0;
        this.currentIndexSize = 0;
        this.totalIndexSize = 0;
        this.startIndices = this.allocMetadataVector(this.originalTableSize, -1);
    }

    @Override
    public void updateIncoming(VectorContainer newIncoming, RecordBatch newIncomingProbe) {
        this.incomingBuild = newIncoming;
        this.incomingProbe = newIncomingProbe;
        try {
            this.updateBatches();
        }
        catch (SchemaChangeException e) {
            throw new IllegalStateException("Unexpected schema change", e);
        }
    }

    @Override
    public boolean outputKeys(int batchIdx, VectorContainer outContainer, int numRecords) {
        assert (batchIdx < this.batchHolders.size());
        return this.batchHolders.get(batchIdx).outputKeys(outContainer, numRecords);
    }

    private IntVector allocMetadataVector(int size, int initialValue) {
        IntVector vector = (IntVector)TypeHelper.getNewVector(this.dummyIntField, this.allocator);
        vector.allocateNew(size);
        for (int i = 0; i < size; ++i) {
            vector.getMutator().set(i, initialValue);
        }
        vector.getMutator().setValueCount(size);
        return vector;
    }

    @Override
    public Pair<VectorContainer, Integer> nextBatch() {
        BatchHolder bh;
        if (this.batchHolders == null || this.batchHolders.size() == 0) {
            return null;
        }
        if (this.htIter == null) {
            this.htIter = this.batchHolders.iterator();
        }
        if (this.htIter.hasNext() && (bh = this.htIter.next()) != null) {
            bh.setValueCount();
            return Pair.of((Object)bh.htContainer, (Object)bh.maxOccupiedIdx);
        }
        return null;
    }

    protected abstract void doSetup(@Named(value="incomingBuild") VectorContainer var1, @Named(value="incomingProbe") RecordBatch var2) throws SchemaChangeException;

    protected abstract int getHashBuild(@Named(value="incomingRowIdx") int var1, @Named(value="seedValue") int var2) throws SchemaChangeException;

    protected abstract int getHashProbe(@Named(value="incomingRowIdx") int var1, @Named(value="seedValue") int var2) throws SchemaChangeException;

    @Override
    public long getActualSize() {
        HashSet<AllocationManager.BufferLedger> ledgers = Sets.newHashSet();
        this.startIndices.collectLedgers(ledgers);
        long size = 0L;
        for (AllocationManager.BufferLedger ledger : ledgers) {
            size += (long)ledger.getAccountedSize();
        }
        for (BatchHolder batchHolder : this.batchHolders) {
            size += batchHolder.getActualSize();
        }
        return size;
    }

    @Override
    public String makeDebugString() {
        return String.format("[numBuckets = %d, numEntries = %d, numBatchHolders = %d, actualSize = %s]", this.numBuckets(), this.numEntries, this.batchHolders.size(), HashJoinMemoryCalculator.PartitionStatSet.prettyPrintBytes(this.getActualSize()));
    }

    @Override
    public void setTargetBatchRowCount(int batchRowCount) {
        this.batchHolders.get(this.batchHolders.size() - 1).targetBatchRowCount = batchRowCount;
    }

    @Override
    public int getTargetBatchRowCount() {
        return this.batchHolders.get(this.batchHolders.size() - 1).targetBatchRowCount;
    }

    public class BatchHolder {
        private VectorContainer htContainer;
        private IntVector links;
        private IntVector nums = null;
        private IntVector hashValues;
        private int maxOccupiedIdx = -1;
        private int targetBatchRowCount;
        private int batchIndex = 0;

        public void setTargetBatchRowCount(int targetBatchRowCount) {
            this.targetBatchRowCount = targetBatchRowCount;
        }

        public int getTargetBatchRowCount() {
            return this.targetBatchRowCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BatchHolder(int idx, int newBatchHolderSize) {
            this.batchIndex = idx;
            this.targetBatchRowCount = newBatchHolderSize;
            this.htContainer = new VectorContainer();
            boolean success = false;
            try {
                for (VectorWrapper<?> w : HashTableTemplate.this.htContainerOrig) {
                    ValueVector vv = TypeHelper.getNewVector(w.getField(), HashTableTemplate.this.allocator);
                    this.htContainer.add(vv);
                    if (vv instanceof FixedWidthVector) {
                        ((FixedWidthVector)vv).allocateNew(newBatchHolderSize);
                        continue;
                    }
                    if (vv instanceof VariableWidthVector) {
                        long beforeMem = HashTableTemplate.this.allocator.getAllocatedMemory();
                        ((VariableWidthVector)vv).allocateNew(8 * newBatchHolderSize, newBatchHolderSize);
                        logger.trace("HT allocated {} for varchar of max width {}", (Object)(HashTableTemplate.this.allocator.getAllocatedMemory() - beforeMem), (Object)8);
                        continue;
                    }
                    vv.allocateNew();
                }
                this.links = HashTableTemplate.this.allocMetadataVector(newBatchHolderSize, -1);
                this.hashValues = HashTableTemplate.this.allocMetadataVector(newBatchHolderSize, 0);
                if (HashTableTemplate.this.htConfig.isComputeKeyNum()) {
                    this.nums = HashTableTemplate.this.allocMetadataVector(newBatchHolderSize, 0);
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.htContainer.clear();
                    if (this.links != null) {
                        this.links.clear();
                    }
                    if (this.nums != null) {
                        this.nums.clear();
                    }
                }
            }
        }

        private void init(IntVector links, IntVector hashValues, int size) {
            int i;
            for (i = 0; i < size; ++i) {
                links.getMutator().set(i, -1);
            }
            for (i = 0; i < size; ++i) {
                hashValues.getMutator().set(i, 0);
            }
            links.getMutator().setValueCount(size);
            hashValues.getMutator().setValueCount(size);
            if (this.nums != null) {
                for (i = 0; i < size; ++i) {
                    this.nums.getMutator().set(i, 0);
                }
                this.nums.getMutator().setValueCount(size);
            }
        }

        protected void setup() throws SchemaChangeException {
            this.setupInterior(HashTableTemplate.this.incomingBuild, HashTableTemplate.this.incomingProbe, HashTableTemplate.this.outgoing, this.htContainer);
        }

        private boolean isKeyMatch(int incomingRowIdx, int currentIndex, boolean isProbe) throws SchemaChangeException {
            int currentIdxWithinBatch = currentIndex & 0xFFFF;
            if (currentIdxWithinBatch >= ((BatchHolder)HashTableTemplate.this.batchHolders.get(currentIndex >>> 16 & 0xFFFF)).getTargetBatchRowCount()) {
                logger.debug("Batch size = {}, incomingRowIdx = {}, currentIdxWithinBatch = {}.", new Object[]{((BatchHolder)HashTableTemplate.this.batchHolders.get(currentIndex >>> 16 & 0xFFFF)).getTargetBatchRowCount(), incomingRowIdx, currentIdxWithinBatch});
            }
            assert (currentIdxWithinBatch < ((BatchHolder)HashTableTemplate.this.batchHolders.get(currentIndex >>> 16 & 0xFFFF)).getTargetBatchRowCount());
            assert (incomingRowIdx < 65536);
            if (isProbe) {
                return this.isKeyMatchInternalProbe(incomingRowIdx, currentIdxWithinBatch);
            }
            if (this.areBothKeysNull(incomingRowIdx, currentIdxWithinBatch)) {
                return true;
            }
            return this.isKeyMatchInternalBuild(incomingRowIdx, currentIdxWithinBatch);
        }

        private int nextLinkInHashChain(int currentIndex) {
            return this.links.getAccessor().get(currentIndex & 0xFFFF);
        }

        private void increaseRecordNumForKey(int idxWithinBatch) {
            if (this.nums != null) {
                this.nums.getMutator().set(idxWithinBatch, this.nums.getAccessor().get(idxWithinBatch) + 1);
            }
        }

        private void decreaseRecordNumForKey(int idxWithinBatch) {
            if (this.nums != null) {
                this.nums.getMutator().set(idxWithinBatch, this.nums.getAccessor().get(idxWithinBatch) - 1);
            }
        }

        private int getRecordNumForKey(int idxWithinBatch) {
            if (this.nums != null) {
                return this.nums.getAccessor().get(idxWithinBatch);
            }
            return -1;
        }

        private void setNum(int idxWithinBatch, int num) {
            if (this.nums != null) {
                this.nums.getMutator().set(idxWithinBatch, num);
            }
        }

        private void insertEntry(int incomingRowIdx, int currentIdx, int hashValue, BatchHolder lastEntryBatch, int lastEntryIdxWithinBatch) throws SchemaChangeException {
            int currentIdxWithinBatch = currentIdx & 0xFFFF;
            this.setValue(incomingRowIdx, currentIdxWithinBatch);
            if (lastEntryBatch != null) {
                lastEntryBatch.updateLinks(lastEntryIdxWithinBatch, currentIdx);
            }
            this.links.getMutator().set(currentIdxWithinBatch, -1);
            this.hashValues.getMutator().set(currentIdxWithinBatch, hashValue);
            if (this.nums != null) {
                this.nums.getMutator().set(currentIdxWithinBatch, 1);
            }
            this.maxOccupiedIdx = Math.max(this.maxOccupiedIdx, currentIdxWithinBatch);
        }

        private void updateLinks(int lastEntryIdxWithinBatch, int currentIdx) {
            this.links.getMutator().set(lastEntryIdxWithinBatch, currentIdx);
        }

        private void rehash(int numbuckets, IntVector newStartIndices, int batchStartIdx) {
            logger.debug("Rehashing entries within the batch: {}; batchStartIdx = {}, total numBuckets in hash table = {}.", new Object[]{this.batchIndex, batchStartIdx, numbuckets});
            int size = this.links.getAccessor().getValueCount();
            IntVector newLinks = HashTableTemplate.this.allocMetadataVector(size, -1);
            IntVector newHashValues = HashTableTemplate.this.allocMetadataVector(size, 0);
            block0: for (int i = 0; i <= this.maxOccupiedIdx; ++i) {
                int entryIdxWithinBatch = i;
                int entryIdx = entryIdxWithinBatch + batchStartIdx;
                int hash = this.hashValues.getAccessor().get(entryIdxWithinBatch);
                int bucketIdx = HashTableTemplate.this.getBucketIndex(hash, numbuckets);
                int newStartIdx = newStartIndices.getAccessor().get(bucketIdx);
                if (newStartIdx == -1) {
                    newStartIndices.getMutator().set(bucketIdx, entryIdx);
                    newLinks.getMutator().set(entryIdxWithinBatch, -1);
                    newHashValues.getMutator().set(entryIdxWithinBatch, hash);
                    continue;
                }
                int idx = newStartIdx;
                int idxWithinBatch = 0;
                BatchHolder bh = this;
                while (true) {
                    if (idx != -1) {
                        idxWithinBatch = idx & 0xFFFF;
                        bh = (BatchHolder)HashTableTemplate.this.batchHolders.get(idx >>> 16 & 0xFFFF);
                    }
                    if (bh == this && newLinks.getAccessor().get(idxWithinBatch) == -1) {
                        newLinks.getMutator().set(idxWithinBatch, entryIdx);
                        newLinks.getMutator().set(entryIdxWithinBatch, -1);
                        newHashValues.getMutator().set(entryIdxWithinBatch, hash);
                        continue block0;
                    }
                    if (bh != this && bh.links.getAccessor().get(idxWithinBatch) == -1) {
                        bh.links.getMutator().set(idxWithinBatch, entryIdx);
                        newLinks.getMutator().set(entryIdxWithinBatch, -1);
                        newHashValues.getMutator().set(entryIdxWithinBatch, hash);
                        continue block0;
                    }
                    if (bh == this) {
                        idx = newLinks.getAccessor().get(idxWithinBatch);
                        continue;
                    }
                    idx = bh.links.getAccessor().get(idxWithinBatch);
                }
            }
            this.links.clear();
            this.hashValues.clear();
            this.links = newLinks;
            this.hashValues = newHashValues;
        }

        private boolean outputKeys(VectorContainer outContainer, int numRecords) {
            this.setValueCount();
            Iterator<VectorWrapper<?>> outgoingIter = outContainer.iterator();
            for (VectorWrapper<?> sourceWrapper : this.htContainer) {
                Object sourceVV = sourceWrapper.getValueVector();
                Object targetVV = outgoingIter.next().getValueVector();
                TransferPair tp = sourceVV.makeTransferPair((ValueVector)targetVV);
                tp.transfer();
            }
            return true;
        }

        private void setValueCount() {
            for (VectorWrapper<?> vw : this.htContainer) {
                Object vv = vw.getValueVector();
                vv.getMutator().setValueCount(this.maxOccupiedIdx + 1);
            }
            this.htContainer.setRecordCount(this.maxOccupiedIdx + 1);
        }

        private void dump(int idx) {
            int idxWithinBatch;
            while ((idxWithinBatch = idx & 0xFFFF) != -1) {
                logger.debug("links[ {} ] = {}, hashValues[ {} ] = {}.", new Object[]{idxWithinBatch, this.links.getAccessor().get(idxWithinBatch), idxWithinBatch, this.hashValues.getAccessor().get(idxWithinBatch)});
                idx = this.links.getAccessor().get(idxWithinBatch);
            }
        }

        private void clear() {
            this.htContainer.clear();
            if (this.links != null) {
                this.links.clear();
            }
            if (this.hashValues != null) {
                this.hashValues.clear();
            }
            if (this.nums != null) {
                this.nums.clear();
            }
        }

        private ValueVector getValueVector(int index) {
            Object tmp = this.htContainer.getValueAccessorById(BigIntVector.class, index).getValueVector();
            if (tmp != null) {
                BigIntVector vv0 = (BigIntVector)tmp;
                return vv0;
            }
            return null;
        }

        @RuntimeOverridden
        protected void setupInterior(@Named(value="incomingBuild") VectorContainer incomingBuild, @Named(value="incomingProbe") RecordBatch incomingProbe, @Named(value="outgoing") RecordBatch outgoing, @Named(value="htContainer") VectorContainer htContainer) throws SchemaChangeException {
        }

        @RuntimeOverridden
        protected boolean isKeyMatchInternalBuild(@Named(value="incomingRowIdx") int incomingRowIdx, @Named(value="htRowIdx") int htRowIdx) throws SchemaChangeException {
            return false;
        }

        @RuntimeOverridden
        protected boolean areBothKeysNull(@Named(value="incomingRowIdx") int incomingRowIdx, @Named(value="htRowIdx") int htRowIdx) throws SchemaChangeException {
            return false;
        }

        @RuntimeOverridden
        protected boolean isKeyMatchInternalProbe(@Named(value="incomingRowIdx") int incomingRowIdx, @Named(value="htRowIdx") int htRowIdx) throws SchemaChangeException {
            return false;
        }

        @RuntimeOverridden
        protected void setValue(@Named(value="incomingRowIdx") int incomingRowIdx, @Named(value="htRowIdx") int htRowIdx) throws SchemaChangeException {
        }

        @RuntimeOverridden
        protected void outputRecordKeys(@Named(value="htRowIdx") int htRowIdx, @Named(value="outRowIdx") int outRowIdx) throws SchemaChangeException {
        }

        public long getActualSize() {
            HashSet<AllocationManager.BufferLedger> ledgers = Sets.newHashSet();
            this.links.collectLedgers(ledgers);
            this.hashValues.collectLedgers(ledgers);
            long size = 0L;
            for (AllocationManager.BufferLedger ledger : ledgers) {
                size += (long)ledger.getAccountedSize();
            }
            if (this.htContainer.hasRecordCount()) {
                size += new RecordBatchSizer(this.htContainer).getActualSize();
            }
            return size;
        }
    }
}

