/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.physical.impl.common.Comparator;

@JsonTypeName(value="hashtable-config")
public class HashTableConfig {
    private final int initialCapacity;
    private final boolean initialSizeIsFinal;
    private final float loadFactor;
    private final List<NamedExpression> keyExprsBuild;
    private final List<NamedExpression> keyExprsProbe;
    private final List<Comparator> comparators;
    private final int joinControl;
    private final boolean computeKeyNum;

    public HashTableConfig(int initialCapacity, float loadFactor, List<NamedExpression> keyExprsBuild, List<NamedExpression> keyExprsProbe, List<Comparator> comparators) {
        this(initialCapacity, false, loadFactor, keyExprsBuild, keyExprsProbe, comparators, 0, false);
    }

    @JsonCreator
    public HashTableConfig(@JsonProperty(value="initialCapacity") int initialCapacity, @JsonProperty(value="loadFactor") float loadFactor, @JsonProperty(value="keyExprsBuild") List<NamedExpression> keyExprsBuild, @JsonProperty(value="keyExprsProbe") List<NamedExpression> keyExprsProbe, @JsonProperty(value="comparators") List<Comparator> comparators, @JsonProperty(value="joinControl") int joinControl) {
        this(initialCapacity, false, loadFactor, keyExprsBuild, keyExprsProbe, comparators, joinControl, false);
    }

    public HashTableConfig(int initialCapacity, boolean initialSizeIsFinal, float loadFactor, List<NamedExpression> keyExprsBuild, List<NamedExpression> keyExprsProbe, List<Comparator> comparators) {
        this(initialCapacity, initialSizeIsFinal, loadFactor, keyExprsBuild, keyExprsProbe, comparators, 0, false);
    }

    @JsonCreator
    public HashTableConfig(@JsonProperty(value="initialCapacity") int initialCapacity, @JsonProperty(value="initialCapacity") boolean initialSizeIsFinal, @JsonProperty(value="loadFactor") float loadFactor, @JsonProperty(value="keyExprsBuild") List<NamedExpression> keyExprsBuild, @JsonProperty(value="keyExprsProbe") List<NamedExpression> keyExprsProbe, @JsonProperty(value="comparators") List<Comparator> comparators, @JsonProperty(value="joinControl") int joinControl, @JsonProperty(value="computeKeyNum") boolean computeKeyNum) {
        this.initialCapacity = initialCapacity;
        this.initialSizeIsFinal = initialSizeIsFinal;
        this.loadFactor = loadFactor;
        this.keyExprsBuild = keyExprsBuild;
        this.keyExprsProbe = keyExprsProbe;
        this.comparators = comparators;
        this.joinControl = joinControl;
        this.computeKeyNum = computeKeyNum;
    }

    public HashTableConfig withInitialCapacity(int initialCapacity) {
        return new HashTableConfig(initialCapacity, this.initialSizeIsFinal, this.loadFactor, this.keyExprsBuild, this.keyExprsProbe, this.comparators, 0, this.computeKeyNum);
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public boolean getInitialSizeIsFinal() {
        return this.initialSizeIsFinal;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public List<NamedExpression> getKeyExprsBuild() {
        return this.keyExprsBuild;
    }

    public List<NamedExpression> getKeyExprsProbe() {
        return this.keyExprsProbe;
    }

    public List<Comparator> getComparators() {
        return this.comparators;
    }

    public int getJoinControl() {
        return this.joinControl;
    }

    public boolean isComputeKeyNum() {
        return this.computeKeyNum;
    }
}

