/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.common.Comparator;
import org.apache.drill.exec.physical.impl.common.HashTable;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.physical.HashPrelUtil;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedHashTable {
    static final Logger logger = LoggerFactory.getLogger(ChainedHashTable.class);
    private static final GeneratorMapping KEY_MATCH_BUILD = GeneratorMapping.create("setupInterior", "isKeyMatchInternalBuild", null, null);
    private static final GeneratorMapping BOTH_KEYS_NULL = GeneratorMapping.create("setupInterior", "areBothKeysNull", null, null);
    private static final GeneratorMapping KEY_MATCH_PROBE = GeneratorMapping.create("setupInterior", "isKeyMatchInternalProbe", null, null);
    private static final GeneratorMapping GET_HASH_BUILD = GeneratorMapping.create("doSetup", "getHashBuild", null, null);
    private static final GeneratorMapping GET_HASH_PROBE = GeneratorMapping.create("doSetup", "getHashProbe", null, null);
    private static final GeneratorMapping SET_VALUE = GeneratorMapping.create("setupInterior", "setValue", null, null);
    private static final GeneratorMapping OUTPUT_KEYS = GeneratorMapping.create("setupInterior", "outputRecordKeys", null, null);
    private static final GeneratorMapping SETUP_INTERIOR_CONSTANT = GeneratorMapping.create("setupInterior", "setupInterior", null, null);
    private static final GeneratorMapping DO_SETUP_CONSTANT = GeneratorMapping.create("doSetup", "doSetup", null, null);
    private final MappingSet KeyMatchIncomingBuildMapping = new MappingSet("incomingRowIdx", null, "incomingBuild", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_BUILD);
    private final MappingSet bothKeysNullIncomingBuildMapping = new MappingSet("incomingRowIdx", null, "incomingBuild", null, SETUP_INTERIOR_CONSTANT, BOTH_KEYS_NULL);
    private final MappingSet KeyMatchIncomingProbeMapping = new MappingSet("incomingRowIdx", null, "incomingProbe", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_PROBE);
    private final MappingSet KeyMatchHtableMapping = new MappingSet("htRowIdx", null, "htContainer", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_BUILD);
    private final MappingSet bothKeysNullHtableMapping = new MappingSet("htRowIdx", null, "htContainer", null, SETUP_INTERIOR_CONSTANT, BOTH_KEYS_NULL);
    private final MappingSet KeyMatchHtableProbeMapping = new MappingSet("htRowIdx", null, "htContainer", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_PROBE);
    private final MappingSet GetHashIncomingBuildMapping = new MappingSet("incomingRowIdx", null, "incomingBuild", null, DO_SETUP_CONSTANT, GET_HASH_BUILD);
    private final MappingSet GetHashIncomingProbeMapping = new MappingSet("incomingRowIdx", null, "incomingProbe", null, DO_SETUP_CONSTANT, GET_HASH_PROBE);
    private final MappingSet SetValueMapping = new MappingSet("incomingRowIdx", "htRowIdx", "incomingBuild", "htContainer", SETUP_INTERIOR_CONSTANT, SET_VALUE);
    private final MappingSet OutputRecordKeysMapping = new MappingSet("htRowIdx", "outRowIdx", "htContainer", "outgoing", SETUP_INTERIOR_CONSTANT, OUTPUT_KEYS);
    private HashTableConfig htConfig;
    private final FragmentContext context;
    private final BufferAllocator allocator;
    private RecordBatch incomingBuild;
    private RecordBatch incomingProbe;
    private final RecordBatch outgoing;

    public ChainedHashTable(HashTableConfig htConfig, FragmentContext context, BufferAllocator allocator, RecordBatch incomingBuild, RecordBatch incomingProbe, RecordBatch outgoing) {
        this.htConfig = htConfig;
        this.context = context;
        this.allocator = allocator;
        this.incomingBuild = incomingBuild;
        this.incomingProbe = incomingProbe;
        this.outgoing = outgoing;
    }

    public void updateIncoming(RecordBatch incomingBuild, RecordBatch incomingProbe) {
        this.incomingBuild = incomingBuild;
        this.incomingProbe = incomingProbe;
    }

    public HashTable createAndSetupHashTable(TypedFieldId[] outKeyFieldIds) throws ClassTransformationException, IOException, SchemaChangeException {
        LogicalExpression expr;
        boolean isProbe;
        CodeGenerator<HashTable> top = CodeGenerator.get(HashTable.TEMPLATE_DEFINITION, this.context.getOptions());
        top.plainJavaCapable(true);
        top.preferPlainJava(true);
        ClassGenerator<HashTable> cg = top.getRoot();
        ClassGenerator<HashTable> cgInner = cg.getInnerGenerator("BatchHolder");
        LogicalExpression[] keyExprsBuild = new LogicalExpression[this.htConfig.getKeyExprsBuild().size()];
        LogicalExpression[] keyExprsProbe = null;
        boolean bl = isProbe = this.htConfig.getKeyExprsProbe() != null;
        if (isProbe) {
            keyExprsProbe = new LogicalExpression[this.htConfig.getKeyExprsProbe().size()];
        }
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        VectorContainer htContainerOrig = new VectorContainer();
        TypedFieldId[] htKeyFieldIds = new TypedFieldId[this.htConfig.getKeyExprsBuild().size()];
        int i = 0;
        for (NamedExpression ne : this.htConfig.getKeyExprsBuild()) {
            expr = ExpressionTreeMaterializer.materialize(ne.getExpr(), this.incomingBuild, collector, this.context.getFunctionRegistry());
            if (collector.hasErrors()) {
                throw new SchemaChangeException("Failure while materializing expression. " + collector.toErrorString());
            }
            if (expr == null) continue;
            keyExprsBuild[i] = expr;
            ++i;
        }
        if (isProbe) {
            i = 0;
            for (NamedExpression ne : this.htConfig.getKeyExprsProbe()) {
                expr = ExpressionTreeMaterializer.materialize(ne.getExpr(), this.incomingProbe, collector, this.context.getFunctionRegistry());
                if (collector.hasErrors()) {
                    throw new SchemaChangeException("Failure while materializing expression. " + collector.toErrorString());
                }
                if (expr == null) continue;
                keyExprsProbe[i] = expr;
                ++i;
            }
            JoinUtils.addLeastRestrictiveCasts(keyExprsProbe, this.incomingProbe, keyExprsBuild, this.incomingBuild, this.context);
        }
        i = 0;
        for (NamedExpression ne : this.htConfig.getKeyExprsBuild()) {
            expr = keyExprsBuild[i];
            MaterializedField outputField = MaterializedField.create(ne.getRef().getLastSegment().getNameSegment().getPath(), expr.getMajorType());
            ValueVector vv = TypeHelper.getNewVector(outputField, this.allocator);
            htKeyFieldIds[i] = htContainerOrig.add(vv);
            ++i;
        }
        this.setupIsKeyMatchInternal(cgInner, this.bothKeysNullIncomingBuildMapping, this.bothKeysNullHtableMapping, keyExprsBuild, this.htConfig.getComparators(), htKeyFieldIds, SetupWork.CHECK_BOTH_NULLS);
        this.setupIsKeyMatchInternal(cgInner, this.KeyMatchIncomingBuildMapping, this.KeyMatchHtableMapping, keyExprsBuild, this.htConfig.getComparators(), htKeyFieldIds, SetupWork.DO_BUILD);
        this.setupIsKeyMatchInternal(cgInner, this.KeyMatchIncomingProbeMapping, this.KeyMatchHtableProbeMapping, keyExprsProbe, this.htConfig.getComparators(), htKeyFieldIds, SetupWork.DO_PROBE);
        this.setupSetValue(cgInner, keyExprsBuild, htKeyFieldIds);
        if (this.outgoing != null && outKeyFieldIds.length > this.htConfig.getKeyExprsBuild().size()) {
            throw new IllegalArgumentException("Mismatched number of output key fields.");
        }
        this.setupOutputRecordKeys(cgInner, htKeyFieldIds, outKeyFieldIds);
        this.setupGetHash(cg, this.GetHashIncomingBuildMapping, this.incomingBuild, keyExprsBuild);
        this.setupGetHash(cg, this.GetHashIncomingProbeMapping, this.incomingProbe, keyExprsProbe);
        HashTable ht = this.context.getImplementationClass(top);
        ht.setup(this.htConfig, this.allocator, this.incomingBuild.getContainer(), this.incomingProbe, this.outgoing, htContainerOrig, this.context, cgInner);
        return ht;
    }

    private void setupIsKeyMatchInternal(ClassGenerator<HashTable> cg, MappingSet incomingMapping, MappingSet htableMapping, LogicalExpression[] keyExprs, List<Comparator> comparators, TypedFieldId[] htKeyFieldIds, SetupWork work) {
        boolean checkIfBothNulls = work == SetupWork.CHECK_BOTH_NULLS;
        JExpression midPointResult = checkIfBothNulls ? JExpr.TRUE : JExpr.FALSE;
        JExpression finalResult = checkIfBothNulls ? JExpr.FALSE : JExpr.TRUE;
        cg.setMappingSet(incomingMapping);
        if (keyExprs == null || keyExprs.length == 0 || checkIfBothNulls && !comparators.contains((Object)Comparator.EQUALS)) {
            cg.getEvalBlock()._return(JExpr.FALSE);
            return;
        }
        for (int i = 0; i < keyExprs.length; ++i) {
            JConditional jc;
            LogicalExpression expr = keyExprs[i];
            cg.setMappingSet(incomingMapping);
            ClassGenerator.HoldingContainer left = cg.addExpr(expr, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND);
            cg.setMappingSet(htableMapping);
            ValueVectorReadExpression vvrExpr = new ValueVectorReadExpression(htKeyFieldIds[i]);
            ClassGenerator.HoldingContainer right = cg.addExpr(vvrExpr, ClassGenerator.BlkCreateMode.FALSE);
            if (work != SetupWork.DO_BUILD && comparators.get(i) == Comparator.EQUALS && left.isOptional() && right.isOptional()) {
                jc = cg.getEvalBlock()._if(left.getIsSet().eq(JExpr.lit((int)0)).cand(right.getIsSet().eq(JExpr.lit((int)0))));
                jc._then()._return(midPointResult);
            }
            if (checkIfBothNulls) continue;
            LogicalExpression f = FunctionGenerationHelper.getOrderingComparatorNullsHigh(left, right, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer out = cg.addExpr(f, ClassGenerator.BlkCreateMode.FALSE);
            jc = cg.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)));
            jc._then()._return(midPointResult);
        }
        cg.getEvalBlock()._return(finalResult);
    }

    private void setupSetValue(ClassGenerator<HashTable> cg, LogicalExpression[] keyExprs, TypedFieldId[] htKeyFieldIds) {
        cg.setMappingSet(this.SetValueMapping);
        int i = 0;
        for (LogicalExpression expr : keyExprs) {
            ValueVectorWriteExpression vvwExpr = new ValueVectorWriteExpression(htKeyFieldIds[i++], expr, true);
            cg.addExpr(vvwExpr, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND);
        }
    }

    private void setupOutputRecordKeys(ClassGenerator<HashTable> cg, TypedFieldId[] htKeyFieldIds, TypedFieldId[] outKeyFieldIds) {
        cg.setMappingSet(this.OutputRecordKeysMapping);
        if (outKeyFieldIds != null) {
            for (int i = 0; i < outKeyFieldIds.length; ++i) {
                ValueVectorReadExpression vvrExpr = new ValueVectorReadExpression(htKeyFieldIds[i]);
                boolean useSetSafe = !Types.isFixedWidthType(vvrExpr.getMajorType()) || Types.isRepeated(vvrExpr.getMajorType());
                ValueVectorWriteExpression vvwExpr = new ValueVectorWriteExpression(outKeyFieldIds[i], vvrExpr, useSetSafe);
                cg.addExpr(vvwExpr, ClassGenerator.BlkCreateMode.TRUE);
            }
        }
    }

    private void setupGetHash(ClassGenerator<HashTable> cg, MappingSet incomingMapping, VectorAccessible batch, LogicalExpression[] keyExprs) throws SchemaChangeException {
        cg.setMappingSet(incomingMapping);
        if (keyExprs == null || keyExprs.length == 0) {
            cg.getEvalBlock()._return(JExpr.lit((int)0));
            return;
        }
        String seedValue = "seedValue";
        LogicalExpression seed = ValueExpressions.getParameterExpression(seedValue, Types.required(TypeProtos.MinorType.INT));
        for (LogicalExpression expr : keyExprs) {
            LogicalExpression hashExpression = HashPrelUtil.getHashExpression(expr, seed, this.incomingProbe != null);
            LogicalExpression materializedExpr = ExpressionTreeMaterializer.materializeAndCheckErrors(hashExpression, batch, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer hash = cg.addExpr(materializedExpr, ClassGenerator.BlkCreateMode.TRUE_IF_BOUND);
            cg.getEvalBlock().assign((JAssignmentTarget)JExpr.ref((String)seedValue), (JExpression)hash.getValue());
        }
        cg.getEvalBlock()._return((JExpression)JExpr.ref((String)seedValue));
    }

    private static enum SetupWork {
        DO_BUILD,
        DO_PROBE,
        CHECK_BOTH_NULLS;

    }
}

