/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.aggregate;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JVar;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.HoldingContainerExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.StreamingAggregate;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggTemplate;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggregator;
import org.apache.drill.exec.physical.impl.xsort.ExternalSortBatch;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.UntypedNullHolder;
import org.apache.drill.exec.vector.UntypedNullVector;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingAggBatch
extends AbstractRecordBatch<StreamingAggregate> {
    static final Logger logger = LoggerFactory.getLogger(StreamingAggBatch.class);
    protected StreamingAggregator aggregator;
    protected final RecordBatch incoming;
    private List<BaseWriter.ComplexWriter> complexWriters;
    private boolean done;
    private boolean first = true;
    private boolean sendEmit;
    private RecordBatch.IterOutcome lastKnownOutcome = RecordBatch.IterOutcome.OK;
    private boolean firstBatchForSchema = true;
    private boolean firstBatchForDataSet = true;
    private int recordCount;
    private BatchSchema incomingSchema;
    private boolean specialBatchSent;
    private static final int SPECIAL_BATCH_COUNT = 1;
    private int maxOutputRowCount = 65536;
    private final GeneratorMapping IS_SAME = GeneratorMapping.create("setupInterior", "isSame", null, null);
    private final MappingSet IS_SAME_I1 = new MappingSet("index1", null, this.IS_SAME, this.IS_SAME);
    private final MappingSet IS_SAME_I2 = new MappingSet("index2", null, this.IS_SAME, this.IS_SAME);
    private final GeneratorMapping IS_SAME_PREV_INTERNAL_BATCH_READ = GeneratorMapping.create("isSamePrev", "isSamePrev", null, null);
    private final GeneratorMapping IS_SAME_PREV = GeneratorMapping.create("setupInterior", "isSamePrev", null, null);
    private final MappingSet ISA_B1 = new MappingSet("b1Index", null, "b1", null, this.IS_SAME_PREV_INTERNAL_BATCH_READ, this.IS_SAME_PREV_INTERNAL_BATCH_READ);
    private final MappingSet ISA_B2 = new MappingSet("b2Index", null, "incoming", null, this.IS_SAME_PREV, this.IS_SAME_PREV);
    private final GeneratorMapping EVAL_INSIDE = GeneratorMapping.create("setupInterior", "addRecord", null, null);
    private final GeneratorMapping EVAL_OUTSIDE = GeneratorMapping.create("setupInterior", "outputRecordValues", "resetValues", "cleanup");
    private final MappingSet EVAL = new MappingSet("index", "outIndex", "incoming", "outgoing", this.EVAL_INSIDE, this.EVAL_OUTSIDE, this.EVAL_INSIDE);
    private final MappingSet RECORD_KEYS = new MappingSet(GeneratorMapping.create("setupInterior", "outputRecordKeys", null, null));
    private final GeneratorMapping PREVIOUS_KEYS_OUT = GeneratorMapping.create("setupInterior", "outputRecordKeysPrev", null, null);
    private final MappingSet RECORD_KEYS_PREV_OUT = new MappingSet("previousIndex", "outIndex", "previous", "outgoing", this.PREVIOUS_KEYS_OUT, this.PREVIOUS_KEYS_OUT);
    private final GeneratorMapping PREVIOUS_KEYS = GeneratorMapping.create("outputRecordKeysPrev", "outputRecordKeysPrev", null, null);
    private final MappingSet RECORD_KEYS_PREV = new MappingSet("previousIndex", "outIndex", "previous", null, this.PREVIOUS_KEYS, this.PREVIOUS_KEYS);

    public StreamingAggBatch(StreamingAggregate popConfig, RecordBatch incoming, FragmentContext context) throws OutOfMemoryException {
        super(popConfig, context);
        this.incoming = incoming;
        ExternalSortBatch.retainSv4OnNone(incoming);
    }

    @Override
    public int getRecordCount() {
        if (this.done || this.aggregator == null) {
            return 0;
        }
        return this.recordCount;
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.container;
    }

    @Override
    public void buildSchema() {
        RecordBatch.IterOutcome outcome = this.next(this.incoming);
        switch (outcome) {
            case NONE: {
                this.state = AbstractRecordBatch.BatchState.DONE;
                this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                return;
            }
        }
        this.incomingSchema = this.incoming.getSchema();
        this.createAggregator();
        this.container.allocateNew();
        if (this.complexWriters != null) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
        this.container.setEmpty();
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        block33: {
            block32: {
                if (this.done || this.specialBatchSent) {
                    assert (!this.sendEmit);
                    return RecordBatch.IterOutcome.NONE;
                }
                if (this.sendEmit) {
                    this.first = false;
                    this.sendEmit = false;
                    this.firstBatchForDataSet = true;
                    this.firstBatchForSchema = false;
                    this.recordCount = 0;
                    this.container.setEmpty();
                    this.specialBatchSent = false;
                    return RecordBatch.IterOutcome.EMIT;
                }
                if (this.aggregator != null && !this.first) break block32;
                if (this.first && this.incoming.getRecordCount() > 0) {
                    this.first = false;
                    this.lastKnownOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                } else {
                    this.lastKnownOutcome = this.next(this.incoming);
                }
                logger.debug("Next outcome of {}", (Object)this.lastKnownOutcome);
                switch (this.lastKnownOutcome) {
                    case NONE: {
                        if (this.first && this.getKeyExpressions().size() == 0) {
                            this.constructSpecialBatch();
                            this.specialBatchSent = true;
                            return RecordBatch.IterOutcome.OK;
                        }
                    }
                    case NOT_YET: 
                    case OK_NEW_SCHEMA: {
                        this.createAggregator();
                        this.firstBatchForSchema = true;
                        break block33;
                    }
                    case EMIT: {
                        if (this.firstBatchForDataSet && this.getKeyExpressions().size() == 0 && this.incoming.getRecordCount() == 0) {
                            this.constructSpecialBatch();
                            return this.getFinalOutcome();
                        }
                    }
                    case OK: {
                        break block33;
                    }
                    default: {
                        throw new IllegalStateException(String.format("unknown outcome %s", new Object[]{this.lastKnownOutcome}));
                    }
                }
            }
            if (this.lastKnownOutcome != RecordBatch.IterOutcome.NONE && this.firstBatchForDataSet && !this.aggregator.isDone() && this.aggregator.previousBatchProcessed()) {
                this.lastKnownOutcome = this.incoming.next();
                if (!this.first) {
                    try {
                        this.aggregator.setup(this.oContext, this.incoming, this, this.maxOutputRowCount);
                    }
                    catch (SchemaChangeException e) {
                        UserException.Builder exceptionBuilder = UserException.functionError(e).message("A Schema change exception occured in calling setup() in generated code.", new Object[0]);
                        throw exceptionBuilder.build(logger);
                    }
                }
            }
        }
        StreamingAggregator.AggOutcome aggOutcome = this.aggregator.doWork(this.lastKnownOutcome);
        this.recordCount = this.aggregator.getOutputCount();
        this.container.setRecordCount(this.recordCount);
        logger.debug("Aggregator response {}, records {}", (Object)aggOutcome, (Object)this.aggregator.getOutputCount());
        RecordBatch.IterOutcome returnOutcome = this.aggregator.getOutcome();
        switch (aggOutcome) {
            case CLEANUP_AND_RETURN: {
                if (!this.first) {
                    this.container.zeroVectors();
                }
                this.done = true;
                ExternalSortBatch.releaseBatches(this.incoming);
                return returnOutcome;
            }
            case RETURN_AND_RESET: {
                if (this.firstBatchForDataSet && this.getKeyExpressions().size() == 0 && this.recordCount == 0) {
                    this.constructSpecialBatch();
                    return this.getFinalOutcome();
                }
                this.firstBatchForDataSet = true;
                this.firstBatchForSchema = false;
                if (this.first) {
                    this.first = false;
                }
                if (returnOutcome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                    this.sendEmit = this.aggregator == null || this.aggregator.previousBatchProcessed();
                }
                ExternalSortBatch.releaseBatches(this.incoming);
                this.lastKnownOutcome = RecordBatch.IterOutcome.EMIT;
                return returnOutcome;
            }
            case RETURN_OUTCOME: {
                if (this.complexWriters != null) {
                    this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                }
                if (returnOutcome == RecordBatch.IterOutcome.NONE) {
                    this.lastKnownOutcome = RecordBatch.IterOutcome.NONE;
                    if (this.first) {
                        this.first = false;
                        return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                    }
                    return RecordBatch.IterOutcome.OK;
                }
                if (returnOutcome == RecordBatch.IterOutcome.OK && this.first) {
                    this.lastKnownOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                    returnOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                }
                this.first = false;
                return returnOutcome;
            }
            case UPDATE_AGGREGATOR: {
                if (returnOutcome == RecordBatch.IterOutcome.EMIT) {
                    this.createAggregator();
                    this.lastKnownOutcome = RecordBatch.IterOutcome.EMIT;
                    return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                }
                throw UserException.schemaChangeError(SchemaChangeException.schemaChanged("Streaming aggregate does not support schema changes", this.incomingSchema, this.incoming.getSchema())).build(logger);
            }
        }
        throw new IllegalStateException(String.format("Unknown state %s.", new Object[]{aggOutcome}));
    }

    private void allocateComplexWriters() {
        if (this.complexWriters != null) {
            for (BaseWriter.ComplexWriter writer : this.complexWriters) {
                writer.allocate();
            }
        }
    }

    private void constructSpecialBatch() {
        int exprIndex = 0;
        for (VectorWrapper<?> vw : this.container) {
            Object vv = vw.getValueVector();
            AllocationHelper.allocateNew(vv, 1);
            vv.getMutator().setValueCount(1);
            if (vv.getField().getType().getMode() == TypeProtos.DataMode.REQUIRED) {
                if (vv instanceof FixedWidthVector) {
                    ((FixedWidthVector)vv).zeroVector();
                } else {
                    throw new DrillRuntimeException("FixedWidth vectors is the expected output vector type. Corresponding expression: " + this.getValueExpressions().get(exprIndex).toString());
                }
            }
            ++exprIndex;
        }
        this.container.setRecordCount(1);
        this.recordCount = 1;
    }

    private void createAggregator() {
        logger.debug("Creating new aggregator.");
        try {
            this.stats.startSetup();
            this.aggregator = this.createAggregatorInternal();
        }
        finally {
            this.stats.stopSetup();
        }
    }

    public void addComplexWriter(BaseWriter.ComplexWriter writer) {
        this.complexWriters.add(writer);
    }

    protected StreamingAggregator createAggregatorInternal() {
        MaterializedField outputField;
        LogicalExpression expr;
        NamedExpression ne;
        int i;
        ClassGenerator<StreamingAggregator> cg = CodeGenerator.getRoot(StreamingAggTemplate.TEMPLATE_DEFINITION, this.context.getOptions());
        this.container.clear();
        LogicalExpression[] keyExprs = new LogicalExpression[this.getKeyExpressions().size()];
        LogicalExpression[] valueExprs = new LogicalExpression[this.getValueExpressions().size()];
        TypedFieldId[] keyOutputIds = new TypedFieldId[this.getKeyExpressions().size()];
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        for (i = 0; i < keyExprs.length; ++i) {
            ne = this.getKeyExpressions().get(i);
            expr = ExpressionTreeMaterializer.materialize(ne.getExpr(), this.incoming, collector, this.context.getFunctionRegistry());
            if (expr == null) continue;
            keyExprs[i] = expr;
            outputField = MaterializedField.create(ne.getRef().getLastSegment().getNameSegment().getPath(), expr.getMajorType());
            this.container.addOrGet(outputField);
            keyOutputIds[i] = this.container.getValueVectorId(ne.getRef());
        }
        for (i = 0; i < valueExprs.length; ++i) {
            ne = this.getValueExpressions().get(i);
            expr = ExpressionTreeMaterializer.materialize(ne.getExpr(), this.incoming, (ErrorCollector)collector, this.context.getFunctionRegistry(), true, false);
            if (expr instanceof IfExpression) {
                throw UserException.unsupportedError(new UnsupportedOperationException("Union type not supported in aggregate functions")).build(logger);
            }
            if (expr == null) continue;
            if (expr instanceof DrillFuncHolderExpr && ((DrillFuncHolderExpr)expr).getHolder().isComplexWriterFuncHolder()) {
                if (this.complexWriters == null) {
                    this.complexWriters = Lists.newArrayList();
                } else {
                    this.complexWriters.clear();
                }
                ((DrillFuncHolderExpr)expr).setFieldReference(ne.getRef());
                MaterializedField field = MaterializedField.create(ne.getRef().getAsNamePart().getName(), UntypedNullHolder.TYPE);
                this.container.add(new UntypedNullVector(field, this.container.getAllocator()));
                valueExprs[i] = expr;
                continue;
            }
            outputField = MaterializedField.create(ne.getRef().getLastSegment().getNameSegment().getPath(), expr.getMajorType());
            this.container.addOrGet(outputField);
            TypedFieldId id = this.container.getValueVectorId(ne.getRef());
            valueExprs[i] = new ValueVectorWriteExpression(id, expr, true);
        }
        collector.reportErrors(logger);
        this.setupIsSame(cg, keyExprs);
        this.setupIsSameApart(cg, keyExprs);
        this.addRecordValues(cg, valueExprs);
        this.outputRecordKeys(cg, keyOutputIds, keyExprs);
        this.outputRecordKeysPrev(cg, keyOutputIds, keyExprs);
        cg.getBlock("resetValues")._return(JExpr.TRUE);
        this.getIndex(cg);
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        StreamingAggregator agg = this.context.getImplementationClass(cg);
        try {
            agg.setup(this.oContext, this.incoming, this, this.maxOutputRowCount);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        this.allocateComplexWriters();
        return agg;
    }

    protected List<NamedExpression> getValueExpressions() {
        return ((StreamingAggregate)this.popConfig).getExprs();
    }

    protected List<NamedExpression> getKeyExpressions() {
        return ((StreamingAggregate)this.popConfig).getKeys();
    }

    protected void setupIsSame(ClassGenerator<StreamingAggregator> cg, LogicalExpression[] keyExprs) {
        cg.setMappingSet(this.IS_SAME_I1);
        for (LogicalExpression expr : keyExprs) {
            cg.setMappingSet(this.IS_SAME_I1);
            ClassGenerator.HoldingContainer first = cg.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            cg.setMappingSet(this.IS_SAME_I2);
            ClassGenerator.HoldingContainer second = cg.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            LogicalExpression fh = FunctionGenerationHelper.getOrderingComparatorNullsHigh(first, second, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer out = cg.addExpr(fh, ClassGenerator.BlkCreateMode.FALSE);
            cg.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)))._then()._return(JExpr.FALSE);
        }
        cg.getEvalBlock()._return(JExpr.TRUE);
    }

    protected void setupIsSameApart(ClassGenerator<StreamingAggregator> cg, LogicalExpression[] keyExprs) {
        cg.setMappingSet(this.ISA_B1);
        for (LogicalExpression expr : keyExprs) {
            cg.setMappingSet(this.ISA_B1);
            ClassGenerator.HoldingContainer first = cg.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            cg.setMappingSet(this.ISA_B2);
            ClassGenerator.HoldingContainer second = cg.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            LogicalExpression fh = FunctionGenerationHelper.getOrderingComparatorNullsHigh(first, second, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer out = cg.addExpr(fh, ClassGenerator.BlkCreateMode.FALSE);
            cg.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)))._then()._return(JExpr.FALSE);
        }
        cg.getEvalBlock()._return(JExpr.TRUE);
    }

    protected void addRecordValues(ClassGenerator<StreamingAggregator> cg, LogicalExpression[] valueExprs) {
        cg.setMappingSet(this.EVAL);
        for (LogicalExpression ex : valueExprs) {
            cg.addExpr(ex);
        }
    }

    protected void outputRecordKeys(ClassGenerator<StreamingAggregator> cg, TypedFieldId[] keyOutputIds, LogicalExpression[] keyExprs) {
        cg.setMappingSet(this.RECORD_KEYS);
        for (int i = 0; i < keyExprs.length; ++i) {
            cg.addExpr(new ValueVectorWriteExpression(keyOutputIds[i], keyExprs[i], true));
        }
    }

    protected void outputRecordKeysPrev(ClassGenerator<StreamingAggregator> cg, TypedFieldId[] keyOutputIds, LogicalExpression[] keyExprs) {
        cg.setMappingSet(this.RECORD_KEYS_PREV);
        for (int i = 0; i < keyExprs.length; ++i) {
            logger.debug("Writing out expr {}", (Object)keyExprs[i]);
            cg.rotateBlock();
            cg.setMappingSet(this.RECORD_KEYS_PREV);
            ClassGenerator.HoldingContainer innerExpression = cg.addExpr(keyExprs[i], ClassGenerator.BlkCreateMode.FALSE);
            cg.setMappingSet(this.RECORD_KEYS_PREV_OUT);
            cg.addExpr(new ValueVectorWriteExpression(keyOutputIds[i], new HoldingContainerExpression(innerExpression), true), ClassGenerator.BlkCreateMode.FALSE);
        }
    }

    protected void getIndex(ClassGenerator<StreamingAggregator> g) {
        switch (this.incoming.getSchema().getSelectionVectorMode()) {
            case FOUR_BYTE: {
                JVar var = g.declareClassField("sv4_", g.getModel()._ref(SelectionVector4.class));
                g.getBlock("setupInterior").assign((JAssignmentTarget)var, (JExpression)JExpr.direct((String)"incoming").invoke("getSelectionVector4"));
                g.getBlock("getVectorIndex")._return((JExpression)var.invoke("get").arg(JExpr.direct((String)"recordIndex")));
                return;
            }
            case NONE: {
                g.getBlock("getVectorIndex")._return(JExpr.direct((String)"recordIndex"));
                return;
            }
            case TWO_BYTE: {
                JVar var = g.declareClassField("sv2_", g.getModel()._ref(SelectionVector2.class));
                g.getBlock("setupInterior").assign((JAssignmentTarget)var, (JExpression)JExpr.direct((String)"incoming").invoke("getSelectionVector2"));
                g.getBlock("getVectorIndex")._return((JExpression)var.invoke("getIndex").arg(JExpr.direct((String)"recordIndex")));
                return;
            }
        }
        throw new IllegalStateException();
    }

    private RecordBatch.IterOutcome getFinalOutcome() {
        RecordBatch.IterOutcome outcomeToReturn;
        if (this.firstBatchForDataSet) {
            this.firstBatchForDataSet = false;
        }
        if (this.firstBatchForSchema) {
            outcomeToReturn = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            this.sendEmit = true;
            this.firstBatchForSchema = false;
        } else if (this.lastKnownOutcome == RecordBatch.IterOutcome.EMIT) {
            this.firstBatchForDataSet = true;
            outcomeToReturn = RecordBatch.IterOutcome.EMIT;
        } else {
            outcomeToReturn = this.recordCount == 0 ? RecordBatch.IterOutcome.NONE : RecordBatch.IterOutcome.OK;
        }
        return outcomeToReturn;
    }

    @Override
    protected void cancelIncoming() {
        this.incoming.cancel();
    }

    @Override
    public void dump() {
        logger.error("StreamingAggBatch[container={}, popConfig={}, aggregator={}, incomingSchema={}]", new Object[]{this.container, this.popConfig, this.aggregator, this.incomingSchema});
    }

    @VisibleForTesting
    public void setMaxOutputRowCount(int maxOutputRowCount) {
        this.maxOutputRowCount = maxOutputRowCount;
    }
}

