/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.aggregate;

import java.util.Iterator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalBatch
implements Iterable<VectorWrapper<?>> {
    static final Logger logger = LoggerFactory.getLogger(InternalBatch.class);
    private final VectorContainer container;
    private final FragmentContext context;
    private final BatchSchema schema;
    private final SelectionVector2 sv2;
    private final SelectionVector4 sv4;

    public InternalBatch(RecordBatch incoming, OperatorContext oContext) {
        this(incoming, null, oContext);
    }

    public InternalBatch(RecordBatch incoming, VectorWrapper<?>[] ignoreWrappers, OperatorContext oContext) {
        switch (incoming.getSchema().getSelectionVectorMode()) {
            case FOUR_BYTE: {
                this.sv4 = incoming.getSelectionVector4().createNewWrapperCurrent();
                this.sv2 = null;
                break;
            }
            case TWO_BYTE: {
                this.sv4 = null;
                this.sv2 = incoming.getSelectionVector2().clone();
                break;
            }
            default: {
                this.sv4 = null;
                this.sv2 = null;
            }
        }
        this.schema = incoming.getSchema();
        this.context = incoming.getContext();
        this.container = VectorContainer.getTransferClone(incoming, ignoreWrappers, oContext);
    }

    public BatchSchema getSchema() {
        return this.schema;
    }

    public SelectionVector2 getSv2() {
        return this.sv2;
    }

    public SelectionVector4 getSv4() {
        return this.sv4;
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    public void clear() {
        if (this.sv2 != null) {
            this.sv2.clear();
        }
        if (this.sv4 != null) {
            this.sv4.clear();
        }
        this.container.clear();
    }

    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int[] fieldIds) {
        return this.container.getValueAccessorById(clazz, fieldIds);
    }

    public FragmentContext getContext() {
        return this.context;
    }
}

