/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.TopN;

import io.netty.buffer.DrillBuf;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.TopN.PriorityQueue;
import org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.ExpandableHyperContainer;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PriorityQueueTemplate
implements PriorityQueue {
    private static final Logger logger = LoggerFactory.getLogger(PriorityQueueTemplate.class);
    public static final int EST_MAX_QUEUE_SIZE = 4000;
    private SelectionVector4 heapSv4;
    private SelectionVector4 finalSv4;
    private ExpandableHyperContainer hyperBatch;
    private BufferAllocator allocator;
    private int limit;
    private int queueSize;
    private int batchCount;
    private boolean hasSv2;

    @Override
    public void init(int limit, BufferAllocator allocator, boolean hasSv2) throws SchemaChangeException {
        this.limit = limit;
        this.allocator = allocator;
        DrillBuf drillBuf = allocator.buffer(4 * (limit + 1));
        this.heapSv4 = new SelectionVector4(drillBuf, limit, 65535);
        this.hasSv2 = hasSv2;
    }

    @Override
    public void resetQueue(VectorContainer container, SelectionVector4 v4) throws SchemaChangeException {
        assert (container.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE);
        BatchSchema schema = container.getSchema();
        VectorContainer newContainer = new VectorContainer();
        for (MaterializedField field : schema) {
            int[] ids = container.getValueVectorId(SchemaPath.getSimplePath(field.getName())).getFieldIds();
            newContainer.add(container.getValueAccessorById(field.getValueClass(), ids).getValueVectors());
        }
        newContainer.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
        this.cleanup();
        this.hyperBatch = new ExpandableHyperContainer(newContainer);
        this.batchCount = this.hyperBatch.iterator().next().getValueVectors().length;
        DrillBuf drillBuf = this.allocator.buffer(4 * (this.limit + 1));
        this.heapSv4 = new SelectionVector4(drillBuf, this.limit, 65535);
        this.queueSize = 0;
        for (int i = 0; i < v4.getTotalCount(); ++i) {
            this.heapSv4.set(i, v4.get(i));
            ++this.queueSize;
        }
        v4.clear();
        this.doSetup(this.hyperBatch, null);
    }

    @Override
    public void add(RecordBatchData batch) throws SchemaChangeException {
        Stopwatch watch = Stopwatch.createStarted();
        if (this.hyperBatch == null) {
            this.hyperBatch = new ExpandableHyperContainer(batch.getContainer());
        } else {
            this.hyperBatch.addBatch(batch.getContainer());
        }
        this.doSetup(this.hyperBatch, null);
        int count = 0;
        SelectionVector2 sv2 = null;
        if (this.hasSv2) {
            sv2 = batch.getSv2();
        }
        while (this.queueSize < this.limit && count < batch.getRecordCount()) {
            this.heapSv4.set(this.queueSize, this.batchCount, this.hasSv2 ? (int)sv2.getIndex(count) : count);
            ++this.queueSize;
            this.siftUp();
            ++count;
        }
        while (count < batch.getRecordCount()) {
            this.heapSv4.set(this.limit, this.batchCount, this.hasSv2 ? (int)sv2.getIndex(count) : count);
            if (this.compare(this.limit, 0) < 0) {
                this.swap(this.limit, 0);
                this.siftDown();
            }
            ++count;
        }
        ++this.batchCount;
        if (this.hasSv2) {
            sv2.clear();
        }
        logger.debug("Took {} us to add {} records", (Object)watch.elapsed(TimeUnit.MICROSECONDS), (Object)count);
    }

    @Override
    public void generate() {
        Stopwatch watch = Stopwatch.createStarted();
        DrillBuf drillBuf = this.allocator.buffer(4 * this.queueSize);
        this.finalSv4 = new SelectionVector4(drillBuf, this.queueSize, 4000);
        for (int i = this.queueSize - 1; i >= 0; --i) {
            this.finalSv4.set(i, this.pop());
        }
        logger.debug("Took {} us to generate output of {}", (Object)watch.elapsed(TimeUnit.MICROSECONDS), (Object)this.finalSv4.getTotalCount());
    }

    @Override
    public VectorContainer getHyperBatch() {
        return this.hyperBatch;
    }

    @Override
    public SelectionVector4 getSv4() {
        return this.heapSv4;
    }

    @Override
    public SelectionVector4 getFinalSv4() {
        return this.finalSv4;
    }

    @Override
    public void cleanup() {
        if (this.heapSv4 != null) {
            this.heapSv4.clear();
            this.heapSv4 = null;
        }
        if (this.hyperBatch != null) {
            this.hyperBatch.clear();
            this.hyperBatch = null;
        }
        if (this.finalSv4 != null) {
            this.finalSv4.clear();
            this.finalSv4 = null;
        }
        this.batchCount = 0;
    }

    @Override
    public boolean isInitialized() {
        return this.heapSv4 != null;
    }

    private void siftUp() throws SchemaChangeException {
        int p = this.queueSize - 1;
        while (p > 0 && this.compare(p, (p - 1) / 2) > 0) {
            this.swap(p, (p - 1) / 2);
            p = (p - 1) / 2;
        }
    }

    private void siftDown() throws SchemaChangeException {
        int next;
        int p = 0;
        while (p * 2 + 1 < this.queueSize && this.compare(p, next = p * 2 + 2 >= this.queueSize ? p * 2 + 1 : (this.compare(p * 2 + 1, p * 2 + 2) >= 0 ? p * 2 + 1 : p * 2 + 2)) < 0) {
            this.swap(p, next);
            p = next;
        }
    }

    public int pop() {
        int value = this.heapSv4.get(0);
        this.swap(0, this.queueSize - 1);
        --this.queueSize;
        try {
            this.siftDown();
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
        return value;
    }

    public void swap(int sv0, int sv1) {
        int tmp = this.heapSv4.get(sv0);
        this.heapSv4.set(sv0, this.heapSv4.get(sv1));
        this.heapSv4.set(sv1, tmp);
    }

    public int compare(int leftIndex, int rightIndex) throws SchemaChangeException {
        int sv1 = this.heapSv4.get(leftIndex);
        int sv2 = this.heapSv4.get(rightIndex);
        return this.doEval(sv1, sv2);
    }

    public abstract void doSetup(@Named(value="incoming") VectorContainer var1, @Named(value="outgoing") RecordBatch var2) throws SchemaChangeException;

    public abstract int doEval(@Named(value="leftIndex") int var1, @Named(value="rightIndex") int var2) throws SchemaChangeException;
}

