/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.util.List;
import org.apache.drill.exec.ops.AccountingUserConnection;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.ops.RootFragmentContext;
import org.apache.drill.exec.physical.config.Screen;
import org.apache.drill.exec.physical.impl.BaseRootExec;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.physical.impl.materialize.QueryDataPackage;
import org.apache.drill.exec.physical.impl.materialize.VectorRecordMaterializer;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenCreator
implements RootCreator<Screen> {
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(ScreenCreator.class);

    @Override
    public RootExec getRoot(ExecutorFragmentContext context, Screen config, List<RecordBatch> children) {
        Preconditions.checkNotNull(children);
        Preconditions.checkArgument(children.size() == 1);
        return new ScreenRoot((RootFragmentContext)context, children.iterator().next(), config);
    }

    public static class ScreenRoot
    extends BaseRootExec {
        private static final Logger logger = LoggerFactory.getLogger(ScreenRoot.class);
        private final RecordBatch incoming;
        private final RootFragmentContext context;
        private final AccountingUserConnection userConnection;
        private QueryDataPackage.DataPackage dataPackage;
        private boolean firstBatch = true;

        public ScreenRoot(RootFragmentContext context, RecordBatch incoming, Screen config) {
            super(context, config);
            this.context = context;
            this.incoming = incoming;
            this.userConnection = context.getUserDataTunnel();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean innerNext() {
            RecordBatch.IterOutcome outcome = this.next(this.incoming);
            logger.trace("Screen Outcome {}", (Object)outcome);
            switch (outcome) {
                case NONE: {
                    if (!this.firstBatch) return false;
                    this.stats.startWait();
                    try {
                        this.userConnection.sendData(new QueryDataPackage.EmptyResultsPackage(this.context.getHandle().getQueryId()));
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    this.firstBatch = false;
                    return false;
                }
                case OK_NEW_SCHEMA: {
                    this.dataPackage = new QueryDataPackage.DataPackage(new VectorRecordMaterializer(this.context, this.oContext, this.incoming), this.stats);
                }
                case OK: {
                    injector.injectPause(this.context.getExecutionControls(), "sending-data", logger);
                    this.stats.startWait();
                    try {
                        this.userConnection.sendData(this.dataPackage);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    this.firstBatch = false;
                    return true;
                }
            }
            throw new UnsupportedOperationException(outcome.name());
        }

        public RootFragmentContext getContext() {
            return this.context;
        }

        protected RecordBatch getIncoming() {
            return this.incoming;
        }

        @Override
        public void close() throws Exception {
            injector.injectPause(this.context.getExecutionControls(), "send-complete", logger);
            super.close();
        }

        public static enum Metric implements MetricDef
        {
            BYTES_SENT;


            @Override
            public int metricId() {
                return this.ordinal();
            }
        }
    }
}

