/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorCreatorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(OperatorCreatorRegistry.class);
    private volatile Map<Class<?>, Constructor<?>> constructorRegistry = new HashMap();
    private volatile Map<Class<?>, Object> instanceRegistry = new HashMap();

    public OperatorCreatorRegistry(ScanResult scanResult) {
        this.addImplementorsToMap(scanResult, BatchCreator.class);
        this.addImplementorsToMap(scanResult, RootCreator.class);
        logger.debug("Adding Operator Creator map: {}", this.constructorRegistry);
    }

    public synchronized Object getOperatorCreator(Class<?> operator) throws ExecutionSetupException {
        Object opCreator = this.instanceRegistry.get(operator);
        if (opCreator != null) {
            return opCreator;
        }
        Constructor<?> c = this.constructorRegistry.get(operator);
        if (c == null) {
            throw new ExecutionSetupException(String.format("Failure finding OperatorCreator constructor for config %s", operator.getCanonicalName()));
        }
        try {
            opCreator = c.newInstance(new Object[0]);
            this.instanceRegistry.put(operator, opCreator);
            return opCreator;
        }
        catch (Throwable t) {
            throw ExecutionSetupException.fromThrowable(String.format("Failure creating OperatorCreator for Operator %s", operator.getCanonicalName()), t);
        }
    }

    private <T> void addImplementorsToMap(ScanResult scanResult, Class<T> baseInterface) {
        Set<Class<T>> providerClasses = scanResult.getImplementations(baseInterface);
        Iterator<Class<T>> iterator = providerClasses.iterator();
        while (iterator.hasNext()) {
            Class<T> c;
            Class<T> operatorClass = c = iterator.next();
            boolean interfaceFound = false;
            while (!interfaceFound && !c.equals(Object.class)) {
                Type[] ifaces;
                for (Type iface : ifaces = c.getGenericInterfaces()) {
                    if (!(iface instanceof ParameterizedType) || !((ParameterizedType)iface).getRawType().equals(baseInterface)) continue;
                    Type[] args = ((ParameterizedType)iface).getActualTypeArguments();
                    interfaceFound = true;
                    boolean constructorFound = false;
                    for (Constructor<?> constructor : operatorClass.getConstructors()) {
                        Class<?>[] params = constructor.getParameterTypes();
                        if (params.length != 0) continue;
                        Constructor<?> old = this.constructorRegistry.put((Class)args[0], constructor);
                        if (old != null) {
                            throw new RuntimeException(String.format("Duplicate OperatorCreator [%s, %s] found for PhysicalOperator %s", old.getDeclaringClass().getCanonicalName(), operatorClass.getCanonicalName(), ((Class)args[0]).getCanonicalName()));
                        }
                        constructorFound = true;
                    }
                    if (constructorFound) continue;
                    logger.debug("Skipping registration of OperatorCreator {} as it doesn't have a default constructor", (Object)operatorClass.getCanonicalName());
                }
                c = c.getSuperclass();
            }
        }
    }
}

