/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.physical.config.MergingReceiverPOP;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.mergereceiver.MergingRecordBatch;
import org.apache.drill.exec.record.RawFragmentBatchProvider;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergingReceiverCreator
implements BatchCreator<MergingReceiverPOP> {
    static final Logger logger = LoggerFactory.getLogger(MergingReceiverCreator.class);

    public MergingRecordBatch getBatch(ExecutorFragmentContext context, MergingReceiverPOP receiver, List<RecordBatch> children) throws ExecutionSetupException, OutOfMemoryException {
        assert (children == null || children.isEmpty());
        IncomingBuffers bufHolder = context.getBuffers();
        assert (bufHolder != null) : "IncomingBuffers must be defined for any place a receiver is declared.";
        RawFragmentBatchProvider[] buffers = bufHolder.getCollector(receiver.getOppositeMajorFragmentId()).getBuffers();
        return new MergingRecordBatch(context, receiver, buffers);
    }
}

