/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.util.List;
import org.apache.drill.common.DeferredException;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.OpProfileDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.ops.OperatorUtilities;
import org.apache.drill.exec.ops.RootFragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRootExec
implements RootExec {
    private static final Logger logger = LoggerFactory.getLogger(BaseRootExec.class);
    public static final String ENABLE_BATCH_DUMP_CONFIG = "drill.exec.debug.dump_batches";
    protected OperatorStats stats;
    protected OperatorContext oContext;
    protected RootFragmentContext fragmentContext;
    private List<CloseableRecordBatch> operators;

    public BaseRootExec(RootFragmentContext fragmentContext, PhysicalOperator config) throws OutOfMemoryException {
        this(fragmentContext, null, config);
    }

    public BaseRootExec(RootFragmentContext fragmentContext, OperatorContext oContext, PhysicalOperator config) throws OutOfMemoryException {
        this.oContext = oContext == null ? fragmentContext.newOperatorContext(config, this.stats) : oContext;
        this.stats = new OperatorStats(new OpProfileDef(config.getOperatorId(), config.getOperatorType(), OperatorUtilities.getChildCount(config)), this.oContext.getAllocator());
        fragmentContext.getStats().addOperatorStats(this.stats);
        this.fragmentContext = fragmentContext;
    }

    void setOperators(List<CloseableRecordBatch> operators) {
        this.operators = operators;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("BaseRootExec(");
            sb.append(Integer.toString(System.identityHashCode(this)));
            sb.append(") operators: ");
            for (CloseableRecordBatch crb : operators) {
                sb.append(crb.getClass().getName());
                sb.append(' ');
                sb.append(Integer.toString(System.identityHashCode(crb)));
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            logger.debug(sb.toString());
        }
    }

    @Override
    public final boolean next() {
        assert (this.stats != null);
        this.fragmentContext.getExecutorState().checkContinue();
        try {
            this.stats.startProcessing();
            boolean bl = this.innerNext();
            return bl;
        }
        finally {
            this.stats.stopProcessing();
        }
    }

    public final RecordBatch.IterOutcome next(RecordBatch b) {
        RecordBatch.IterOutcome next;
        this.stats.stopProcessing();
        try {
            next = b.next();
        }
        finally {
            this.stats.startProcessing();
        }
        switch (next) {
            case OK_NEW_SCHEMA: {
                this.stats.batchReceived(0, b.getRecordCount(), true);
                break;
            }
            case OK: {
                this.stats.batchReceived(0, b.getRecordCount(), false);
                break;
            }
        }
        return next;
    }

    public abstract boolean innerNext();

    @Override
    public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
        logger.warn("Currently not handling FinishedFragment message");
    }

    @Override
    public void dumpBatches(Throwable t) {
        if (this.operators == null) {
            return;
        }
        if (!this.fragmentContext.getConfig().getBoolean(ENABLE_BATCH_DUMP_CONFIG)) {
            return;
        }
        CloseableRecordBatch leafMost = BaseRootExec.findLeaf(this.operators, t);
        if (leafMost == null) {
            return;
        }
        int batchPosn = this.operators.indexOf(leafMost);
        int numberOfBatchesToDump = Math.min(batchPosn + 1, 2);
        logger.error("Batch dump started: dumping last {} failed batches", (Object)numberOfBatchesToDump);
        for (int i = 0; i < numberOfBatchesToDump; ++i) {
            this.operators.get(batchPosn--).dump();
        }
        logger.error("Batch dump completed.");
    }

    @Override
    public void close() throws Exception {
        try {
            this.stats.startProcessing();
            this.stats.startWait();
            this.fragmentContext.waitForSendComplete();
        }
        finally {
            this.stats.stopWait();
            this.stats.stopProcessing();
        }
        if (this.operators != null) {
            DeferredException df = new DeferredException();
            for (CloseableRecordBatch crb : this.operators) {
                df.suppressingClose(crb);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("closed operator %d", System.identityHashCode(crb)));
            }
            try {
                df.close();
            }
            catch (Exception e) {
                this.fragmentContext.getExecutorState().fail(e);
            }
        }
    }

    public static <T> T findLeaf(List<T> dag, Throwable e) {
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = dag.size() - 1; i >= 0; --i) {
            T leaf = dag.get(i);
            String opName = leaf.getClass().getName();
            for (StackTraceElement element : trace) {
                String frameName = element.getClassName();
                if (!frameName.contentEquals(opName)) continue;
                return leaf;
            }
        }
        return null;
    }
}

