/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.config.AbstractDeMuxExchange;
import org.apache.drill.exec.physical.config.UnorderedReceiver;

@JsonTypeName(value="unordered-demux-exchange")
public class UnorderedDeMuxExchange
extends AbstractDeMuxExchange {
    public UnorderedDeMuxExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr) {
        super(child, expr);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        this.createSenderReceiverMapping();
        MinorFragmentEndpoint sender = (MinorFragmentEndpoint)this.receiverToSenderMapping.get(minorFragmentId);
        if (sender == null) {
            throw new IllegalStateException(String.format("Failed to find sender for receiver [%d]", minorFragmentId));
        }
        return new UnorderedReceiver(this.senderMajorFragmentId, Collections.singletonList(sender), false);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new UnorderedDeMuxExchange(child, this.expr);
    }
}

