/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.MergingReceiverPOP;
import org.apache.drill.exec.physical.config.SingleSender;
import org.apache.drill.exec.planner.fragment.ParallelizationInfo;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="single-merge-exchange")
public class SingleMergeExchange
extends AbstractExchange {
    private final List<Order.Ordering> orderExpr;

    @JsonCreator
    public SingleMergeExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="orderings") List<Order.Ordering> orderExpr) {
        super(child);
        this.orderExpr = orderExpr;
    }

    @Override
    public ParallelizationInfo getReceiverParallelizationInfo(List<CoordinationProtos.DrillbitEndpoint> senderFragmentEndpoints) {
        Preconditions.checkArgument(senderFragmentEndpoints != null && senderFragmentEndpoints.size() > 0, "Sender fragment endpoint list should not be empty");
        return ParallelizationInfo.create(1, 1, SingleMergeExchange.getDefaultAffinityMap(senderFragmentEndpoints));
    }

    @Override
    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        Preconditions.checkArgument(receiverLocations.size() == 1, "SingleMergeExchange only supports a single receiver endpoint.");
        super.setupReceivers(receiverLocations);
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new SingleSender(this.receiverMajorFragmentId, child, (CoordinationProtos.DrillbitEndpoint)this.receiverLocations.iterator().next());
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new MergingReceiverPOP(this.senderMajorFragmentId, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.senderLocations), this.orderExpr, false);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new SingleMergeExchange(child, this.orderExpr);
    }

    @JsonProperty(value="orderings")
    public List<Order.Ordering> getOrderings() {
        return this.orderExpr;
    }
}

