/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.List;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractStore;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.proto.CoordinationProtos;

@JsonTypeName(value="screen")
public class Screen
extends AbstractStore {
    public static final String OPERATOR_TYPE = "SCREEN";
    private final CoordinationProtos.DrillbitEndpoint endpoint;

    public Screen(@JsonProperty(value="child") PhysicalOperator child, @JacksonInject CoordinationProtos.DrillbitEndpoint endpoint) {
        super(child);
        assert (endpoint != null);
        this.endpoint = endpoint;
    }

    @Override
    public List<EndpointAffinity> getOperatorAffinity() {
        return Collections.singletonList(new EndpointAffinity(this.endpoint, 1.0, true, 1));
    }

    @Override
    public int getMaxWidth() {
        return 1;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) throws PhysicalOperatorSetupException {
        if (endpoints.size() != 1) {
            throw new PhysicalOperatorSetupException("A Screen operator can only be assigned to a single node.");
        }
        CoordinationProtos.DrillbitEndpoint endpoint = endpoints.iterator().next();
        if (!endpoint.equals(this.endpoint)) {
            throw new PhysicalOperatorSetupException(String.format("A Screen operator can only be assigned to its home node.  Expected endpoint %s, Actual endpoint: %s", this.endpoint, endpoint));
        }
    }

    @Override
    public Store getSpecificStore(PhysicalOperator child, int minorFragmentId) {
        return new Screen(child, this.endpoint);
    }

    @JsonIgnore
    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return "Screen [endpoint=" + this.endpoint + ", getChild()=" + this.getChild() + "]";
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new Screen(child, this.endpoint);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitScreen(this, value);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public DistributionAffinity getDistributionAffinity() {
        return DistributionAffinity.HARD;
    }
}

