/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;

@JsonTypeName(value="rowkey-join")
public class RowKeyJoinPOP
extends AbstractBase {
    public static final String OPERATOR_TYPE = "ROWKEY_JOIN";
    private final PhysicalOperator left;
    private final PhysicalOperator right;
    @JsonProperty(value="subScanForRowKeyJoin")
    private SubScan subScanForRowKeyJoin;

    @JsonCreator
    public RowKeyJoinPOP(@JsonProperty(value="left") PhysicalOperator left, @JsonProperty(value="right") PhysicalOperator right) {
        this.left = left;
        this.right = right;
        this.subScanForRowKeyJoin = null;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitRowKeyJoin(this, value);
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.size() == 2);
        RowKeyJoinPOP rj = new RowKeyJoinPOP(children.get(0), children.get(1));
        rj.setSubScanForRowKeyJoin(this.getSubScanForRowKeyJoin());
        return rj;
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Iterators.forArray(this.left, this.right);
    }

    public PhysicalOperator getLeft() {
        return this.left;
    }

    public PhysicalOperator getRight() {
        return this.right;
    }

    @JsonProperty(value="subScanForRowKeyJoin")
    public SubScan getSubScanForRowKeyJoin() {
        return this.subScanForRowKeyJoin;
    }

    public void setSubScanForRowKeyJoin(SubScan subScan) {
        this.subScanForRowKeyJoin = subScan;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

