/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractSender;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.planner.physical.PartitionFunction;

@JsonTypeName(value="range-partition-sender")
public class RangePartitionSender
extends AbstractSender {
    public static final int RANGE_PARTITION_OUTGOING_BATCH_SIZE = 4095;
    public static final String OPERATOR_TYPE = "RANGE_PARTITION_SENDER";
    @JsonProperty(value="partitionFunction")
    private final PartitionFunction partitionFunction;

    @JsonCreator
    public RangePartitionSender(@JsonProperty(value="receiver-major-fragment") int oppositeMajorFragmentId, @JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="destinations") List<MinorFragmentEndpoint> endpoints, @JsonProperty(value="partitionFunction") PartitionFunction partitionFunction) {
        super(oppositeMajorFragmentId, child, endpoints);
        this.partitionFunction = partitionFunction;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new RangePartitionSender(this.oppositeMajorFragmentId, child, this.destinations, this.partitionFunction);
    }

    @JsonProperty(value="partitionFunction")
    public PartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitRangePartitionSender(this, value);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

