/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.RangePartitionSender;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.planner.physical.PartitionFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="range-partition-exchange")
public class RangePartitionExchange
extends AbstractExchange {
    static final Logger logger = LoggerFactory.getLogger(RangePartitionExchange.class);
    private final PartitionFunction partitionFunction;

    @JsonCreator
    public RangePartitionExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="partition-function") PartitionFunction partitionFunction) {
        super(child);
        this.partitionFunction = partitionFunction;
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new RangePartitionSender(this.receiverMajorFragmentId, child, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.receiverLocations), this.partitionFunction);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new UnorderedReceiver(this.senderMajorFragmentId, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.senderLocations), false);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new RangePartitionExchange(child, this.partitionFunction);
    }
}

