/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.physical.base.AbstractJoinPop;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

@JsonTypeName(value="merge-join")
public class MergeJoinPOP
extends AbstractJoinPop {
    public static final String OPERATOR_TYPE = "MERGE_JOIN";

    @JsonCreator
    public MergeJoinPOP(@JsonProperty(value="left") PhysicalOperator left, @JsonProperty(value="right") PhysicalOperator right, @JsonProperty(value="conditions") List<JoinCondition> conditions, @JsonProperty(value="joinType") JoinRelType joinType) {
        super(left, right, joinType, false, null, conditions);
        Preconditions.checkArgument(joinType != null, "Join type is missing!");
        Preconditions.checkArgument(joinType != JoinRelType.FULL, "Full outer join not currently supported with Merge Join");
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.size() == 2);
        return new MergeJoinPOP(children.get(0), children.get(1), this.conditions, this.joinType);
    }

    public MergeJoinPOP flipIfRight() {
        if (this.joinType == JoinRelType.RIGHT) {
            ArrayList<JoinCondition> flippedConditions = Lists.newArrayList();
            for (JoinCondition c : this.conditions) {
                flippedConditions.add(c.flip());
            }
            return new MergeJoinPOP(this.right, this.left, flippedConditions, JoinRelType.LEFT);
        }
        return this;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

