/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hash-to-random-exchange")
public class HashToRandomExchange
extends AbstractExchange {
    static final Logger logger = LoggerFactory.getLogger(HashToRandomExchange.class);
    private static final boolean HASH_EXCHANGE_SPOOLING = "true".equals(System.getProperty("drill.hash_exchange_spooling", "false"));
    private final LogicalExpression expr;

    @JsonCreator
    public HashToRandomExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr) {
        super(child);
        this.expr = expr;
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new HashPartitionSender(this.receiverMajorFragmentId, child, this.expr, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.receiverLocations));
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new UnorderedReceiver(this.senderMajorFragmentId, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.senderLocations), HASH_EXCHANGE_SPOOLING);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new HashToRandomExchange(child, this.expr);
    }

    @JsonProperty(value="expr")
    public LogicalExpression getExpression() {
        return this.expr;
    }
}

